/**
 ********************************************************************************
 *** BaseNaviItemAction.java                                                  ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import net.anotheria.anosite.gen.shared.action.BaseSitexAction;
import jakarta.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.assitedata.data.NaviItem;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseNaviItemAction extends BaseSitexAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "NaviItem";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASSiteData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "NaviItem";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, NaviItem naviitem) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASSiteData.NaviItem").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.NaviItem", naviitem, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.NaviItem", naviitem, "title");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.title", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.NaviItem", naviitem, "icon");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.icon", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.NaviItem", naviitem, "externalLink");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.externalLink", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.NaviItem", naviitem, "popup");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.popup", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.NaviItem", naviitem, "className");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.className", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.NaviItem", naviitem, "subNavi");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.subNavi", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.NaviItem", naviitem, "guards");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.guards", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockNaviItems(NaviItem naviitem, HttpServletRequest req) throws Exception{
		if(naviitem instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)naviitem;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASSiteDataService().updateNaviItem( naviitem);
			logger.info("Lock-OPERATION, document with id : ["+naviitem.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockNaviItems(NaviItem naviitem, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(naviitem instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)naviitem;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASSiteDataService().updateNaviItem( naviitem);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+naviitem.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+naviitem.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkNaviItems(NaviItem naviitem, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = naviitem instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)naviitem).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)naviitem).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockNaviItems(naviitem, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateNaviItems(NaviItem naviitem, HttpServletRequest req) throws Exception{
		if(naviitem instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)naviitem, false, getUserId(req));
		}
		if (isTimeoutReached(naviitem)) {
			checkNaviItems(naviitem, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(naviitem, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(NaviItem naviitem){
		if (naviitem instanceof LockableObject) {
			LockableObject lock = (LockableObject)naviitem;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(NaviItem naviitem, HttpServletRequest req){
		if (naviitem instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)naviitem;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
