/**
 ********************************************************************************
 *** BaseMediaLinkAction.java                                                 ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import net.anotheria.anosite.gen.shared.action.BaseSitexAction;
import jakarta.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.assitedata.data.MediaLink;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseMediaLinkAction extends BaseSitexAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "MediaLink";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASSiteData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "MediaLink";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, MediaLink medialink) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASSiteData.MediaLink").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.MediaLink", medialink, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.MediaLink", medialink, "href");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.href", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.MediaLink", medialink, "type");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.type", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.MediaLink", medialink, "media");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.media", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.MediaLink", medialink, "rel");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.rel", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.MediaLink", medialink, "rev");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.rev", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.MediaLink", medialink, "charset");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.charset", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.MediaLink", medialink, "hreflang");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.hreflang", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.MediaLink", medialink, "browserFiltering");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.browserFiltering", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.MediaLink", medialink, "onload");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.onload", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.MediaLink", medialink, "guards");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.guards", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockMediaLinks(MediaLink medialink, HttpServletRequest req) throws Exception{
		if(medialink instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)medialink;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASSiteDataService().updateMediaLink( medialink);
			logger.info("Lock-OPERATION, document with id : ["+medialink.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockMediaLinks(MediaLink medialink, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(medialink instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)medialink;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASSiteDataService().updateMediaLink( medialink);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+medialink.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+medialink.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkMediaLinks(MediaLink medialink, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = medialink instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)medialink).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)medialink).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockMediaLinks(medialink, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateMediaLinks(MediaLink medialink, HttpServletRequest req) throws Exception{
		if(medialink instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)medialink, false, getUserId(req));
		}
		if (isTimeoutReached(medialink)) {
			checkMediaLinks(medialink, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(medialink, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(MediaLink medialink){
		if (medialink instanceof LockableObject) {
			LockableObject lock = (LockableObject)medialink;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(MediaLink medialink, HttpServletRequest req){
		if (medialink instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)medialink;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
