/**
 ********************************************************************************
 *** FilteredIPDocument.java                                                  ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assiteconfig.data;

import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.util.crypt.MD5Util;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.BasicComparable;

public class FilteredIPDocument extends AbstractASGDocument implements FilteredIP, IComparable{

	public FilteredIPDocument() {
		super("");
	}

	public FilteredIPDocument(String id){
		super(id);
	}

	public FilteredIPDocument(FilteredIPDocument toClone){
		super(toClone);
	}

	FilteredIPDocument(FilteredIPBuilder builder){
		super("");
		setIpAddress(builder.ipAddress);
		setMask(builder.mask);
		setAllowance(builder.allowance);
	}

	public String getIpAddress(){
		return getString(PROP_IP_ADDRESS);
	}

	public void setIpAddress(String value){
		setString(PROP_IP_ADDRESS, value);
	}

	public int getMask(){
		return getInt(PROP_MASK);
	}

	public void setMask(int value){
		setInt(PROP_MASK, value);
	}

	public int getAllowance(){
		return getInt(PROP_ALLOWANCE);
	}

	public void setAllowance(int value){
		setInt(PROP_ALLOWANCE, value);
	}


	public String toString(){
		String ret = "FilteredIP ";
		ret += "["+getId()+"] ";
		ret += "ipAddress: "+getIpAddress();
		ret += ", ";
		ret += "mask: "+getMask();
		ret += ", ";
		ret += "allowance: "+getAllowance();
		return ret;
	}


	public int compareTo(FilteredIP comparable){
		return compareTo(comparable, FilteredIPSortType.SORT_BY_DEFAULT);
	}

	public int compareTo(IComparable anotherComparable, int method){
		FilteredIPDocument anotherDoc = (FilteredIPDocument) anotherComparable;
		switch(method){
			case FilteredIPSortType.SORT_BY_ID:
				return BasicComparable.compareString(getId(), anotherDoc.getId());
			case FilteredIPSortType.SORT_BY_IPADDRESS:
				return BasicComparable.compareString(getIpAddress(), anotherDoc.getIpAddress());
			case FilteredIPSortType.SORT_BY_MASK:
				return BasicComparable.compareInt(getMask(), anotherDoc.getMask());
			case FilteredIPSortType.SORT_BY_ALLOWANCE:
				return BasicComparable.compareInt(getAllowance(), anotherDoc.getAllowance());
			default:
				throw new RuntimeException("Sort method "+method+" is not supported.");
		}
	}

	public String getDefinedName(){
		return "FilteredIP";
	}

	public String getDefinedParentName(){
		return "ASSiteConfig";
	}

	public String getFootprint(){
		StringBuilder footprint = new StringBuilder();
		footprint.append(getIpAddress());
		footprint.append(getMask());
		footprint.append(getAllowance());
		return MD5Util.getMD5Hash(footprint);
	}

	public boolean equals(Object o){
		return o == this || ((o instanceof FilteredIPDocument) && ((FilteredIPDocument)o).getId().equals(getId()));
	}
}
