/**
 ********************************************************************************
 *** PdfTemplateDocument.java                                                 ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.data;

import net.anotheria.asg.data.AbstractASGDocument;
import java.util.List;
import net.anotheria.anodoc.data.StringProperty;
import net.anotheria.anodoc.util.context.ContextManager;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.anodoc.data.BooleanProperty;
import net.anotheria.util.crypt.MD5Util;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.BasicComparable;
import net.anotheria.asg.data.MultilingualObject;

public class PdfTemplateDocument extends AbstractASGDocument implements PdfTemplate, IComparable, MultilingualObject{

	public PdfTemplateDocument() {
		super("");
	}

	public PdfTemplateDocument(String id){
		super(id);
	}

	public PdfTemplateDocument(PdfTemplateDocument toClone){
		super(toClone);
	}

	PdfTemplateDocument(PdfTemplateBuilder builder){
		super("");
		setName(builder.name);
		setShowPageNumbers(builder.showPageNumbers);
		setApplyBackgroundStyles(builder.applyBackgroundStyles);
		setHeaderTemplate(builder.headerTemplate);
		setHeaderMargin(builder.headerMargin);
		setFooterTemplate(builder.footerTemplate);
		setFooterMargin(builder.footerMargin);
		setContentTemplate(builder.contentTemplate);
		setLocalizations(builder.localizations);
	}

	public String getName(){
		return getString(PROP_NAME);
	}

	public void setName(String value){
		setString(PROP_NAME, value);
	}

	public boolean getShowPageNumbers(){
		return getBoolean(PROP_SHOW_PAGE_NUMBERS);
	}

	public void setShowPageNumbers(boolean value){
		setBoolean(PROP_SHOW_PAGE_NUMBERS, value);
	}

	public boolean getApplyBackgroundStyles(){
		return getBoolean(PROP_APPLY_BACKGROUND_STYLES);
	}

	public void setApplyBackgroundStyles(boolean value){
		setBoolean(PROP_APPLY_BACKGROUND_STYLES, value);
	}

	public String getHeaderTemplateEN(){
		return getString(PROP_HEADER_TEMPLATE_EN);
	}

	public String getHeaderTemplate(){
		return getString("headerTemplate_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage()));
	}


	public void setHeaderTemplateEN(String value){
		setString(PROP_HEADER_TEMPLATE_EN, value);
	}

	public void setHeaderTemplate(String value){
		setString(("headerTemplate_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage())), value);
	}


	public int getHeaderMargin(){
		return getInt(PROP_HEADER_MARGIN);
	}

	public void setHeaderMargin(int value){
		setInt(PROP_HEADER_MARGIN, value);
	}

	public String getFooterTemplateEN(){
		return getString(PROP_FOOTER_TEMPLATE_EN);
	}

	public String getFooterTemplate(){
		return getString("footerTemplate_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage()));
	}


	public void setFooterTemplateEN(String value){
		setString(PROP_FOOTER_TEMPLATE_EN, value);
	}

	public void setFooterTemplate(String value){
		setString(("footerTemplate_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage())), value);
	}


	public int getFooterMargin(){
		return getInt(PROP_FOOTER_MARGIN);
	}

	public void setFooterMargin(int value){
		setInt(PROP_FOOTER_MARGIN, value);
	}

	public String getContentTemplateEN(){
		return getString(PROP_CONTENT_TEMPLATE_EN);
	}

	public String getContentTemplate(){
		return getString("contentTemplate_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage()));
	}


	public void setContentTemplateEN(String value){
		setString(PROP_CONTENT_TEMPLATE_EN, value);
	}

	public void setContentTemplate(String value){
		setString(("contentTemplate_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage())), value);
	}


	public List<String> getLocalizations(){
		return copyToStringList(getList(PROP_LOCALIZATIONS));
	}

	public void setLocalizations(List<String> value){
		setList(PROP_LOCALIZATIONS, copyFromStringList(value));
	}


	public String toString(){
		String ret = "PdfTemplate ";
		ret += "["+getId()+"] ";
		ret += "name: "+getName();
		ret += ", ";
		ret += "showPageNumbers: "+getShowPageNumbers();
		ret += ", ";
		ret += "applyBackgroundStyles: "+getApplyBackgroundStyles();
		ret += ", ";
		ret += "headerTemplate: "+getHeaderTemplate();
		ret += ", ";
		ret += "headerMargin: "+getHeaderMargin();
		ret += ", ";
		ret += "footerTemplate: "+getFooterTemplate();
		ret += ", ";
		ret += "footerMargin: "+getFooterMargin();
		ret += ", ";
		ret += "contentTemplate: "+getContentTemplate();
		ret += ", ";
		ret += "localizations: "+getLocalizations();
		return ret;
	}

	public int getLocalizationsSize(){
		return getList(PROP_LOCALIZATIONS).size();
	}

	public void addLocalizationsElement(String guard){
		getListPropertyAnyCase(PROP_LOCALIZATIONS).add(new StringProperty("" + guard, guard));
	} //method

	public void removeLocalizationsElement(int index){
		getListProperty(PROP_LOCALIZATIONS).remove(index);
	} //method

	public void swapLocalizationsElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_LOCALIZATIONS).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_LOCALIZATIONS).get(index2)).getString();
		((StringProperty)getList(PROP_LOCALIZATIONS).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_LOCALIZATIONS).get(index2)).setString(tmp1);
	} //method

	public String getLocalizationsElement(int index){
		StringProperty p = (StringProperty)getList(PROP_LOCALIZATIONS).get(index);
		return p.getString();
	} //method


	public int compareTo(PdfTemplate comparable){
		return compareTo(comparable, PdfTemplateSortType.SORT_BY_DEFAULT);
	}

	public int compareTo(IComparable anotherComparable, int method){
		PdfTemplateDocument anotherDoc = (PdfTemplateDocument) anotherComparable;
		switch(method){
			case PdfTemplateSortType.SORT_BY_ID:
				return BasicComparable.compareString(getId(), anotherDoc.getId());
			case PdfTemplateSortType.SORT_BY_NAME:
				return BasicComparable.compareString(getName(), anotherDoc.getName());
			case PdfTemplateSortType.SORT_BY_SHOWPAGENUMBERS:
				return BasicComparable.compareBoolean(getShowPageNumbers(), anotherDoc.getShowPageNumbers());
			case PdfTemplateSortType.SORT_BY_APPLYBACKGROUNDSTYLES:
				return BasicComparable.compareBoolean(getApplyBackgroundStyles(), anotherDoc.getApplyBackgroundStyles());
			case PdfTemplateSortType.SORT_BY_HEADERTEMPLATE:
				return BasicComparable.compareString(getHeaderTemplate(), anotherDoc.getHeaderTemplate());
			case PdfTemplateSortType.SORT_BY_HEADERMARGIN:
				return BasicComparable.compareInt(getHeaderMargin(), anotherDoc.getHeaderMargin());
			case PdfTemplateSortType.SORT_BY_FOOTERTEMPLATE:
				return BasicComparable.compareString(getFooterTemplate(), anotherDoc.getFooterTemplate());
			case PdfTemplateSortType.SORT_BY_FOOTERMARGIN:
				return BasicComparable.compareInt(getFooterMargin(), anotherDoc.getFooterMargin());
			case PdfTemplateSortType.SORT_BY_CONTENTTEMPLATE:
				return BasicComparable.compareString(getContentTemplate(), anotherDoc.getContentTemplate());
			default:
				throw new RuntimeException("Sort method "+method+" is not supported.");
		}
	}

	public String getDefinedName(){
		return "PdfTemplate";
	}

	public String getDefinedParentName(){
		return "ASResourceData";
	}

	public String getFootprint(){
		StringBuilder footprint = new StringBuilder();
		footprint.append(getName());
		footprint.append(getShowPageNumbers());
		footprint.append(getApplyBackgroundStyles());
		footprint.append(getHeaderTemplateEN());
		footprint.append(getHeaderMargin());
		footprint.append(getFooterTemplateEN());
		footprint.append(getFooterMargin());
		footprint.append(getContentTemplateEN());
		footprint.append(getLocalizations());
		return MD5Util.getMD5Hash(footprint);
	}
	public void copyLANG2LANG(String sourceLanguage, String destLanguage){
	}


	public boolean isMultilingualDisabledInstance(){
		try{
			return ((BooleanProperty)getInternalProperty(INT_PROPERTY_MULTILINGUAL_DISABLED)).getboolean();
		}catch(NoSuchPropertyException e){
			return false;
		}
	}

	public void setMultilingualDisabledInstance(boolean value){
		setInternalProperty(new BooleanProperty(INT_PROPERTY_MULTILINGUAL_DISABLED, value));
	}

	public boolean equals(Object o){
		return o == this || ((o instanceof PdfTemplateDocument) && ((PdfTemplateDocument)o).getId().equals(getId()));
	}
}
