/**
 ********************************************************************************
 *** ShowTextResourcesAction.java                                             ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.asresourcedata.data.TextResource;
import net.anotheria.anosite.gen.asresourcedata.bean.TextResourceListItemBean;
import net.anotheria.asg.data.LockableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.asresourcedata.bean.TextResourceListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;

public class ShowTextResourcesAction extends BaseTextResourceAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"TextResource";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"TextResource";
	private static Logger log = LoggerFactory.getLogger(ShowTextResourcesAction.class);
	private Sorter<TextResourceListItemBean> sorter;

	private IAttributeDecorator idDecorator;
	private IAttributeDecorator nameDecorator;
	private IAttributeDecorator valueDecorator;

	private DocumentFilter nameFilterAZ;
	private DocumentFilter AnyFilterMissingTranslation;

	public ShowTextResourcesAction(){
		sorter = new QuickSorter<TextResourceListItemBean>();
		try{ 
			idDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.IDItoADecorator").newInstance();
			nameDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
			valueDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate decorator:", e);
		}
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
			AnyFilterMissingTranslation = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.MissingAnyTranslationFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		String filterParameter1 = "";
		try{ 
			filterParameter1 = getStringParameter(req, "pFilter1");
			addBeanToSession(req, SA_FILTER+"1", filterParameter1);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter1 = (String)getBeanFromSession(req, SA_FILTER+"1");
			if (filterParameter1==null)
				filterParameter1 = "";
		}
		req.setAttribute("currentFilterParameter1", filterParameter1);

		int sortMethod = TextResourceListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = TextResourceListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		TextResourceListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new TextResourceListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (TextResourceListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new TextResourceListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<TextResource> _unfiltered_textresources = getASResourceDataService().getTextResources();
		List<TextResource> textresources = new ArrayList<TextResource>();
		for (int i=0; i<_unfiltered_textresources.size(); i++){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass(_unfiltered_textresources.get(i), "name", filterParameter0));
			mayPass = mayPass && (AnyFilterMissingTranslation.mayPass(_unfiltered_textresources.get(i), "Any", filterParameter1));
			if (mayPass)
				textresources.add(_unfiltered_textresources.get(i));
		}
		List<TextResourceListItemBean> beans = new ArrayList<TextResourceListItemBean>(textresources.size());
		for (TextResource textresource : textresources){
			checkTextResources(textresource, req);
			TextResourceListItemBean bean = makeTextResourceListItemBean(textresource);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "textresources", beans);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer("name"));
		addBeanToRequest(req, "AnyFilterMissingTranslation", AnyFilterMissingTranslation.getTriggerer("Any"));
		return mapping.success();
	}

	protected TextResourceListItemBean makeTextResourceListItemBean(TextResource textresource) {
		TextResourceListItemBean bean = new TextResourceListItemBean();
		bean.setPlainId(textresource.getId());
		bean.setIdForSorting(textresource.getId());
		bean.setId(idDecorator.decorate(textresource, "id", "3"));
		bean.setNameForSorting(textresource.getName());
		bean.setName(nameDecorator.decorate(textresource, "name", "null"));
		bean.setValueForSortingEN(textresource.getValueEN());
		bean.setValueEN(valueDecorator.decorate(textresource, "value_EN", "null"));
		bean.setLocked(((LockableObject)textresource).isLocked());
		bean.setLockerId(((LockableObject)textresource).getLockerId());
		bean.setLockingTime(NumberUtils.makeISO8601TimestampString(((LockableObject)textresource).getLockingTime()) + " till: " + NumberUtils.makeISO8601TimestampString(((LockableObject)textresource).getLockingTime() + getLockingTimeout()));
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(textresource.getLastUpdateTimestamp()));
		return bean;
	}
}
