/**
 ********************************************************************************
 *** ExportFileLinksAction.java                                               ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.xml.XMLNode;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.asresourcedata.data.FileLink;
import net.anotheria.anosite.gen.asresourcedata.data.FileLinkSortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;
import net.anotheria.anosite.gen.asresourcedata.bean.FileLinkListItemBeanSortType;

public class ExportFileLinksAction extends BaseFileLinkAction{

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"FileLink";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"FileLink";
	private static final List<String> ITEMS_ON_PAGE_SELECTOR = java.util.Arrays.asList(new String[]{"5","10","20","25","50","100","500","1000"});
	private static final Logger log = LoggerFactory.getLogger(ExportFileLinksAction.class);
	private Sorter<FileLink> sorter;

	private DocumentFilter nameFilterAZ;
	private DocumentFilter AnyFilterMissingTranslation;

	public ExportFileLinksAction(){
		super();
		sorter = new QuickSorter<FileLink>();
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
			AnyFilterMissingTranslation = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.MissingAnyTranslationFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		String filterParameter1 = "";
		try{ 
			filterParameter1 = getStringParameter(req, "pFilter1");
			addBeanToSession(req, SA_FILTER+"1", filterParameter1);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter1 = (String)getBeanFromSession(req, SA_FILTER+"1");
			if (filterParameter1==null)
				filterParameter1 = "";
		}
		req.setAttribute("currentFilterParameter1", filterParameter1);

		int sortMethod = FileLinkListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = FileLinkListItemBeanSortType.ASC;
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = FileLinkListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			sortOrder = getStringParameter(req, PARAM_SORT_ORDER).equals("ASC") ? 
				FileLinkListItemBeanSortType.ASC : FileLinkListItemBeanSortType.DESC;
		}catch(Exception ignored){}

		FileLinkListItemBeanSortType sessionSortType  = null;
		FileLinkSortType sortType = null;
		if (sortParamSet){
			sessionSortType = new FileLinkListItemBeanSortType(sortMethod, sortOrder);
			sortType = new FileLinkSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sessionSortType);
		}else{
			sessionSortType = (FileLinkListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			sortType = sessionSortType == null ? new FileLinkSortType(sortMethod, sortOrder) : new FileLinkSortType(sessionSortType.getSortBy(), sessionSortType.getSortOrder());
			sessionSortType = sessionSortType == null ? new FileLinkListItemBeanSortType(sortMethod, sortOrder) : sessionSortType;
		}
		req.setAttribute("currentSortCode", sessionSortType.getMethodAndOrderCode());

		List<FileLink> _unfiltered_filelinks = getASResourceDataService().getFileLinks();
		List<FileLink> filelinks = new ArrayList<FileLink>();
		for (FileLink element : _unfiltered_filelinks ){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass( element, "name", filterParameter0));
			mayPass = mayPass && (AnyFilterMissingTranslation.mayPass( element, "Any", filterParameter1));
			if (mayPass)
				filelinks.add(element);
		}
		filelinks = sorter.sort(filelinks, sortType);

		addBeanToRequest(req, "filelinks", filelinks);

		XMLNode beans = getASResourceDataService().exportFileLinksToXML(filelinks);


		/**
		 * for XML node - page
		 */
		addBeanToRequest(req, "filelinksXML", beans);
		/**
		 * for CSV - page
		 */
		addBeanToRequest(req, "filelinksCSV", filelinks);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer(""));
		addBeanToRequest(req, "AnyFilterMissingTranslation", AnyFilterMissingTranslation.getTriggerer(""));
		return mapping.success();
	}

}
