/**
 ********************************************************************************
 *** EditFileLinkAction.java                                                  ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.action;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.asresourcedata.bean.EditFileLinkFB;
import net.anotheria.anosite.gen.asresourcedata.data.FileLink;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.asg.util.bean.LinkToMeBean;
import net.anotheria.anosite.gen.assitedata.data.MediaLink;
import net.anotheria.anosite.gen.assitedata.data.Script;
import net.anotheria.asg.data.LockableObject;

public class EditFileLinkAction extends ShowFileLinksAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateEditAction

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateEditActionMethod

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		EditFileLinkFB form = new EditFileLinkFB() ;
		FileLink filelink = getASResourceDataService().getFileLink(id);
		checkFileLinks(filelink, req);
		if(filelink instanceof LockableObject && !((LockableObject)filelink).isLocked() && isAutoLockingEnabled())
			lockFileLinks(filelink, req);
		form.setId(filelink.getId());
		form.setName(filelink.getName());
		form.setTitle(filelink.getTitle());
		form.setFile(filelink.getFile());
		form.setLocked(((LockableObject)filelink).isLocked());
		form.setLockerId(((LockableObject)filelink).getLockerId());
		form.setLockingTime(net.anotheria.util.NumberUtils.makeISO8601TimestampString(((LockableObject)filelink).getLockingTime()) + " automatic unlock expected AT : " + net.anotheria.util.NumberUtils.makeISO8601TimestampString(((LockableObject)filelink).getLockingTime() + getLockingTimeout()));

		addBeanToRequest(req, "objectId" , filelink.getId());
		addBeanToRequest(req, "EditASResourceDataFileLinkForm" , form);
		addBeanToRequest(req, "objectInfoString" , filelink.getObjectInfo().toString());
		addBeanToRequest(req, "apply.label.prefix", "Apply");
		addBeanToRequest(req, "save.label.prefix", "Save");
		addBeanToRequest(req, "transfer.label.prefix", "Transfer");

		addFieldExplanations(req, filelink);


		// Generating back link handling...
		List<LinkToMeBean> linksToMe = findLinksToCurrentDocument(filelink.getId());
		if (linksToMe.size()>0)
			req.setAttribute("linksToMe", linksToMe);
		return mapping.success();
	}

	private List<LinkToMeBean> findLinksToCurrentDocument(String documentId){
		List<LinkToMeBean> ret = new ArrayList<LinkToMeBean>();
		try{
			ret.addAll(findLinkToCurrentDocumentInASSiteDataMediaLinkFile(documentId));
		}catch(Exception ignored){
		}
		try{
			ret.addAll(findLinkToCurrentDocumentInASSiteDataScriptFile(documentId));
		}catch(Exception ignored){
		}
		return ret;
	}
	private List<LinkToMeBean> findLinkToCurrentDocumentInASSiteDataMediaLinkFile(String documentId) throws net.anotheria.anosite.gen.assitedata.service.ASSiteDataServiceException{
		List<LinkToMeBean> ret = new ArrayList<LinkToMeBean>();
		QueryProperty p = new QueryProperty(MediaLink.LINK_PROP_FILE, documentId);
		// temporarly - replacy with query property
		List<MediaLink> list = getASSiteDataService().getMediaLinksByProperty(p.getName(), p.getValue());
		for (MediaLink doc : list ){
			ret.add(new LinkToMeBean(doc, "file"));
		}
		return ret;
	}
	private List<LinkToMeBean> findLinkToCurrentDocumentInASSiteDataScriptFile(String documentId) throws net.anotheria.anosite.gen.assitedata.service.ASSiteDataServiceException{
		List<LinkToMeBean> ret = new ArrayList<LinkToMeBean>();
		QueryProperty p = new QueryProperty(Script.LINK_PROP_FILE, documentId);
		// temporarly - replacy with query property
		List<Script> list = getASSiteDataService().getScriptsByProperty(p.getName(), p.getValue());
		for (Script doc : list ){
			ret.add(new LinkToMeBean(doc, "file"));
		}
		return ret;
	}
}
