/**
 ********************************************************************************
 *** BaseLocalizationBundleAction.java                                        ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.action;

import net.anotheria.anosite.gen.shared.action.BaseResourcesAction;
import jakarta.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundle;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseLocalizationBundleAction extends BaseResourcesAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "LocalizationBundles";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASResourceData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "LocalizationBundle";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, LocalizationBundle localizationbundle) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASResourceData.LocalizationBundle").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.LocalizationBundle", localizationbundle, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.LocalizationBundle", localizationbundle, "messages");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.messages", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockLocalizationBundles(LocalizationBundle localizationbundle, HttpServletRequest req) throws Exception{
		if(localizationbundle instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)localizationbundle;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASResourceDataService().updateLocalizationBundle( localizationbundle);
			logger.info("Lock-OPERATION, document with id : ["+localizationbundle.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockLocalizationBundles(LocalizationBundle localizationbundle, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(localizationbundle instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)localizationbundle;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASResourceDataService().updateLocalizationBundle( localizationbundle);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+localizationbundle.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+localizationbundle.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkLocalizationBundles(LocalizationBundle localizationbundle, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = localizationbundle instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)localizationbundle).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)localizationbundle).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockLocalizationBundles(localizationbundle, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateLocalizationBundles(LocalizationBundle localizationbundle, HttpServletRequest req) throws Exception{
		if(localizationbundle instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)localizationbundle, false, getUserId(req));
		}
		if (isTimeoutReached(localizationbundle)) {
			checkLocalizationBundles(localizationbundle, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(localizationbundle, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(LocalizationBundle localizationbundle){
		if (localizationbundle instanceof LockableObject) {
			LockableObject lock = (LockableObject)localizationbundle;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(LocalizationBundle localizationbundle, HttpServletRequest req){
		if (localizationbundle instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)localizationbundle;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
