/**
 ********************************************************************************
 *** BasePageStyleAction.java                                                 ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aslayoutdata.action;

import net.anotheria.anosite.gen.shared.action.BaseLayoutAction;
import jakarta.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.aslayoutdata.data.PageStyle;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BasePageStyleAction extends BaseLayoutAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Style";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASLayoutData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "PageStyle";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, PageStyle pagestyle) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASLayoutData.PageStyle").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASLayoutData.PageStyle", pagestyle, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASLayoutData.PageStyle", pagestyle, "css");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.css", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASLayoutData.PageStyle", pagestyle, "description");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.description", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockPageStyles(PageStyle pagestyle, HttpServletRequest req) throws Exception{
		if(pagestyle instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)pagestyle;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASLayoutDataService().updatePageStyle( pagestyle);
			logger.info("Lock-OPERATION, document with id : ["+pagestyle.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockPageStyles(PageStyle pagestyle, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(pagestyle instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)pagestyle;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASLayoutDataService().updatePageStyle( pagestyle);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+pagestyle.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+pagestyle.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkPageStyles(PageStyle pagestyle, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = pagestyle instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)pagestyle).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)pagestyle).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockPageStyles(pagestyle, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdatePageStyles(PageStyle pagestyle, HttpServletRequest req) throws Exception{
		if(pagestyle instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)pagestyle, false, getUserId(req));
		}
		if (isTimeoutReached(pagestyle)) {
			checkPageStyles(pagestyle, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(pagestyle, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(PageStyle pagestyle){
		if (pagestyle instanceof LockableObject) {
			LockableObject lock = (LockableObject)pagestyle;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(PageStyle pagestyle, HttpServletRequest req){
		if (pagestyle instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)pagestyle;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
