/**
 ********************************************************************************
 *** ASGenericDataServiceImpl.java                                            ***
 *** The implementation of the IASGenericDataService.                         ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asgenericdata.service;

import java.nio.charset.Charset;
import java.util.List;
import java.util.ArrayList;
import java.util.Set;
import net.anotheria.anodoc.data.Module;
import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.sorter.StaticQuickSorter;
import net.anotheria.util.slicer.Segment;
import net.anotheria.util.slicer.Slicer;
import net.anotheria.anosite.gen.asgenericdata.data.ModuleASGenericData;
import net.anotheria.anosite.gen.shared.service.BasicCMSService;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryResultEntry;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.util.StringUtils;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.xml.XMLAttribute;
import net.anotheria.asg.util.listener.IModuleListener;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import net.anotheria.anodoc.util.mapper.ObjectMapperUtil;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.anosite.gen.asgenericdata.data.GenericBoxType;
import net.anotheria.anosite.gen.asgenericdata.data.GenericBoxTypeXMLHelper;
import net.anotheria.anosite.gen.asgenericdata.data.GenericBoxTypeDocument;
import net.anotheria.anosite.gen.asgenericdata.data.GenericBoxHandlerDef;
import net.anotheria.anosite.gen.asgenericdata.data.GenericBoxHandlerDefXMLHelper;
import net.anotheria.anosite.gen.asgenericdata.data.GenericBoxHandlerDefDocument;
import net.anotheria.anosite.gen.asgenericdata.data.GenericGuardDef;
import net.anotheria.anosite.gen.asgenericdata.data.GenericGuardDefXMLHelper;
import net.anotheria.anosite.gen.asgenericdata.data.GenericGuardDefDocument;

public class ASGenericDataServiceImpl extends BasicCMSService implements IASGenericDataService, IModuleListener{

	// Generated by: class net.anotheria.asg.generator.model.docs.CMSBasedServiceGenerator.generateImplementation

	private static ASGenericDataServiceImpl instance;

	private ASGenericDataServiceImpl(){
		addServiceListener(new net.anotheria.anosite.cms.listener.CRUDLogListener());
		addServiceListener(new net.anotheria.anosite.cms.listener.AutoTransferAsGenericActionListener());
		addModuleListener(ModuleASGenericData.MODULE_ID, this);
	}

	static final ASGenericDataServiceImpl getInstance(){
		if (instance==null){
			instance = new ASGenericDataServiceImpl();
		}
		return instance;
	}

	private ModuleASGenericData _getModuleASGenericData(){
		return (ModuleASGenericData) getModule(ModuleASGenericData.MODULE_ID);
	}

	@Override
	public void moduleLoaded(Module module){
		firePersistenceChangedEvent();
	}

	@Override
	public List<GenericBoxType> getGenericBoxTypes(){
		List<GenericBoxType> genericboxtypes = new ArrayList<>();
		genericboxtypes.addAll(_getModuleASGenericData().getGenericBoxTypes());
		return genericboxtypes;
	}

	@Override
	public List<GenericBoxType> getGenericBoxTypes(SortType sortType){
		return StaticQuickSorter.sort(getGenericBoxTypes(), sortType);
	}

	/**
	 * Returns the GenericBoxType objects with the specified ids.
	 */
	public List<GenericBoxType> getGenericBoxTypes(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<GenericBoxType> all = getGenericBoxTypes();
		List<GenericBoxType> ret = new ArrayList<>();
		for (GenericBoxType genericboxtype : all){
			if(ids.contains(genericboxtype.getId())){
				ret.add(genericboxtype);
			}
		}
		return ret;
	}

	/**
	 * Returns the GenericBoxType objects with the specified ids, sorted by given sorttype.
	 */
	public List<GenericBoxType> getGenericBoxTypes(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getGenericBoxTypes(ids), sortType);
	}

	@Override
	public void deleteGenericBoxType(GenericBoxType genericboxtype){
		deleteGenericBoxType(genericboxtype.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(genericboxtype);
		}
	}

	@Override
	public void deleteGenericBoxType(String id){
		ModuleASGenericData module = _getModuleASGenericData();
		GenericBoxType varValue = hasServiceListeners()?module.getGenericBoxType(id):null;
		module.deleteGenericBoxType(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteGenericBoxTypes(List<GenericBoxType> list){
		ModuleASGenericData module = _getModuleASGenericData();
		for (GenericBoxType genericboxtype : list){
			module.deleteGenericBoxType(genericboxtype.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public GenericBoxType getGenericBoxType(String id){
		return _getModuleASGenericData().getGenericBoxType(id);
	}

	@Override
	public GenericBoxType importGenericBoxType(GenericBoxType genericboxtype){
		ModuleASGenericData module = _getModuleASGenericData();
		module.importGenericBoxType((GenericBoxTypeDocument)genericboxtype);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(genericboxtype);
		}
		return genericboxtype;
	}

	@Override
	public List<GenericBoxType> importGenericBoxTypes(List<GenericBoxType> list){
		ModuleASGenericData module = _getModuleASGenericData();
		List<GenericBoxType> ret = new ArrayList<>();
		for (GenericBoxType genericboxtype : list){
			GenericBoxType imported = module.importGenericBoxType((GenericBoxTypeDocument)genericboxtype);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (GenericBoxType genericboxtype : ret)
				fireObjectImportedEvent(genericboxtype);
		}
		return ret;
	}

	@Override
	public GenericBoxType createGenericBoxType(GenericBoxType genericboxtype){
		ModuleASGenericData module = _getModuleASGenericData();
		module.createGenericBoxType((GenericBoxTypeDocument)genericboxtype);
		updateModule(module);
		fireObjectCreatedEvent(genericboxtype);
		return genericboxtype;
	}

	@Override
	/**
	 * Creates multiple new GenericBoxType objects.
	 * Returns the created versions.
	 */
	public List<GenericBoxType> createGenericBoxTypes(List<GenericBoxType> list){
		ModuleASGenericData module = _getModuleASGenericData();
		List<GenericBoxType> ret = new ArrayList<>();
		for (GenericBoxType genericboxtype : list){
			GenericBoxType created = module.createGenericBoxType((GenericBoxTypeDocument)genericboxtype);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (GenericBoxType genericboxtype : ret)
				fireObjectCreatedEvent(genericboxtype);
		}
		return ret;
	}

	@Override
	public GenericBoxType updateGenericBoxType(GenericBoxType genericboxtype){
		GenericBoxType oldVersion = null;
		ModuleASGenericData module = _getModuleASGenericData();
		if (hasServiceListeners())
			oldVersion = module.getGenericBoxType(genericboxtype.getId());
		module.updateGenericBoxType((GenericBoxTypeDocument)genericboxtype);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, genericboxtype);
		}
		return genericboxtype;
	}

	@Override
	public List<GenericBoxType> updateGenericBoxTypes(List<GenericBoxType> list){
		List<GenericBoxType> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASGenericData module = _getModuleASGenericData();
		for (GenericBoxType genericboxtype : list){
			if (oldList!=null)
				oldList.add(module.getGenericBoxType(genericboxtype.getId()));
			module.updateGenericBoxType((GenericBoxTypeDocument)genericboxtype);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<GenericBoxType> getGenericBoxTypesByProperty(String propertyName, Object value){
		List<GenericBoxType> allGenericBoxTypes = getGenericBoxTypes();
		List<GenericBoxType> ret = new ArrayList<>();
		for (int i=0; i<allGenericBoxTypes.size(); i++){
			GenericBoxType genericboxtype = allGenericBoxTypes.get(i);
			try{
				Property property = ((GenericBoxTypeDocument)genericboxtype).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(genericboxtype);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(genericboxtype);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(genericboxtype);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<GenericBoxType> getGenericBoxTypesByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getGenericBoxTypesByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on GenericBoxTypes
	 */
	public QueryResult executeQueryOnGenericBoxTypes(DocumentQuery query){
		List<GenericBoxType> allGenericBoxTypes = getGenericBoxTypes();
		QueryResult result = new QueryResult();
		for (int i=0; i<allGenericBoxTypes.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allGenericBoxTypes.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all GenericBoxType objects, where property matches.
	 */
	public List<GenericBoxType> getGenericBoxTypesByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<GenericBoxType> ret = new ArrayList<>();
		List<GenericBoxType> src = getGenericBoxTypes();
		for ( GenericBoxType genericboxtype : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(genericboxtype.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(genericboxtype);
		}
		return ret;
	}

	/**
	 * Returns all GenericBoxType objects, where property matches, sorted
	 */
	public List<GenericBoxType> getGenericBoxTypesByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getGenericBoxTypesByProperty(property), sortType);
	}

	/**
	 * Returns GenericBoxType objects count.
	 */
	public int getGenericBoxTypesCount() {
		return _getModuleASGenericData().getGenericBoxTypes().size();
	}

	/**
	 * Returns GenericBoxType objects segment.
	 */
	public List<GenericBoxType> getGenericBoxTypes(Segment aSegment) {
		return Slicer.slice(aSegment, getGenericBoxTypes()).getSliceData();
	}

	/**
	 * Returns GenericBoxType objects segment, where property matched.
	 */
	public List<GenericBoxType> getGenericBoxTypesByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<GenericBoxType> ret = new ArrayList<>();
		List<GenericBoxType> src = getGenericBoxTypes();
		for (GenericBoxType genericboxtype : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(genericboxtype.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(genericboxtype);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns GenericBoxType objects segment, where property matched, sorted.
	 */
	public List<GenericBoxType> getGenericBoxTypesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getGenericBoxTypesByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchGenericBoxType(final String id, Set<String> addedDocuments, JSONArray data) throws ASGenericDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("GenericBoxType" + id))
			return;

		try {
			final GenericBoxTypeDocument genericboxtype = _getModuleASGenericData().getGenericBoxType(id);
			addedDocuments.add("GenericBoxType" + id);



			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(genericboxtype);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASGenericData");
			dataObject.put("document", "ASGenericData_GenericBoxType");

			data.put(dataObject);

		}catch(IOException e){
			throw new ASGenericDataServiceException ("Problem with fetching data for this GenericBoxType instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASGenericDataServiceException ("Problem with fetching data for this GenericBoxType instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredGenericBoxType(final JSONObject data) throws ASGenericDataServiceException {
		try {
			String objectData = data.getString("object");
			GenericBoxType genericboxtype = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), GenericBoxTypeDocument.class);

			try {
				updateGenericBoxType(genericboxtype);
			}catch(Exception e){
				importGenericBoxType(genericboxtype);
			}
		}catch(JSONException e){
			throw new ASGenericDataServiceException("Problem with getting data from json GenericBoxType instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASGenericDataServiceException("Problem with parsing data for this GenericBoxType instance :" + e.getMessage());
		}
	}

	@Override
	public List<GenericBoxHandlerDef> getGenericBoxHandlerDefs(){
		List<GenericBoxHandlerDef> genericboxhandlerdefs = new ArrayList<>();
		genericboxhandlerdefs.addAll(_getModuleASGenericData().getGenericBoxHandlerDefs());
		return genericboxhandlerdefs;
	}

	@Override
	public List<GenericBoxHandlerDef> getGenericBoxHandlerDefs(SortType sortType){
		return StaticQuickSorter.sort(getGenericBoxHandlerDefs(), sortType);
	}

	/**
	 * Returns the GenericBoxHandlerDef objects with the specified ids.
	 */
	public List<GenericBoxHandlerDef> getGenericBoxHandlerDefs(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<GenericBoxHandlerDef> all = getGenericBoxHandlerDefs();
		List<GenericBoxHandlerDef> ret = new ArrayList<>();
		for (GenericBoxHandlerDef genericboxhandlerdef : all){
			if(ids.contains(genericboxhandlerdef.getId())){
				ret.add(genericboxhandlerdef);
			}
		}
		return ret;
	}

	/**
	 * Returns the GenericBoxHandlerDef objects with the specified ids, sorted by given sorttype.
	 */
	public List<GenericBoxHandlerDef> getGenericBoxHandlerDefs(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getGenericBoxHandlerDefs(ids), sortType);
	}

	@Override
	public void deleteGenericBoxHandlerDef(GenericBoxHandlerDef genericboxhandlerdef){
		deleteGenericBoxHandlerDef(genericboxhandlerdef.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(genericboxhandlerdef);
		}
	}

	@Override
	public void deleteGenericBoxHandlerDef(String id){
		ModuleASGenericData module = _getModuleASGenericData();
		GenericBoxHandlerDef varValue = hasServiceListeners()?module.getGenericBoxHandlerDef(id):null;
		module.deleteGenericBoxHandlerDef(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteGenericBoxHandlerDefs(List<GenericBoxHandlerDef> list){
		ModuleASGenericData module = _getModuleASGenericData();
		for (GenericBoxHandlerDef genericboxhandlerdef : list){
			module.deleteGenericBoxHandlerDef(genericboxhandlerdef.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public GenericBoxHandlerDef getGenericBoxHandlerDef(String id){
		return _getModuleASGenericData().getGenericBoxHandlerDef(id);
	}

	@Override
	public GenericBoxHandlerDef importGenericBoxHandlerDef(GenericBoxHandlerDef genericboxhandlerdef){
		ModuleASGenericData module = _getModuleASGenericData();
		module.importGenericBoxHandlerDef((GenericBoxHandlerDefDocument)genericboxhandlerdef);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(genericboxhandlerdef);
		}
		return genericboxhandlerdef;
	}

	@Override
	public List<GenericBoxHandlerDef> importGenericBoxHandlerDefs(List<GenericBoxHandlerDef> list){
		ModuleASGenericData module = _getModuleASGenericData();
		List<GenericBoxHandlerDef> ret = new ArrayList<>();
		for (GenericBoxHandlerDef genericboxhandlerdef : list){
			GenericBoxHandlerDef imported = module.importGenericBoxHandlerDef((GenericBoxHandlerDefDocument)genericboxhandlerdef);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (GenericBoxHandlerDef genericboxhandlerdef : ret)
				fireObjectImportedEvent(genericboxhandlerdef);
		}
		return ret;
	}

	@Override
	public GenericBoxHandlerDef createGenericBoxHandlerDef(GenericBoxHandlerDef genericboxhandlerdef){
		ModuleASGenericData module = _getModuleASGenericData();
		module.createGenericBoxHandlerDef((GenericBoxHandlerDefDocument)genericboxhandlerdef);
		updateModule(module);
		fireObjectCreatedEvent(genericboxhandlerdef);
		return genericboxhandlerdef;
	}

	@Override
	/**
	 * Creates multiple new GenericBoxHandlerDef objects.
	 * Returns the created versions.
	 */
	public List<GenericBoxHandlerDef> createGenericBoxHandlerDefs(List<GenericBoxHandlerDef> list){
		ModuleASGenericData module = _getModuleASGenericData();
		List<GenericBoxHandlerDef> ret = new ArrayList<>();
		for (GenericBoxHandlerDef genericboxhandlerdef : list){
			GenericBoxHandlerDef created = module.createGenericBoxHandlerDef((GenericBoxHandlerDefDocument)genericboxhandlerdef);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (GenericBoxHandlerDef genericboxhandlerdef : ret)
				fireObjectCreatedEvent(genericboxhandlerdef);
		}
		return ret;
	}

	@Override
	public GenericBoxHandlerDef updateGenericBoxHandlerDef(GenericBoxHandlerDef genericboxhandlerdef){
		GenericBoxHandlerDef oldVersion = null;
		ModuleASGenericData module = _getModuleASGenericData();
		if (hasServiceListeners())
			oldVersion = module.getGenericBoxHandlerDef(genericboxhandlerdef.getId());
		module.updateGenericBoxHandlerDef((GenericBoxHandlerDefDocument)genericboxhandlerdef);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, genericboxhandlerdef);
		}
		return genericboxhandlerdef;
	}

	@Override
	public List<GenericBoxHandlerDef> updateGenericBoxHandlerDefs(List<GenericBoxHandlerDef> list){
		List<GenericBoxHandlerDef> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASGenericData module = _getModuleASGenericData();
		for (GenericBoxHandlerDef genericboxhandlerdef : list){
			if (oldList!=null)
				oldList.add(module.getGenericBoxHandlerDef(genericboxhandlerdef.getId()));
			module.updateGenericBoxHandlerDef((GenericBoxHandlerDefDocument)genericboxhandlerdef);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<GenericBoxHandlerDef> getGenericBoxHandlerDefsByProperty(String propertyName, Object value){
		List<GenericBoxHandlerDef> allGenericBoxHandlerDefs = getGenericBoxHandlerDefs();
		List<GenericBoxHandlerDef> ret = new ArrayList<>();
		for (int i=0; i<allGenericBoxHandlerDefs.size(); i++){
			GenericBoxHandlerDef genericboxhandlerdef = allGenericBoxHandlerDefs.get(i);
			try{
				Property property = ((GenericBoxHandlerDefDocument)genericboxhandlerdef).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(genericboxhandlerdef);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(genericboxhandlerdef);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(genericboxhandlerdef);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<GenericBoxHandlerDef> getGenericBoxHandlerDefsByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getGenericBoxHandlerDefsByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on GenericBoxHandlerDefs
	 */
	public QueryResult executeQueryOnGenericBoxHandlerDefs(DocumentQuery query){
		List<GenericBoxHandlerDef> allGenericBoxHandlerDefs = getGenericBoxHandlerDefs();
		QueryResult result = new QueryResult();
		for (int i=0; i<allGenericBoxHandlerDefs.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allGenericBoxHandlerDefs.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all GenericBoxHandlerDef objects, where property matches.
	 */
	public List<GenericBoxHandlerDef> getGenericBoxHandlerDefsByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<GenericBoxHandlerDef> ret = new ArrayList<>();
		List<GenericBoxHandlerDef> src = getGenericBoxHandlerDefs();
		for ( GenericBoxHandlerDef genericboxhandlerdef : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(genericboxhandlerdef.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(genericboxhandlerdef);
		}
		return ret;
	}

	/**
	 * Returns all GenericBoxHandlerDef objects, where property matches, sorted
	 */
	public List<GenericBoxHandlerDef> getGenericBoxHandlerDefsByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getGenericBoxHandlerDefsByProperty(property), sortType);
	}

	/**
	 * Returns GenericBoxHandlerDef objects count.
	 */
	public int getGenericBoxHandlerDefsCount() {
		return _getModuleASGenericData().getGenericBoxHandlerDefs().size();
	}

	/**
	 * Returns GenericBoxHandlerDef objects segment.
	 */
	public List<GenericBoxHandlerDef> getGenericBoxHandlerDefs(Segment aSegment) {
		return Slicer.slice(aSegment, getGenericBoxHandlerDefs()).getSliceData();
	}

	/**
	 * Returns GenericBoxHandlerDef objects segment, where property matched.
	 */
	public List<GenericBoxHandlerDef> getGenericBoxHandlerDefsByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<GenericBoxHandlerDef> ret = new ArrayList<>();
		List<GenericBoxHandlerDef> src = getGenericBoxHandlerDefs();
		for (GenericBoxHandlerDef genericboxhandlerdef : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(genericboxhandlerdef.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(genericboxhandlerdef);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns GenericBoxHandlerDef objects segment, where property matched, sorted.
	 */
	public List<GenericBoxHandlerDef> getGenericBoxHandlerDefsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getGenericBoxHandlerDefsByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchGenericBoxHandlerDef(final String id, Set<String> addedDocuments, JSONArray data) throws ASGenericDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("GenericBoxHandlerDef" + id))
			return;

		try {
			final GenericBoxHandlerDefDocument genericboxhandlerdef = _getModuleASGenericData().getGenericBoxHandlerDef(id);
			addedDocuments.add("GenericBoxHandlerDef" + id);



			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(genericboxhandlerdef);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASGenericData");
			dataObject.put("document", "ASGenericData_GenericBoxHandlerDef");

			data.put(dataObject);

		}catch(IOException e){
			throw new ASGenericDataServiceException ("Problem with fetching data for this GenericBoxHandlerDef instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASGenericDataServiceException ("Problem with fetching data for this GenericBoxHandlerDef instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredGenericBoxHandlerDef(final JSONObject data) throws ASGenericDataServiceException {
		try {
			String objectData = data.getString("object");
			GenericBoxHandlerDef genericboxhandlerdef = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), GenericBoxHandlerDefDocument.class);

			try {
				updateGenericBoxHandlerDef(genericboxhandlerdef);
			}catch(Exception e){
				importGenericBoxHandlerDef(genericboxhandlerdef);
			}
		}catch(JSONException e){
			throw new ASGenericDataServiceException("Problem with getting data from json GenericBoxHandlerDef instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASGenericDataServiceException("Problem with parsing data for this GenericBoxHandlerDef instance :" + e.getMessage());
		}
	}

	@Override
	public List<GenericGuardDef> getGenericGuardDefs(){
		List<GenericGuardDef> genericguarddefs = new ArrayList<>();
		genericguarddefs.addAll(_getModuleASGenericData().getGenericGuardDefs());
		return genericguarddefs;
	}

	@Override
	public List<GenericGuardDef> getGenericGuardDefs(SortType sortType){
		return StaticQuickSorter.sort(getGenericGuardDefs(), sortType);
	}

	/**
	 * Returns the GenericGuardDef objects with the specified ids.
	 */
	public List<GenericGuardDef> getGenericGuardDefs(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<GenericGuardDef> all = getGenericGuardDefs();
		List<GenericGuardDef> ret = new ArrayList<>();
		for (GenericGuardDef genericguarddef : all){
			if(ids.contains(genericguarddef.getId())){
				ret.add(genericguarddef);
			}
		}
		return ret;
	}

	/**
	 * Returns the GenericGuardDef objects with the specified ids, sorted by given sorttype.
	 */
	public List<GenericGuardDef> getGenericGuardDefs(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getGenericGuardDefs(ids), sortType);
	}

	@Override
	public void deleteGenericGuardDef(GenericGuardDef genericguarddef){
		deleteGenericGuardDef(genericguarddef.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(genericguarddef);
		}
	}

	@Override
	public void deleteGenericGuardDef(String id){
		ModuleASGenericData module = _getModuleASGenericData();
		GenericGuardDef varValue = hasServiceListeners()?module.getGenericGuardDef(id):null;
		module.deleteGenericGuardDef(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteGenericGuardDefs(List<GenericGuardDef> list){
		ModuleASGenericData module = _getModuleASGenericData();
		for (GenericGuardDef genericguarddef : list){
			module.deleteGenericGuardDef(genericguarddef.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public GenericGuardDef getGenericGuardDef(String id){
		return _getModuleASGenericData().getGenericGuardDef(id);
	}

	@Override
	public GenericGuardDef importGenericGuardDef(GenericGuardDef genericguarddef){
		ModuleASGenericData module = _getModuleASGenericData();
		module.importGenericGuardDef((GenericGuardDefDocument)genericguarddef);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(genericguarddef);
		}
		return genericguarddef;
	}

	@Override
	public List<GenericGuardDef> importGenericGuardDefs(List<GenericGuardDef> list){
		ModuleASGenericData module = _getModuleASGenericData();
		List<GenericGuardDef> ret = new ArrayList<>();
		for (GenericGuardDef genericguarddef : list){
			GenericGuardDef imported = module.importGenericGuardDef((GenericGuardDefDocument)genericguarddef);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (GenericGuardDef genericguarddef : ret)
				fireObjectImportedEvent(genericguarddef);
		}
		return ret;
	}

	@Override
	public GenericGuardDef createGenericGuardDef(GenericGuardDef genericguarddef){
		ModuleASGenericData module = _getModuleASGenericData();
		module.createGenericGuardDef((GenericGuardDefDocument)genericguarddef);
		updateModule(module);
		fireObjectCreatedEvent(genericguarddef);
		return genericguarddef;
	}

	@Override
	/**
	 * Creates multiple new GenericGuardDef objects.
	 * Returns the created versions.
	 */
	public List<GenericGuardDef> createGenericGuardDefs(List<GenericGuardDef> list){
		ModuleASGenericData module = _getModuleASGenericData();
		List<GenericGuardDef> ret = new ArrayList<>();
		for (GenericGuardDef genericguarddef : list){
			GenericGuardDef created = module.createGenericGuardDef((GenericGuardDefDocument)genericguarddef);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (GenericGuardDef genericguarddef : ret)
				fireObjectCreatedEvent(genericguarddef);
		}
		return ret;
	}

	@Override
	public GenericGuardDef updateGenericGuardDef(GenericGuardDef genericguarddef){
		GenericGuardDef oldVersion = null;
		ModuleASGenericData module = _getModuleASGenericData();
		if (hasServiceListeners())
			oldVersion = module.getGenericGuardDef(genericguarddef.getId());
		module.updateGenericGuardDef((GenericGuardDefDocument)genericguarddef);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, genericguarddef);
		}
		return genericguarddef;
	}

	@Override
	public List<GenericGuardDef> updateGenericGuardDefs(List<GenericGuardDef> list){
		List<GenericGuardDef> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASGenericData module = _getModuleASGenericData();
		for (GenericGuardDef genericguarddef : list){
			if (oldList!=null)
				oldList.add(module.getGenericGuardDef(genericguarddef.getId()));
			module.updateGenericGuardDef((GenericGuardDefDocument)genericguarddef);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<GenericGuardDef> getGenericGuardDefsByProperty(String propertyName, Object value){
		List<GenericGuardDef> allGenericGuardDefs = getGenericGuardDefs();
		List<GenericGuardDef> ret = new ArrayList<>();
		for (int i=0; i<allGenericGuardDefs.size(); i++){
			GenericGuardDef genericguarddef = allGenericGuardDefs.get(i);
			try{
				Property property = ((GenericGuardDefDocument)genericguarddef).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(genericguarddef);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(genericguarddef);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(genericguarddef);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<GenericGuardDef> getGenericGuardDefsByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getGenericGuardDefsByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on GenericGuardDefs
	 */
	public QueryResult executeQueryOnGenericGuardDefs(DocumentQuery query){
		List<GenericGuardDef> allGenericGuardDefs = getGenericGuardDefs();
		QueryResult result = new QueryResult();
		for (int i=0; i<allGenericGuardDefs.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allGenericGuardDefs.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all GenericGuardDef objects, where property matches.
	 */
	public List<GenericGuardDef> getGenericGuardDefsByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<GenericGuardDef> ret = new ArrayList<>();
		List<GenericGuardDef> src = getGenericGuardDefs();
		for ( GenericGuardDef genericguarddef : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(genericguarddef.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(genericguarddef);
		}
		return ret;
	}

	/**
	 * Returns all GenericGuardDef objects, where property matches, sorted
	 */
	public List<GenericGuardDef> getGenericGuardDefsByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getGenericGuardDefsByProperty(property), sortType);
	}

	/**
	 * Returns GenericGuardDef objects count.
	 */
	public int getGenericGuardDefsCount() {
		return _getModuleASGenericData().getGenericGuardDefs().size();
	}

	/**
	 * Returns GenericGuardDef objects segment.
	 */
	public List<GenericGuardDef> getGenericGuardDefs(Segment aSegment) {
		return Slicer.slice(aSegment, getGenericGuardDefs()).getSliceData();
	}

	/**
	 * Returns GenericGuardDef objects segment, where property matched.
	 */
	public List<GenericGuardDef> getGenericGuardDefsByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<GenericGuardDef> ret = new ArrayList<>();
		List<GenericGuardDef> src = getGenericGuardDefs();
		for (GenericGuardDef genericguarddef : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(genericguarddef.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(genericguarddef);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns GenericGuardDef objects segment, where property matched, sorted.
	 */
	public List<GenericGuardDef> getGenericGuardDefsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getGenericGuardDefsByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchGenericGuardDef(final String id, Set<String> addedDocuments, JSONArray data) throws ASGenericDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("GenericGuardDef" + id))
			return;

		try {
			final GenericGuardDefDocument genericguarddef = _getModuleASGenericData().getGenericGuardDef(id);
			addedDocuments.add("GenericGuardDef" + id);



			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(genericguarddef);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASGenericData");
			dataObject.put("document", "ASGenericData_GenericGuardDef");

			data.put(dataObject);

		}catch(IOException e){
			throw new ASGenericDataServiceException ("Problem with fetching data for this GenericGuardDef instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASGenericDataServiceException ("Problem with fetching data for this GenericGuardDef instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredGenericGuardDef(final JSONObject data) throws ASGenericDataServiceException {
		try {
			String objectData = data.getString("object");
			GenericGuardDef genericguarddef = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), GenericGuardDefDocument.class);

			try {
				updateGenericGuardDef(genericguarddef);
			}catch(Exception e){
				importGenericGuardDef(genericguarddef);
			}
		}catch(JSONException e){
			throw new ASGenericDataServiceException("Problem with getting data from json GenericGuardDef instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASGenericDataServiceException("Problem with parsing data for this GenericGuardDef instance :" + e.getMessage());
		}
	}

	public void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws ASGenericDataServiceException {
		switch(documentName) {
			case DOCUMENT_ASGENERICDATA_GENERICBOXTYPE:
				saveTransferredGenericBoxType(data);
				break;
			case DOCUMENT_ASGENERICDATA_GENERICBOXHANDLERDEF:
				saveTransferredGenericBoxHandlerDef(data);
				break;
			case DOCUMENT_ASGENERICDATA_GENERICGUARDDEF:
				saveTransferredGenericGuardDef(data);
				break;
			default:
				log.info("There is no correct document: " + documentName + "in this service");
				throw new ASGenericDataServiceException("No such document");
		}
	}

	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service
	 */
	public QueryResult executeQueryOnAllObjects(DocumentQuery query){
		QueryResult ret = new QueryResult();
		ret.add(executeQueryOnGenericBoxTypes(query).getEntries());
		ret.add(executeQueryOnGenericBoxHandlerDefs(query).getEntries());
		ret.add(executeQueryOnGenericGuardDefs(query).getEntries());
		return ret;
	} //executeQueryOnAllObjects


	public XMLNode exportGenericBoxTypesToXML(){
		XMLNode ret = new XMLNode("GenericBoxTypes");
		List<GenericBoxType> list = getGenericBoxTypes();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (GenericBoxType object : list)
			ret.addChildNode(GenericBoxTypeXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportGenericBoxTypesToXML(List<GenericBoxType> list){
		XMLNode ret = new XMLNode("GenericBoxTypes");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (GenericBoxType object : list)
			ret.addChildNode(GenericBoxTypeXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportGenericBoxHandlerDefsToXML(){
		XMLNode ret = new XMLNode("GenericBoxHandlerDefs");
		List<GenericBoxHandlerDef> list = getGenericBoxHandlerDefs();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (GenericBoxHandlerDef object : list)
			ret.addChildNode(GenericBoxHandlerDefXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportGenericBoxHandlerDefsToXML(List<GenericBoxHandlerDef> list){
		XMLNode ret = new XMLNode("GenericBoxHandlerDefs");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (GenericBoxHandlerDef object : list)
			ret.addChildNode(GenericBoxHandlerDefXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportGenericGuardDefsToXML(){
		XMLNode ret = new XMLNode("GenericGuardDefs");
		List<GenericGuardDef> list = getGenericGuardDefs();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (GenericGuardDef object : list)
			ret.addChildNode(GenericGuardDefXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportGenericGuardDefsToXML(List<GenericGuardDef> list){
		XMLNode ret = new XMLNode("GenericGuardDefs");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (GenericGuardDef object : list)
			ret.addChildNode(GenericGuardDefXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportToXML(){
		XMLNode ret = new XMLNode("ASGenericData");

		ret.addChildNode(exportGenericBoxTypesToXML());
		ret.addChildNode(exportGenericBoxHandlerDefsToXML());
		ret.addChildNode(exportGenericGuardDefsToXML());

		return ret;
	}
}
