/**
 ********************************************************************************
 *** BaseGenericGuardDefAction.java                                           ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asgenericdata.action;

import net.anotheria.anosite.gen.shared.action.BaseDefinitionsAction;
import jakarta.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.asgenericdata.data.GenericGuardDef;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseGenericGuardDefAction extends BaseDefinitionsAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Generic Guard";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASGenericData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "GenericGuardDef";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, GenericGuardDef genericguarddef) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASGenericData.GenericGuardDef").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASGenericData.GenericGuardDef", genericguarddef, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASGenericData.GenericGuardDef", genericguarddef, "clazz");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.clazz", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASGenericData.GenericGuardDef", genericguarddef, "parameter1");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameter1", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASGenericData.GenericGuardDef", genericguarddef, "parameter2");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameter2", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASGenericData.GenericGuardDef", genericguarddef, "parameter3");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameter3", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASGenericData.GenericGuardDef", genericguarddef, "parameter4");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameter4", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASGenericData.GenericGuardDef", genericguarddef, "parameter5");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameter5", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASGenericData.GenericGuardDef", genericguarddef, "description");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.description", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockGenericGuardDefs(GenericGuardDef genericguarddef, HttpServletRequest req) throws Exception{
		if(genericguarddef instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)genericguarddef;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASGenericDataService().updateGenericGuardDef( genericguarddef);
			logger.info("Lock-OPERATION, document with id : ["+genericguarddef.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockGenericGuardDefs(GenericGuardDef genericguarddef, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(genericguarddef instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)genericguarddef;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASGenericDataService().updateGenericGuardDef( genericguarddef);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+genericguarddef.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+genericguarddef.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkGenericGuardDefs(GenericGuardDef genericguarddef, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = genericguarddef instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)genericguarddef).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)genericguarddef).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockGenericGuardDefs(genericguarddef, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateGenericGuardDefs(GenericGuardDef genericguarddef, HttpServletRequest req) throws Exception{
		if(genericguarddef instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)genericguarddef, false, getUserId(req));
		}
		if (isTimeoutReached(genericguarddef)) {
			checkGenericGuardDefs(genericguarddef, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(genericguarddef, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(GenericGuardDef genericguarddef){
		if (genericguarddef instanceof LockableObject) {
			LockableObject lock = (LockableObject)genericguarddef;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(GenericGuardDef genericguarddef, HttpServletRequest req){
		if (genericguarddef instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)genericguarddef;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
