/**
 ********************************************************************************
 *** IASFederatedDataService.java                                             ***
 *** Generator: net.anotheria.asg.generator.model.ServiceGenerator            ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asfederateddata.service;

import java.util.List;
import net.anotheria.util.sorter.SortType;
import net.anotheria.anosite.gen.asfederateddata.data.BoxType;
import net.anotheria.anosite.gen.asfederateddata.data.BoxHandlerDef;
import net.anotheria.anosite.gen.asfederateddata.data.GuardDef;
import java.util.Set;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.slicer.Segment;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.asg.service.ASGService;

public interface IASFederatedDataService extends ASGService{

// Generated by: class net.anotheria.asg.generator.model.ServiceGenerator.generateInterface

	/**
	 * Returns all BoxTypes objects stored.
	 */
	List<BoxType> getBoxTypes() throws ASFederatedDataServiceException;

	/**
	 * Returns all BoxTypes objects sorted by given sortType.
	 */
	List<BoxType> getBoxTypes(SortType sortType) throws ASFederatedDataServiceException;

	/**
	 * Deletes a BoxType object by id.
	 */
	void deleteBoxType(String id) throws ASFederatedDataServiceException;

	/**
	 * Deletes a BoxType object.
	 */
	void deleteBoxType(BoxType boxtype) throws ASFederatedDataServiceException;

	/**
	 * Deletes multiple BoxType object.
	 */
	void deleteBoxTypes(List<BoxType> list) throws ASFederatedDataServiceException;

	/**
	 * Returns the BoxType object with the specified id.
	 */
	BoxType getBoxType(String id) throws ASFederatedDataServiceException;

	/**
	 * Imports a new BoxType object.
	 * Returns the created version.
	 */
	BoxType importBoxType(BoxType boxtype) throws ASFederatedDataServiceException;

	/**
	 * Imports multiple new  BoxType object.
	 * Returns the created versions.
	 */
	List<BoxType> importBoxTypes(List<BoxType> list) throws ASFederatedDataServiceException;

	/**
	 * Creates a new BoxType object.
	 * Returns the created version.
	 */
	BoxType createBoxType(BoxType boxtype) throws ASFederatedDataServiceException;

	/**
	 * Creates multiple new BoxType objects.
	 * Returns the created versions.
	 */
	List<BoxType> createBoxTypes(List<BoxType> list) throws ASFederatedDataServiceException;

	/**
	 * Updates a BoxType object.
	 * Returns the updated version.
	 */
	BoxType updateBoxType(BoxType boxtype) throws ASFederatedDataServiceException;

	/**
	 * Updates multiple BoxType objects.
	 * Returns the updated versions.
	 */
	List<BoxType> updateBoxTypes(List<BoxType> list) throws ASFederatedDataServiceException;

	/**
	 * Returns all BoxType objects, where property with given name equals object.
	 */
	List<BoxType> getBoxTypesByProperty(String propertyName, Object value) throws ASFederatedDataServiceException;

	/**
	 * Returns all BoxType objects, where property with given name equals object, sorted.
	 */
	List<BoxType> getBoxTypesByProperty(String propertyName, Object value, SortType sortType) throws ASFederatedDataServiceException;

	/**
	 * Executes a query.
	 */
	QueryResult executeQueryOnBoxTypes(DocumentQuery query) throws ASFederatedDataServiceException;

	/**
	 * Returns all BoxType objects, where property matches.
	 */
	List<BoxType> getBoxTypesByProperty(QueryProperty... property) throws ASFederatedDataServiceException;

	/**
	 * Returns all BoxType objects, where property matches, sorted.
	 */
	List<BoxType> getBoxTypesByProperty(SortType sortType, QueryProperty... property) throws ASFederatedDataServiceException;

	/**
	 * Returns all BoxTypes count.
	 */
	int getBoxTypesCount() throws ASFederatedDataServiceException;

	/**
	 * Returns BoxTypes objects segment.
	 */
	List<BoxType> getBoxTypes(Segment aSegment) throws ASFederatedDataServiceException;

	/**
	 * Returns BoxType objects segment, where property matches.
	 */
	List<BoxType> getBoxTypesByProperty(Segment aSegment, QueryProperty... aProperty) throws ASFederatedDataServiceException;

	/**
	 * Returns BoxType objects segment, where property matches, sorted.
	 */
	List<BoxType> getBoxTypesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty) throws ASFederatedDataServiceException;

	/**
	 * Creates an xml element with selected contained data.
	 */
	XMLNode exportBoxTypesToXML(List<BoxType> listBoxTypes)  throws ASFederatedDataServiceException;

	/**
	 * Create json object list dependencies for this BoxType document.
	 */
	void fetchBoxType(String id, Set<String> addedDocuments, JSONArray data) throws ASFederatedDataServiceException;

	/**
	 * Returns all BoxHandlerDefs objects stored.
	 */
	List<BoxHandlerDef> getBoxHandlerDefs() throws ASFederatedDataServiceException;

	/**
	 * Returns all BoxHandlerDefs objects sorted by given sortType.
	 */
	List<BoxHandlerDef> getBoxHandlerDefs(SortType sortType) throws ASFederatedDataServiceException;

	/**
	 * Deletes a BoxHandlerDef object by id.
	 */
	void deleteBoxHandlerDef(String id) throws ASFederatedDataServiceException;

	/**
	 * Deletes a BoxHandlerDef object.
	 */
	void deleteBoxHandlerDef(BoxHandlerDef boxhandlerdef) throws ASFederatedDataServiceException;

	/**
	 * Deletes multiple BoxHandlerDef object.
	 */
	void deleteBoxHandlerDefs(List<BoxHandlerDef> list) throws ASFederatedDataServiceException;

	/**
	 * Returns the BoxHandlerDef object with the specified id.
	 */
	BoxHandlerDef getBoxHandlerDef(String id) throws ASFederatedDataServiceException;

	/**
	 * Imports a new BoxHandlerDef object.
	 * Returns the created version.
	 */
	BoxHandlerDef importBoxHandlerDef(BoxHandlerDef boxhandlerdef) throws ASFederatedDataServiceException;

	/**
	 * Imports multiple new  BoxHandlerDef object.
	 * Returns the created versions.
	 */
	List<BoxHandlerDef> importBoxHandlerDefs(List<BoxHandlerDef> list) throws ASFederatedDataServiceException;

	/**
	 * Creates a new BoxHandlerDef object.
	 * Returns the created version.
	 */
	BoxHandlerDef createBoxHandlerDef(BoxHandlerDef boxhandlerdef) throws ASFederatedDataServiceException;

	/**
	 * Creates multiple new BoxHandlerDef objects.
	 * Returns the created versions.
	 */
	List<BoxHandlerDef> createBoxHandlerDefs(List<BoxHandlerDef> list) throws ASFederatedDataServiceException;

	/**
	 * Updates a BoxHandlerDef object.
	 * Returns the updated version.
	 */
	BoxHandlerDef updateBoxHandlerDef(BoxHandlerDef boxhandlerdef) throws ASFederatedDataServiceException;

	/**
	 * Updates multiple BoxHandlerDef objects.
	 * Returns the updated versions.
	 */
	List<BoxHandlerDef> updateBoxHandlerDefs(List<BoxHandlerDef> list) throws ASFederatedDataServiceException;

	/**
	 * Returns all BoxHandlerDef objects, where property with given name equals object.
	 */
	List<BoxHandlerDef> getBoxHandlerDefsByProperty(String propertyName, Object value) throws ASFederatedDataServiceException;

	/**
	 * Returns all BoxHandlerDef objects, where property with given name equals object, sorted.
	 */
	List<BoxHandlerDef> getBoxHandlerDefsByProperty(String propertyName, Object value, SortType sortType) throws ASFederatedDataServiceException;

	/**
	 * Executes a query.
	 */
	QueryResult executeQueryOnBoxHandlerDefs(DocumentQuery query) throws ASFederatedDataServiceException;

	/**
	 * Returns all BoxHandlerDef objects, where property matches.
	 */
	List<BoxHandlerDef> getBoxHandlerDefsByProperty(QueryProperty... property) throws ASFederatedDataServiceException;

	/**
	 * Returns all BoxHandlerDef objects, where property matches, sorted.
	 */
	List<BoxHandlerDef> getBoxHandlerDefsByProperty(SortType sortType, QueryProperty... property) throws ASFederatedDataServiceException;

	/**
	 * Returns all BoxHandlerDefs count.
	 */
	int getBoxHandlerDefsCount() throws ASFederatedDataServiceException;

	/**
	 * Returns BoxHandlerDefs objects segment.
	 */
	List<BoxHandlerDef> getBoxHandlerDefs(Segment aSegment) throws ASFederatedDataServiceException;

	/**
	 * Returns BoxHandlerDef objects segment, where property matches.
	 */
	List<BoxHandlerDef> getBoxHandlerDefsByProperty(Segment aSegment, QueryProperty... aProperty) throws ASFederatedDataServiceException;

	/**
	 * Returns BoxHandlerDef objects segment, where property matches, sorted.
	 */
	List<BoxHandlerDef> getBoxHandlerDefsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty) throws ASFederatedDataServiceException;

	/**
	 * Creates an xml element with selected contained data.
	 */
	XMLNode exportBoxHandlerDefsToXML(List<BoxHandlerDef> listBoxHandlerDefs)  throws ASFederatedDataServiceException;

	/**
	 * Create json object list dependencies for this BoxHandlerDef document.
	 */
	void fetchBoxHandlerDef(String id, Set<String> addedDocuments, JSONArray data) throws ASFederatedDataServiceException;

	/**
	 * Returns all GuardDefs objects stored.
	 */
	List<GuardDef> getGuardDefs() throws ASFederatedDataServiceException;

	/**
	 * Returns all GuardDefs objects sorted by given sortType.
	 */
	List<GuardDef> getGuardDefs(SortType sortType) throws ASFederatedDataServiceException;

	/**
	 * Deletes a GuardDef object by id.
	 */
	void deleteGuardDef(String id) throws ASFederatedDataServiceException;

	/**
	 * Deletes a GuardDef object.
	 */
	void deleteGuardDef(GuardDef guarddef) throws ASFederatedDataServiceException;

	/**
	 * Deletes multiple GuardDef object.
	 */
	void deleteGuardDefs(List<GuardDef> list) throws ASFederatedDataServiceException;

	/**
	 * Returns the GuardDef object with the specified id.
	 */
	GuardDef getGuardDef(String id) throws ASFederatedDataServiceException;

	/**
	 * Imports a new GuardDef object.
	 * Returns the created version.
	 */
	GuardDef importGuardDef(GuardDef guarddef) throws ASFederatedDataServiceException;

	/**
	 * Imports multiple new  GuardDef object.
	 * Returns the created versions.
	 */
	List<GuardDef> importGuardDefs(List<GuardDef> list) throws ASFederatedDataServiceException;

	/**
	 * Creates a new GuardDef object.
	 * Returns the created version.
	 */
	GuardDef createGuardDef(GuardDef guarddef) throws ASFederatedDataServiceException;

	/**
	 * Creates multiple new GuardDef objects.
	 * Returns the created versions.
	 */
	List<GuardDef> createGuardDefs(List<GuardDef> list) throws ASFederatedDataServiceException;

	/**
	 * Updates a GuardDef object.
	 * Returns the updated version.
	 */
	GuardDef updateGuardDef(GuardDef guarddef) throws ASFederatedDataServiceException;

	/**
	 * Updates multiple GuardDef objects.
	 * Returns the updated versions.
	 */
	List<GuardDef> updateGuardDefs(List<GuardDef> list) throws ASFederatedDataServiceException;

	/**
	 * Returns all GuardDef objects, where property with given name equals object.
	 */
	List<GuardDef> getGuardDefsByProperty(String propertyName, Object value) throws ASFederatedDataServiceException;

	/**
	 * Returns all GuardDef objects, where property with given name equals object, sorted.
	 */
	List<GuardDef> getGuardDefsByProperty(String propertyName, Object value, SortType sortType) throws ASFederatedDataServiceException;

	/**
	 * Executes a query.
	 */
	QueryResult executeQueryOnGuardDefs(DocumentQuery query) throws ASFederatedDataServiceException;

	/**
	 * Returns all GuardDef objects, where property matches.
	 */
	List<GuardDef> getGuardDefsByProperty(QueryProperty... property) throws ASFederatedDataServiceException;

	/**
	 * Returns all GuardDef objects, where property matches, sorted.
	 */
	List<GuardDef> getGuardDefsByProperty(SortType sortType, QueryProperty... property) throws ASFederatedDataServiceException;

	/**
	 * Returns all GuardDefs count.
	 */
	int getGuardDefsCount() throws ASFederatedDataServiceException;

	/**
	 * Returns GuardDefs objects segment.
	 */
	List<GuardDef> getGuardDefs(Segment aSegment) throws ASFederatedDataServiceException;

	/**
	 * Returns GuardDef objects segment, where property matches.
	 */
	List<GuardDef> getGuardDefsByProperty(Segment aSegment, QueryProperty... aProperty) throws ASFederatedDataServiceException;

	/**
	 * Returns GuardDef objects segment, where property matches, sorted.
	 */
	List<GuardDef> getGuardDefsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty) throws ASFederatedDataServiceException;

	/**
	 * Creates an xml element with selected contained data.
	 */
	XMLNode exportGuardDefsToXML(List<GuardDef> listGuardDefs)  throws ASFederatedDataServiceException;

	/**
	 * Create json object list dependencies for this GuardDef document.
	 */
	void fetchGuardDef(String id, Set<String> addedDocuments, JSONArray data) throws ASFederatedDataServiceException;

	/**
	 * Save transferred document by its own type.
	 */
	void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws ASFederatedDataServiceException;
	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service.
	 */
	QueryResult executeQueryOnAllObjects(DocumentQuery query) throws ASFederatedDataServiceException;
	/**
	 * creates an xml element with all contained data.
	 */
	XMLNode exportToXML() throws ASFederatedDataServiceException;

}
