/**
 ********************************************************************************
 *** ShowGuardDefsAction.java                                                 ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asfederateddata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.asfederateddata.data.GuardDef;
import net.anotheria.anosite.gen.asfederateddata.bean.GuardDefListItemBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.asfederateddata.bean.GuardDefListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;

public class ShowGuardDefsAction extends BaseGuardDefAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"GuardDef";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"GuardDef";
	private static Logger log = LoggerFactory.getLogger(ShowGuardDefsAction.class);
	private Sorter<GuardDefListItemBean> sorter;

	private DocumentFilter nameFilterAZ;

	public ShowGuardDefsAction(){
		sorter = new QuickSorter<GuardDefListItemBean>();
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		int sortMethod = GuardDefListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = GuardDefListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		GuardDefListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new GuardDefListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (GuardDefListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new GuardDefListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<GuardDef> _unfiltered_guarddefs = getASFederatedDataService().getGuardDefs();
		List<GuardDef> guarddefs = new ArrayList<GuardDef>();
		for (int i=0; i<_unfiltered_guarddefs.size(); i++){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass(_unfiltered_guarddefs.get(i), "name", filterParameter0));
			if (mayPass)
				guarddefs.add(_unfiltered_guarddefs.get(i));
		}
		List<GuardDefListItemBean> beans = new ArrayList<GuardDefListItemBean>(guarddefs.size());
		for (GuardDef guarddef : guarddefs){
			GuardDefListItemBean bean = makeGuardDefListItemBean(guarddef);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "guarddefs", beans);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer("name"));
		return mapping.success();
	}

	protected GuardDefListItemBean makeGuardDefListItemBean(GuardDef guarddef) {
		GuardDefListItemBean bean = new GuardDefListItemBean();
		bean.setPlainId(guarddef.getId());
		bean.setId(guarddef.getId());
		bean.setName(guarddef.getName());
		bean.setClazz(guarddef.getClazz());
		bean.setParameter1(guarddef.getParameter1());
		bean.setParameter2(guarddef.getParameter2());
		bean.setParameter3(guarddef.getParameter3());
		bean.setParameter4(guarddef.getParameter4());
		bean.setParameter5(guarddef.getParameter5());
		bean.setDescription(guarddef.getDescription());
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(guarddef.getLastUpdateTimestamp()));
		return bean;
	}
}
