/**
 ********************************************************************************
 *** ExportBoxTypesAction.java                                                ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asfederateddata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.xml.XMLNode;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.asfederateddata.data.BoxType;
import net.anotheria.anosite.gen.asfederateddata.data.BoxTypeSortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;
import net.anotheria.anosite.gen.asfederateddata.bean.BoxTypeListItemBeanSortType;

public class ExportBoxTypesAction extends BaseBoxTypeAction{

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"BoxType";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"BoxType";
	private static final List<String> ITEMS_ON_PAGE_SELECTOR = java.util.Arrays.asList(new String[]{"5","10","20","25","50","100","500","1000"});
	private static final Logger log = LoggerFactory.getLogger(ExportBoxTypesAction.class);
	private Sorter<BoxType> sorter;

	private DocumentFilter nameFilterAZ;

	public ExportBoxTypesAction(){
		super();
		sorter = new QuickSorter<BoxType>();
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		int sortMethod = BoxTypeListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = BoxTypeListItemBeanSortType.ASC;
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = BoxTypeListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			sortOrder = getStringParameter(req, PARAM_SORT_ORDER).equals("ASC") ? 
				BoxTypeListItemBeanSortType.ASC : BoxTypeListItemBeanSortType.DESC;
		}catch(Exception ignored){}

		BoxTypeListItemBeanSortType sessionSortType  = null;
		BoxTypeSortType sortType = null;
		if (sortParamSet){
			sessionSortType = new BoxTypeListItemBeanSortType(sortMethod, sortOrder);
			sortType = new BoxTypeSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sessionSortType);
		}else{
			sessionSortType = (BoxTypeListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			sortType = sessionSortType == null ? new BoxTypeSortType(sortMethod, sortOrder) : new BoxTypeSortType(sessionSortType.getSortBy(), sessionSortType.getSortOrder());
			sessionSortType = sessionSortType == null ? new BoxTypeListItemBeanSortType(sortMethod, sortOrder) : sessionSortType;
		}
		req.setAttribute("currentSortCode", sessionSortType.getMethodAndOrderCode());

		List<BoxType> _unfiltered_boxtypes = getASFederatedDataService().getBoxTypes();
		List<BoxType> boxtypes = new ArrayList<BoxType>();
		for (BoxType element : _unfiltered_boxtypes ){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass( element, "name", filterParameter0));
			if (mayPass)
				boxtypes.add(element);
		}
		boxtypes = sorter.sort(boxtypes, sortType);

		addBeanToRequest(req, "boxtypes", boxtypes);

		XMLNode beans = getASFederatedDataService().exportBoxTypesToXML(boxtypes);


		/**
		 * for XML node - page
		 */
		addBeanToRequest(req, "boxtypesXML", beans);
		/**
		 * for CSV - page
		 */
		addBeanToRequest(req, "boxtypesCSV", boxtypes);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer(""));
		return mapping.success();
	}

}
