/**
 ********************************************************************************
 *** ASFeatureServiceImpl.java                                                ***
 *** The implementation of the IASFeatureService.                             ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asfeature.service;

import java.nio.charset.Charset;
import java.util.List;
import java.util.ArrayList;
import java.util.Set;
import net.anotheria.anodoc.data.Module;
import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.sorter.StaticQuickSorter;
import net.anotheria.util.slicer.Segment;
import net.anotheria.util.slicer.Slicer;
import net.anotheria.anosite.gen.asfeature.data.ModuleASFeature;
import net.anotheria.anosite.gen.shared.service.BasicCMSService;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryResultEntry;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.util.StringUtils;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.xml.XMLAttribute;
import net.anotheria.asg.util.listener.IModuleListener;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import net.anotheria.anodoc.util.mapper.ObjectMapperUtil;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.anosite.gen.asfeature.data.Feature;
import net.anotheria.anosite.gen.asfeature.data.FeatureXMLHelper;
import net.anotheria.anosite.gen.asfeature.data.FeatureDocument;
import net.anotheria.anosite.gen.anoaccessconfiguration.service.AnoAccessConfigurationServiceException;
import net.anotheria.anosite.gen.asfederateddata.service.ASFederatedDataServiceException;
import net.anotheria.anosite.gen.asfeature.data.BrandFeature;
import net.anotheria.anosite.gen.asfeature.data.BrandFeatureXMLHelper;
import net.anotheria.anosite.gen.asfeature.data.BrandFeatureDocument;
import net.anotheria.anosite.gen.asbrand.service.ASBrandServiceException;

public class ASFeatureServiceImpl extends BasicCMSService implements IASFeatureService, IModuleListener{

	// Generated by: class net.anotheria.asg.generator.model.docs.CMSBasedServiceGenerator.generateImplementation

	private static ASFeatureServiceImpl instance;

	private ASFeatureServiceImpl(){
		addServiceListener(new net.anotheria.anosite.cms.listener.CRUDLogListener());
		addServiceListener(new net.anotheria.anosite.cms.listener.AutoTransferFeatureListener());
		addModuleListener(ModuleASFeature.MODULE_ID, this);
	}

	static final ASFeatureServiceImpl getInstance(){
		if (instance==null){
			instance = new ASFeatureServiceImpl();
		}
		return instance;
	}

	private ModuleASFeature _getModuleASFeature(){
		return (ModuleASFeature) getModule(ModuleASFeature.MODULE_ID);
	}

	@Override
	public void moduleLoaded(Module module){
		firePersistenceChangedEvent();
	}

	@Override
	public List<Feature> getFeatures(){
		List<Feature> features = new ArrayList<>();
		features.addAll(_getModuleASFeature().getFeatures());
		return features;
	}

	@Override
	public List<Feature> getFeatures(SortType sortType){
		return StaticQuickSorter.sort(getFeatures(), sortType);
	}

	/**
	 * Returns the Feature objects with the specified ids.
	 */
	public List<Feature> getFeatures(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<Feature> all = getFeatures();
		List<Feature> ret = new ArrayList<>();
		for (Feature feature : all){
			if(ids.contains(feature.getId())){
				ret.add(feature);
			}
		}
		return ret;
	}

	/**
	 * Returns the Feature objects with the specified ids, sorted by given sorttype.
	 */
	public List<Feature> getFeatures(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getFeatures(ids), sortType);
	}

	@Override
	public void deleteFeature(Feature feature){
		deleteFeature(feature.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(feature);
		}
	}

	@Override
	public void deleteFeature(String id){
		ModuleASFeature module = _getModuleASFeature();
		Feature varValue = hasServiceListeners()?module.getFeature(id):null;
		module.deleteFeature(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteFeatures(List<Feature> list){
		ModuleASFeature module = _getModuleASFeature();
		for (Feature feature : list){
			module.deleteFeature(feature.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public Feature getFeature(String id){
		return _getModuleASFeature().getFeature(id);
	}

	@Override
	public Feature importFeature(Feature feature){
		ModuleASFeature module = _getModuleASFeature();
		module.importFeature((FeatureDocument)feature);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(feature);
		}
		return feature;
	}

	@Override
	public List<Feature> importFeatures(List<Feature> list){
		ModuleASFeature module = _getModuleASFeature();
		List<Feature> ret = new ArrayList<>();
		for (Feature feature : list){
			Feature imported = module.importFeature((FeatureDocument)feature);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (Feature feature : ret)
				fireObjectImportedEvent(feature);
		}
		return ret;
	}

	@Override
	public Feature createFeature(Feature feature){
		ModuleASFeature module = _getModuleASFeature();
		module.createFeature((FeatureDocument)feature);
		updateModule(module);
		fireObjectCreatedEvent(feature);
		return feature;
	}

	@Override
	/**
	 * Creates multiple new Feature objects.
	 * Returns the created versions.
	 */
	public List<Feature> createFeatures(List<Feature> list){
		ModuleASFeature module = _getModuleASFeature();
		List<Feature> ret = new ArrayList<>();
		for (Feature feature : list){
			Feature created = module.createFeature((FeatureDocument)feature);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (Feature feature : ret)
				fireObjectCreatedEvent(feature);
		}
		return ret;
	}

	@Override
	public Feature updateFeature(Feature feature){
		Feature oldVersion = null;
		ModuleASFeature module = _getModuleASFeature();
		if (hasServiceListeners())
			oldVersion = module.getFeature(feature.getId());
		module.updateFeature((FeatureDocument)feature);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, feature);
		}
		return feature;
	}

	@Override
	public List<Feature> updateFeatures(List<Feature> list){
		List<Feature> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASFeature module = _getModuleASFeature();
		for (Feature feature : list){
			if (oldList!=null)
				oldList.add(module.getFeature(feature.getId()));
			module.updateFeature((FeatureDocument)feature);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<Feature> getFeaturesByProperty(String propertyName, Object value){
		List<Feature> allFeatures = getFeatures();
		List<Feature> ret = new ArrayList<>();
		for (int i=0; i<allFeatures.size(); i++){
			Feature feature = allFeatures.get(i);
			try{
				Property property = ((FeatureDocument)feature).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(feature);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(feature);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(feature);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<Feature> getFeaturesByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getFeaturesByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on Features
	 */
	public QueryResult executeQueryOnFeatures(DocumentQuery query){
		List<Feature> allFeatures = getFeatures();
		QueryResult result = new QueryResult();
		for (int i=0; i<allFeatures.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allFeatures.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all Feature objects, where property matches.
	 */
	public List<Feature> getFeaturesByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<Feature> ret = new ArrayList<>();
		List<Feature> src = getFeatures();
		for ( Feature feature : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(feature.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(feature);
		}
		return ret;
	}

	/**
	 * Returns all Feature objects, where property matches, sorted
	 */
	public List<Feature> getFeaturesByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getFeaturesByProperty(property), sortType);
	}

	/**
	 * Returns Feature objects count.
	 */
	public int getFeaturesCount() {
		return _getModuleASFeature().getFeatures().size();
	}

	/**
	 * Returns Feature objects segment.
	 */
	public List<Feature> getFeatures(Segment aSegment) {
		return Slicer.slice(aSegment, getFeatures()).getSliceData();
	}

	/**
	 * Returns Feature objects segment, where property matched.
	 */
	public List<Feature> getFeaturesByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<Feature> ret = new ArrayList<>();
		List<Feature> src = getFeatures();
		for (Feature feature : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(feature.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(feature);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns Feature objects segment, where property matched, sorted.
	 */
	public List<Feature> getFeaturesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getFeaturesByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchFeature(final String id, Set<String> addedDocuments, JSONArray data) throws ASFeatureServiceException {
		if (id.isEmpty() || addedDocuments.contains("Feature" + id))
			return;

		try {
			final FeatureDocument feature = _getModuleASFeature().getFeature(id);
			addedDocuments.add("Feature" + id);

			if (!StringUtils.isEmpty(feature.getAccessOperation()))
				getAnoAccessConfigurationService().fetchAccessOperation(feature.getAccessOperation(), addedDocuments, data);

			if (!feature.getGuards().isEmpty()) {
				for (String aGuardsId: feature.getGuards()) {
					getASFederatedDataService().fetchGuardDef(aGuardsId, addedDocuments, data);
				}
			}

			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(feature);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASFeature");
			dataObject.put("document", "ASFeature_Feature");

			data.put(dataObject);

		}catch(AnoAccessConfigurationServiceException e){
			throw new ASFeatureServiceException("Problem with getting document from AnoAccessConfiguration" + e.getMessage());
		}catch(ASFederatedDataServiceException e){
			throw new ASFeatureServiceException("Problem with getting document from ASFederatedData" + e.getMessage());
		}catch(IOException e){
			throw new ASFeatureServiceException ("Problem with fetching data for this Feature instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASFeatureServiceException ("Problem with fetching data for this Feature instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredFeature(final JSONObject data) throws ASFeatureServiceException {
		try {
			String objectData = data.getString("object");
			Feature feature = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), FeatureDocument.class);

			try {
				updateFeature(feature);
			}catch(Exception e){
				importFeature(feature);
			}
		}catch(JSONException e){
			throw new ASFeatureServiceException("Problem with getting data from json Feature instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASFeatureServiceException("Problem with parsing data for this Feature instance :" + e.getMessage());
		}
	}

	@Override
	public List<BrandFeature> getBrandFeatures(){
		List<BrandFeature> brandfeatures = new ArrayList<>();
		brandfeatures.addAll(_getModuleASFeature().getBrandFeatures());
		return brandfeatures;
	}

	@Override
	public List<BrandFeature> getBrandFeatures(SortType sortType){
		return StaticQuickSorter.sort(getBrandFeatures(), sortType);
	}

	/**
	 * Returns the BrandFeature objects with the specified ids.
	 */
	public List<BrandFeature> getBrandFeatures(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<BrandFeature> all = getBrandFeatures();
		List<BrandFeature> ret = new ArrayList<>();
		for (BrandFeature brandfeature : all){
			if(ids.contains(brandfeature.getId())){
				ret.add(brandfeature);
			}
		}
		return ret;
	}

	/**
	 * Returns the BrandFeature objects with the specified ids, sorted by given sorttype.
	 */
	public List<BrandFeature> getBrandFeatures(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getBrandFeatures(ids), sortType);
	}

	@Override
	public void deleteBrandFeature(BrandFeature brandfeature){
		deleteBrandFeature(brandfeature.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(brandfeature);
		}
	}

	@Override
	public void deleteBrandFeature(String id){
		ModuleASFeature module = _getModuleASFeature();
		BrandFeature varValue = hasServiceListeners()?module.getBrandFeature(id):null;
		module.deleteBrandFeature(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteBrandFeatures(List<BrandFeature> list){
		ModuleASFeature module = _getModuleASFeature();
		for (BrandFeature brandfeature : list){
			module.deleteBrandFeature(brandfeature.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public BrandFeature getBrandFeature(String id){
		return _getModuleASFeature().getBrandFeature(id);
	}

	@Override
	public BrandFeature importBrandFeature(BrandFeature brandfeature){
		ModuleASFeature module = _getModuleASFeature();
		module.importBrandFeature((BrandFeatureDocument)brandfeature);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(brandfeature);
		}
		return brandfeature;
	}

	@Override
	public List<BrandFeature> importBrandFeatures(List<BrandFeature> list){
		ModuleASFeature module = _getModuleASFeature();
		List<BrandFeature> ret = new ArrayList<>();
		for (BrandFeature brandfeature : list){
			BrandFeature imported = module.importBrandFeature((BrandFeatureDocument)brandfeature);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (BrandFeature brandfeature : ret)
				fireObjectImportedEvent(brandfeature);
		}
		return ret;
	}

	@Override
	public BrandFeature createBrandFeature(BrandFeature brandfeature){
		ModuleASFeature module = _getModuleASFeature();
		module.createBrandFeature((BrandFeatureDocument)brandfeature);
		updateModule(module);
		fireObjectCreatedEvent(brandfeature);
		return brandfeature;
	}

	@Override
	/**
	 * Creates multiple new BrandFeature objects.
	 * Returns the created versions.
	 */
	public List<BrandFeature> createBrandFeatures(List<BrandFeature> list){
		ModuleASFeature module = _getModuleASFeature();
		List<BrandFeature> ret = new ArrayList<>();
		for (BrandFeature brandfeature : list){
			BrandFeature created = module.createBrandFeature((BrandFeatureDocument)brandfeature);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (BrandFeature brandfeature : ret)
				fireObjectCreatedEvent(brandfeature);
		}
		return ret;
	}

	@Override
	public BrandFeature updateBrandFeature(BrandFeature brandfeature){
		BrandFeature oldVersion = null;
		ModuleASFeature module = _getModuleASFeature();
		if (hasServiceListeners())
			oldVersion = module.getBrandFeature(brandfeature.getId());
		module.updateBrandFeature((BrandFeatureDocument)brandfeature);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, brandfeature);
		}
		return brandfeature;
	}

	@Override
	public List<BrandFeature> updateBrandFeatures(List<BrandFeature> list){
		List<BrandFeature> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASFeature module = _getModuleASFeature();
		for (BrandFeature brandfeature : list){
			if (oldList!=null)
				oldList.add(module.getBrandFeature(brandfeature.getId()));
			module.updateBrandFeature((BrandFeatureDocument)brandfeature);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<BrandFeature> getBrandFeaturesByProperty(String propertyName, Object value){
		List<BrandFeature> allBrandFeatures = getBrandFeatures();
		List<BrandFeature> ret = new ArrayList<>();
		for (int i=0; i<allBrandFeatures.size(); i++){
			BrandFeature brandfeature = allBrandFeatures.get(i);
			try{
				Property property = ((BrandFeatureDocument)brandfeature).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(brandfeature);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(brandfeature);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(brandfeature);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<BrandFeature> getBrandFeaturesByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getBrandFeaturesByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on BrandFeatures
	 */
	public QueryResult executeQueryOnBrandFeatures(DocumentQuery query){
		List<BrandFeature> allBrandFeatures = getBrandFeatures();
		QueryResult result = new QueryResult();
		for (int i=0; i<allBrandFeatures.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allBrandFeatures.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all BrandFeature objects, where property matches.
	 */
	public List<BrandFeature> getBrandFeaturesByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<BrandFeature> ret = new ArrayList<>();
		List<BrandFeature> src = getBrandFeatures();
		for ( BrandFeature brandfeature : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(brandfeature.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(brandfeature);
		}
		return ret;
	}

	/**
	 * Returns all BrandFeature objects, where property matches, sorted
	 */
	public List<BrandFeature> getBrandFeaturesByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getBrandFeaturesByProperty(property), sortType);
	}

	/**
	 * Returns BrandFeature objects count.
	 */
	public int getBrandFeaturesCount() {
		return _getModuleASFeature().getBrandFeatures().size();
	}

	/**
	 * Returns BrandFeature objects segment.
	 */
	public List<BrandFeature> getBrandFeatures(Segment aSegment) {
		return Slicer.slice(aSegment, getBrandFeatures()).getSliceData();
	}

	/**
	 * Returns BrandFeature objects segment, where property matched.
	 */
	public List<BrandFeature> getBrandFeaturesByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<BrandFeature> ret = new ArrayList<>();
		List<BrandFeature> src = getBrandFeatures();
		for (BrandFeature brandfeature : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(brandfeature.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(brandfeature);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns BrandFeature objects segment, where property matched, sorted.
	 */
	public List<BrandFeature> getBrandFeaturesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getBrandFeaturesByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchBrandFeature(final String id, Set<String> addedDocuments, JSONArray data) throws ASFeatureServiceException {
		if (id.isEmpty() || addedDocuments.contains("BrandFeature" + id))
			return;

		try {
			final BrandFeatureDocument brandfeature = _getModuleASFeature().getBrandFeature(id);
			addedDocuments.add("BrandFeature" + id);

			if (!StringUtils.isEmpty(brandfeature.getAccessOperation()))
				getAnoAccessConfigurationService().fetchAccessOperation(brandfeature.getAccessOperation(), addedDocuments, data);

			if (!brandfeature.getGuards().isEmpty()) {
				for (String aGuardsId: brandfeature.getGuards()) {
					getASFederatedDataService().fetchGuardDef(aGuardsId, addedDocuments, data);
				}
			}
			if (!brandfeature.getBrands().isEmpty()) {
				for (String aBrandsId: brandfeature.getBrands()) {
					getASBrandService().fetchBrand(aBrandsId, addedDocuments, data);
				}
			}

			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(brandfeature);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASFeature");
			dataObject.put("document", "ASFeature_BrandFeature");

			data.put(dataObject);

		}catch(AnoAccessConfigurationServiceException e){
			throw new ASFeatureServiceException("Problem with getting document from AnoAccessConfiguration" + e.getMessage());
		}catch(ASBrandServiceException e){
			throw new ASFeatureServiceException("Problem with getting document from ASBrand" + e.getMessage());
		}catch(ASFederatedDataServiceException e){
			throw new ASFeatureServiceException("Problem with getting document from ASFederatedData" + e.getMessage());
		}catch(IOException e){
			throw new ASFeatureServiceException ("Problem with fetching data for this BrandFeature instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASFeatureServiceException ("Problem with fetching data for this BrandFeature instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredBrandFeature(final JSONObject data) throws ASFeatureServiceException {
		try {
			String objectData = data.getString("object");
			BrandFeature brandfeature = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), BrandFeatureDocument.class);

			try {
				updateBrandFeature(brandfeature);
			}catch(Exception e){
				importBrandFeature(brandfeature);
			}
		}catch(JSONException e){
			throw new ASFeatureServiceException("Problem with getting data from json BrandFeature instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASFeatureServiceException("Problem with parsing data for this BrandFeature instance :" + e.getMessage());
		}
	}

	public void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws ASFeatureServiceException {
		switch(documentName) {
			case DOCUMENT_ASFEATURE_FEATURE:
				saveTransferredFeature(data);
				break;
			case DOCUMENT_ASFEATURE_BRANDFEATURE:
				saveTransferredBrandFeature(data);
				break;
			default:
				log.info("There is no correct document: " + documentName + "in this service");
				throw new ASFeatureServiceException("No such document");
		}
	}

	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service
	 */
	public QueryResult executeQueryOnAllObjects(DocumentQuery query){
		QueryResult ret = new QueryResult();
		ret.add(executeQueryOnFeatures(query).getEntries());
		ret.add(executeQueryOnBrandFeatures(query).getEntries());
		return ret;
	} //executeQueryOnAllObjects


	public XMLNode exportFeaturesToXML(){
		XMLNode ret = new XMLNode("Features");
		List<Feature> list = getFeatures();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Feature object : list)
			ret.addChildNode(FeatureXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportFeaturesToXML(List<Feature> list){
		XMLNode ret = new XMLNode("Features");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Feature object : list)
			ret.addChildNode(FeatureXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportBrandFeaturesToXML(){
		XMLNode ret = new XMLNode("BrandFeatures");
		List<BrandFeature> list = getBrandFeatures();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (BrandFeature object : list)
			ret.addChildNode(BrandFeatureXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportBrandFeaturesToXML(List<BrandFeature> list){
		XMLNode ret = new XMLNode("BrandFeatures");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (BrandFeature object : list)
			ret.addChildNode(BrandFeatureXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportToXML(){
		XMLNode ret = new XMLNode("ASFeature");

		ret.addChildNode(exportFeaturesToXML());
		ret.addChildNode(exportBrandFeaturesToXML());

		return ret;
	}
}
