/**
 ********************************************************************************
 *** BaseCustomBoxHandlerDefAction.java                                       ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.ascustomdata.action;

import net.anotheria.anosite.gen.shared.action.BaseDefinitionsAction;
import jakarta.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.ascustomdata.data.CustomBoxHandlerDef;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseCustomBoxHandlerDefAction extends BaseDefinitionsAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "CustomBoxHandler";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASCustomData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "CustomBoxHandlerDef";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, CustomBoxHandlerDef customboxhandlerdef) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASCustomData.CustomBoxHandlerDef").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASCustomData.CustomBoxHandlerDef", customboxhandlerdef, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASCustomData.CustomBoxHandlerDef", customboxhandlerdef, "clazz");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.clazz", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockCustomBoxHandlerDefs(CustomBoxHandlerDef customboxhandlerdef, HttpServletRequest req) throws Exception{
		if(customboxhandlerdef instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)customboxhandlerdef;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASCustomDataService().updateCustomBoxHandlerDef( customboxhandlerdef);
			logger.info("Lock-OPERATION, document with id : ["+customboxhandlerdef.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockCustomBoxHandlerDefs(CustomBoxHandlerDef customboxhandlerdef, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(customboxhandlerdef instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)customboxhandlerdef;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASCustomDataService().updateCustomBoxHandlerDef( customboxhandlerdef);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+customboxhandlerdef.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+customboxhandlerdef.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkCustomBoxHandlerDefs(CustomBoxHandlerDef customboxhandlerdef, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = customboxhandlerdef instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)customboxhandlerdef).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)customboxhandlerdef).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockCustomBoxHandlerDefs(customboxhandlerdef, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateCustomBoxHandlerDefs(CustomBoxHandlerDef customboxhandlerdef, HttpServletRequest req) throws Exception{
		if(customboxhandlerdef instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)customboxhandlerdef, false, getUserId(req));
		}
		if (isTimeoutReached(customboxhandlerdef)) {
			checkCustomBoxHandlerDefs(customboxhandlerdef, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(customboxhandlerdef, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(CustomBoxHandlerDef customboxhandlerdef){
		if (customboxhandlerdef instanceof LockableObject) {
			LockableObject lock = (LockableObject)customboxhandlerdef;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(CustomBoxHandlerDef customboxhandlerdef, HttpServletRequest req){
		if (customboxhandlerdef instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)customboxhandlerdef;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
