/**
 ********************************************************************************
 *** ModuleASBrand.java                                                       ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asbrand.data;

import net.anotheria.anodoc.data.Module;
import net.anotheria.anodoc.data.DocumentList;
import net.anotheria.anodoc.data.IDHolder;
import net.anotheria.anodoc.data.NoSuchDocumentListException;
import java.util.List;

public class ModuleASBrand extends Module{


	public static final String MODULE_ID = "asbrand";

	public static final String LIST_BRAND = "list_brand";
	public static final String ID_HOLDER_BRAND = IDHolder.DOC_ID_HOLDER_PRE+"brand";

	public ModuleASBrand(){
		super(MODULE_ID);
	}

	@SuppressWarnings("unchecked")
	private DocumentList<BrandDocument> _getBrands(){
		try{
			return getList(LIST_BRAND);
		}catch(NoSuchDocumentListException e){
			return new DocumentList<BrandDocument>(LIST_BRAND);
		}
	}

	private void _updateBrands(DocumentList<BrandDocument> list){
		putList(list);
	}

	public List<BrandDocument> getBrands(){
		return _getBrands().getList();
	}

	public BrandDocument getBrand(String id){
		return _getBrands().getDocumentById(id);
	}

	public void updateBrand(BrandDocument brand){
		DocumentList<BrandDocument> brands = _getBrands();
		brands.removeDocumentById(brand.getId());
		brand.setLastUpdateNow();
		brand.setCallContextAuthor();
		brands.addDocument(brand);
		_updateBrands(brands);
	}

	public void deleteBrand(String id){
		DocumentList<BrandDocument> entries = _getBrands();
		entries.removeDocumentById(id);
		_updateBrands(entries);
	}

	public BrandDocument createBrand(BrandDocument brand ){
		IDHolder idh = _getIdHolder(ID_HOLDER_BRAND);
		int id = idh.getNextIdInt();
		brand.renameTo(""+id);
		putDocument(idh);

		DocumentList<BrandDocument> entries = _getBrands();
		brand.setLastUpdateNow();
		brand.setCallContextAuthor();
		entries.addDocument(brand);
		_updateBrands(entries);
		return brand;
	}

	public BrandDocument importBrand(BrandDocument brand ){
		IDHolder idh = _getIdHolder(ID_HOLDER_BRAND);
		idh.adjustTill(brand.getId());
		putDocument(idh);

		DocumentList<BrandDocument> entries = _getBrands();
		brand.setLastUpdateNow();
		brand.setCallContextAuthor();
		entries.addDocument(brand);
		_updateBrands(entries);
		return brand;
	}


}
