/**
 **********************************************************************************************************************************************
 *** ASActionServiceImpl.java                                                                                                               ***
 *** The implementation of the IASActionServiceas a federated service layer: Federated modules: ASGenericAction as G, ASCustomAction as C,  ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                                                                                    ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net                                                                             ***
 *** All Rights Reserved.                                                                                                                   ***
 **********************************************************************************************************************************************
 *** Don't edit this code, if you aren't sure                                                                                               ***
 *** that you do exactly know what you are doing!                                                                                           ***
 *** It's better to invest time in the generator, as into the generated code.                                                               ***
 **********************************************************************************************************************************************
 */

package net.anotheria.anosite.gen.asaction.service;

import java.nio.charset.Charset;
import java.util.List;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.io.IOException;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.sorter.StaticQuickSorter;
import net.anotheria.util.StringUtils;
import net.anotheria.util.slicer.Segment;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.anosite.gen.shared.service.BasicService;
import net.anotheria.anosite.gen.asgenericaction.service.IASGenericActionService;
import net.anotheria.anosite.gen.asgenericaction.service.ASGenericActionServiceException;
import net.anotheria.anosite.gen.asgenericaction.service.ASGenericActionServiceFactory;
import net.anotheria.anosite.gen.ascustomaction.service.IASCustomActionService;
import net.anotheria.anosite.gen.ascustomaction.service.ASCustomActionServiceException;
import net.anotheria.anosite.gen.ascustomaction.service.ASCustomActionServiceFactory;
import net.anotheria.anosite.gen.asaction.data.ActionDef;
import net.anotheria.anosite.gen.asaction.data.ActionDefVO;
import net.anotheria.anosite.gen.asaction.data.ActionDefFactory;
import net.anotheria.anosite.gen.asgenericaction.data.GenericActionDef;
import net.anotheria.anosite.gen.ascustomaction.data.CustomActionDef;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryResultEntry;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.util.xml.XMLNode;

public class ASActionServiceImpl extends BasicService implements IASActionService{

	// Generated by: class net.anotheria.asg.generator.model.federation.FederationServiceGenerator.generateImplementation


	private static ASActionServiceImpl instance;

	// Federated services: 
	public static final char ID_DELIMITER = '-';
	IASGenericActionService federatedG;
	public static final String ID_PREFIX_G = "G"+ID_DELIMITER;
	IASCustomActionService federatedC;
	public static final String ID_PREFIX_C = "C"+ID_DELIMITER;

	private HashMap<String, Object> federatedServiceMap;
	private ASActionServiceImpl(){
		addServiceListener(new net.anotheria.anosite.cms.listener.CRUDLogListener());

		federatedServiceMap = new HashMap<String, Object>(2);
		federatedG = ASGenericActionServiceFactory.createASGenericActionService();
		federatedServiceMap.put("G", federatedG);
		federatedC = ASCustomActionServiceFactory.createASCustomActionService();
		federatedServiceMap.put("C", federatedC);
	}

	static final ASActionServiceImpl getInstance(){
		if (instance==null){
			instance = new ASActionServiceImpl();
		}
		return instance;
	}

	private ActionDef copy(GenericActionDef d){
		ActionDef ret = ActionDefFactory.createActionDef(ID_PREFIX_G+d.getId());
		ret.setName(d.getName());
		ret.setClazz(d.getClazz());
		((ActionDefVO)ret).setLastUpdateTimestamp(d.getLastUpdateTimestamp());
		return ret;
	}

	private List<ActionDef> copyActionDefListG(List<GenericActionDef> list){
		List<ActionDef> ret = new ArrayList<ActionDef>(list.size());
		for (GenericActionDef d : list)
			ret.add(copy(d));
		return ret;
	}

	private ActionDef copy(CustomActionDef d){
		ActionDef ret = ActionDefFactory.createActionDef(ID_PREFIX_C+d.getId());
		ret.setName(d.getName());
		ret.setClazz(d.getClazz());
		((ActionDefVO)ret).setLastUpdateTimestamp(d.getLastUpdateTimestamp());
		return ret;
	}

	private List<ActionDef> copyActionDefListC(List<CustomActionDef> list){
		List<ActionDef> ret = new ArrayList<ActionDef>(list.size());
		for (CustomActionDef d : list)
			ret.add(copy(d));
		return ret;
	}

	public List<ActionDef> getActionDefs() throws ASActionServiceException {
		List<ActionDef> actiondefs = new ArrayList<ActionDef>();
		try{
			List<GenericActionDef> sourceG = federatedG.getGenericActionDefs();
			actiondefs.addAll(copyActionDefListG(sourceG));
		}catch(ASGenericActionServiceException e){
		// TODO Add logging?
			throw new ASActionServiceException("Undelying service failed: "+e.getMessage());
		}
		try{
			List<CustomActionDef> sourceC = federatedC.getCustomActionDefs();
			actiondefs.addAll(copyActionDefListC(sourceC));
		}catch(ASCustomActionServiceException e){
		// TODO Add logging?
			throw new ASActionServiceException("Undelying service failed: "+e.getMessage());
		}
		return actiondefs;
	}

	public List<ActionDef> getActionDefs(SortType sortType) throws ASActionServiceException {
		return StaticQuickSorter.sort(getActionDefs(), sortType);
	}

	public void deleteActionDef(ActionDef actiondef) throws ASActionServiceException {
		deleteActionDef(actiondef.getId());
	}

	public void deleteActionDef(String id) throws ASActionServiceException {
		throw new RuntimeException("not implemented.");
	}

	/**
	 * Deletes multiple ActionDef objects.
	 */
	public void deleteActionDefs(List<ActionDef> list) throws ASActionServiceException {
		throw new RuntimeException("Not yet implemented");
	}

	public ActionDef getActionDef(String id) throws ASActionServiceException {
		String tokens[] = StringUtils.tokenize(id, ID_DELIMITER);
		if (tokens[0].equals("G")){
			try{
				return copy(federatedG.getGenericActionDef(tokens[1]));
			}catch(ASGenericActionServiceException e){
			// TODO Add logging?
				throw new ASActionServiceException("Undelying service failed: "+e.getMessage());
			}
		}
		if (tokens[0].equals("C")){
			try{
				return copy(federatedC.getCustomActionDef(tokens[1]));
			}catch(ASCustomActionServiceException e){
			// TODO Add logging?
				throw new ASActionServiceException("Undelying service failed: "+e.getMessage());
			}
		}
		throw new RuntimeException("Unknown federated key: "+tokens[0]+" in "+id);
	}

	public ActionDef importActionDef(ActionDef actiondef) throws ASActionServiceException {
		throw new RuntimeException("no import in federated services.");
	}

	public List<ActionDef> importActionDefs(List<ActionDef> list) throws ASActionServiceException {
		throw new RuntimeException("no import in federated services.");
	}

	public ActionDef createActionDef(ActionDef actiondef) throws ASActionServiceException {
		throw new AssertionError("not implemented.");
	}

	/**
	 * Creates multiple new ActionDef objects.
	 * Returns the created versions.
	 */
	public List<ActionDef> createActionDefs(List<ActionDef> list) throws ASActionServiceException {
		throw new AssertionError("not implemented.");
	}

	/**
	 * Updates multiple new ActionDef objects.
	 * Returns the updated versions.
	 */
	public List<ActionDef> updateActionDefs(List<ActionDef> list) throws ASActionServiceException {
		throw new RuntimeException("Not yet implemented");
	}

	public ActionDef updateActionDef(ActionDef actiondef) throws ASActionServiceException {
		throw new AssertionError("not implemented.");
	}

	public List<ActionDef> getActionDefsByProperty(String propertyName, Object value) throws ASActionServiceException {
		List<ActionDef> actiondefs = new ArrayList<ActionDef>();
		try{
			List<GenericActionDef> sourceG = federatedG.getGenericActionDefsByProperty(propertyName, value);
			actiondefs.addAll(copyActionDefListG(sourceG));
		}catch(ASGenericActionServiceException e){
		// TODO Add logging?
			throw new ASActionServiceException("Undelying service failed: "+e.getMessage());
		}
		try{
			List<CustomActionDef> sourceC = federatedC.getCustomActionDefsByProperty(propertyName, value);
			actiondefs.addAll(copyActionDefListC(sourceC));
		}catch(ASCustomActionServiceException e){
		// TODO Add logging?
			throw new ASActionServiceException("Undelying service failed: "+e.getMessage());
		}
		return actiondefs;
	}

	public List<ActionDef> getActionDefsByProperty(String propertyName, Object value, SortType sortType) throws ASActionServiceException {
		return StaticQuickSorter.sort(getActionDefsByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on ActionDefs
	 */
	public QueryResult executeQueryOnActionDefs(DocumentQuery query) throws ASActionServiceException {
		List<ActionDef> allActionDefs = getActionDefs();
		QueryResult result = new QueryResult();
		for (int i=0; i<allActionDefs.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allActionDefs.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all ActionDef objects, where property matches.
	 */
	public List<ActionDef> getActionDefsByProperty(QueryProperty... property) throws ASActionServiceException {
		throw new RuntimeException("Not yet implemented");
	}

	/**
	 * Returns all ActionDef objects, where property matches, sorted
	 */
	public List<ActionDef> getActionDefsByProperty(SortType sortType, QueryProperty... property) throws ASActionServiceException {
		throw new RuntimeException("Not yet implemented");
	}

	/**
	 * Returns ActionDef objects count.
	 */
	public int getActionDefsCount() throws ASActionServiceException {
		int pCount = 0;
		try {
			pCount = pCount + federatedG.getGenericActionDefs().size();
		} catch (ASGenericActionServiceException e) {
			throw new ASActionServiceException("Undelying service failed: "+e.getMessage());
		}
		try {
			pCount = pCount + federatedC.getCustomActionDefs().size();
		} catch (ASCustomActionServiceException e) {
			throw new ASActionServiceException("Undelying service failed: "+e.getMessage());
		}
		return pCount;
	}

	/**
	 * Returns ActionDef objects segment.
	 */
	public List<ActionDef> getActionDefs(Segment aSegment) throws ASActionServiceException {
		throw new RuntimeException("Not yet implemented");
	}

	/**
	 * Returns ActionDef objects segment, where property matched.
	 */
	public List<ActionDef> getActionDefsByProperty(Segment aSegment, QueryProperty... aProperty) throws ASActionServiceException {
		throw new RuntimeException("Not yet implemented");
	}

	/**
	 * Returns ActionDef objects segment, where property matched, sorted.
	 */
	public List<ActionDef> getActionDefsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty) throws ASActionServiceException {
		throw new RuntimeException("Not yet implemented");
	}

	public XMLNode exportActionDefsToXML(List<ActionDef> listActionDefs){;
		return new XMLNode("unimplemented_federated_export_ASAction");
	}


	public XMLNode exportActionDefsToXML(String[] languages,List<ActionDef> listActionDefs) throws ASActionServiceException {
		return new XMLNode("unimplemented_federated_export_ASAction");
	}

	@Override
	public void fetchActionDef(final String id, Set<String> addedDocuments, JSONArray data)  throws ASActionServiceException  {

		if (id.isEmpty() || addedDocuments.contains("ActionDef" + id))
			return;

		try {
			ActionDef aActionDef = getActionDef(id);
			addedDocuments.add("ActionDef" + id);
			String targetActionDefId = aActionDef.getId();

			if (targetActionDefId.charAt(0) == 'G')
				getASGenericActionService().fetchGenericActionDef(targetActionDefId.substring(2), addedDocuments, data);
			if (targetActionDefId.charAt(0) == 'C')
				getASCustomActionService().fetchCustomActionDef(targetActionDefId.substring(2), addedDocuments, data);

		}catch(ASGenericActionServiceException e){
			throw new ASActionServiceException ("Problem with getting GenericActionDef by id:" + id + "." + e.getMessage());
		}catch(ASCustomActionServiceException e){
			throw new ASActionServiceException ("Problem with getting CustomActionDef by id:" + id + "." + e.getMessage());
		}
	}

	public void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws ASActionServiceException {
		throw new UnsupportedOperationException(" not implemented and should not BE!");
	}
	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service
	 */
	public QueryResult executeQueryOnAllObjects(DocumentQuery query) throws ASActionServiceException {
		QueryResult ret = new QueryResult();
		ret.add(executeQueryOnActionDefs(query).getEntries());
		return ret;
	} //executeQueryOnAllObjects


	public XMLNode exportToXML() throws ASActionServiceException {
		return new XMLNode("unimplemented_federated_export_ASAction");
	}

	public XMLNode exportToXML(String[] languages) throws ASActionServiceException {
		return new XMLNode("unimplemented_federated_export_ASAction");
	}
}
