/**
 ********************************************************************************
 *** PermissionDocument.java                                                  ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessconfiguration.data;

import net.anotheria.asg.data.AbstractASGDocument;
import java.util.List;
import net.anotheria.anodoc.data.StringProperty;
import net.anotheria.util.crypt.MD5Util;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.BasicComparable;

public class PermissionDocument extends AbstractASGDocument implements Permission, IComparable{

	public PermissionDocument() {
		super("");
	}

	public PermissionDocument(String id){
		super(id);
	}

	public PermissionDocument(PermissionDocument toClone){
		super(toClone);
	}

	PermissionDocument(PermissionBuilder builder){
		super("");
		setName(builder.name);
		setPriority(builder.priority);
		setDeny(builder.deny);
		setConstraints(builder.constraints);
		setDescription(builder.description);
		setAccessOperation(builder.accessOperation);
	}

	public String getName(){
		return getString(PROP_NAME);
	}

	public void setName(String value){
		setString(PROP_NAME, value);
	}

	public int getPriority(){
		return getInt(PROP_PRIORITY);
	}

	public void setPriority(int value){
		setInt(PROP_PRIORITY, value);
	}

	public boolean getDeny(){
		return getBoolean(PROP_DENY);
	}

	public void setDeny(boolean value){
		setBoolean(PROP_DENY, value);
	}

	public List<String> getConstraints(){
		return copyToStringList(getList(PROP_CONSTRAINTS));
	}

	public void setConstraints(List<String> value){
		setList(PROP_CONSTRAINTS, copyFromStringList(value));
	}

	public String getDescription(){
		return getString(PROP_DESCRIPTION);
	}

	public void setDescription(String value){
		setString(PROP_DESCRIPTION, value);
	}

	public String getAccessOperation(){
		return getString(LINK_PROP_ACCESS_OPERATION);
	}

	public void setAccessOperation(String value){
		setString(LINK_PROP_ACCESS_OPERATION, value);
	}


	public String toString(){
		String ret = "Permission ";
		ret += "["+getId()+"] ";
		ret += "name: "+getName();
		ret += ", ";
		ret += "priority: "+getPriority();
		ret += ", ";
		ret += "deny: "+getDeny();
		ret += ", ";
		ret += "constraints: "+getConstraints();
		ret += ", ";
		ret += "description: "+getDescription();
		return ret;
	}

	public int getConstraintsSize(){
		return getList(PROP_CONSTRAINTS).size();
	}

	public void addConstraintsElement(String constraint){
		getListPropertyAnyCase(PROP_CONSTRAINTS).add(new StringProperty("" + constraint, constraint));
	} //method

	public void removeConstraintsElement(int index){
		getListProperty(PROP_CONSTRAINTS).remove(index);
	} //method

	public void swapConstraintsElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_CONSTRAINTS).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_CONSTRAINTS).get(index2)).getString();
		((StringProperty)getList(PROP_CONSTRAINTS).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_CONSTRAINTS).get(index2)).setString(tmp1);
	} //method

	public String getConstraintsElement(int index){
		StringProperty p = (StringProperty)getList(PROP_CONSTRAINTS).get(index);
		return p.getString();
	} //method


	public int compareTo(Permission comparable){
		return compareTo(comparable, PermissionSortType.SORT_BY_DEFAULT);
	}

	public int compareTo(IComparable anotherComparable, int method){
		PermissionDocument anotherDoc = (PermissionDocument) anotherComparable;
		switch(method){
			case PermissionSortType.SORT_BY_ID:
				return BasicComparable.compareString(getId(), anotherDoc.getId());
			case PermissionSortType.SORT_BY_NAME:
				return BasicComparable.compareString(getName(), anotherDoc.getName());
			case PermissionSortType.SORT_BY_PRIORITY:
				return BasicComparable.compareInt(getPriority(), anotherDoc.getPriority());
			case PermissionSortType.SORT_BY_DENY:
				return BasicComparable.compareBoolean(getDeny(), anotherDoc.getDeny());
			case PermissionSortType.SORT_BY_DESCRIPTION:
				return BasicComparable.compareString(getDescription(), anotherDoc.getDescription());
			case PermissionSortType.SORT_BY_ACCESSOPERATION:
				return BasicComparable.compareString(getAccessOperation(), anotherDoc.getAccessOperation());
			default:
				throw new RuntimeException("Sort method "+method+" is not supported.");
		}
	}

	public String getDefinedName(){
		return "Permission";
	}

	public String getDefinedParentName(){
		return "AnoAccessConfiguration";
	}

	public String getFootprint(){
		StringBuilder footprint = new StringBuilder();
		footprint.append(getName());
		footprint.append(getPriority());
		footprint.append(getDeny());
		footprint.append(getConstraints());
		footprint.append(getDescription());
		footprint.append(getAccessOperation());
		return MD5Util.getMD5Hash(footprint);
	}

	public boolean equals(Object o){
		return o == this || ((o instanceof PermissionDocument) && ((PermissionDocument)o).getId().equals(getId()));
	}
}
