/**
 ********************************************************************************
 *** AnoAccessApplicationDataServiceImpl.java                                 ***
 *** The implementation of the IAnoAccessApplicationDataService.              ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessapplicationdata.service;

import java.nio.charset.Charset;
import java.util.List;
import java.util.ArrayList;
import java.util.Set;
import net.anotheria.anodoc.data.Module;
import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.sorter.StaticQuickSorter;
import net.anotheria.util.slicer.Segment;
import net.anotheria.util.slicer.Slicer;
import net.anotheria.anosite.gen.anoaccessapplicationdata.data.ModuleAnoAccessApplicationData;
import net.anotheria.anosite.gen.shared.service.BasicCMSService;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryResultEntry;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.util.StringUtils;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.xml.XMLAttribute;
import net.anotheria.asg.util.listener.IModuleListener;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import net.anotheria.anodoc.util.mapper.ObjectMapperUtil;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.anosite.gen.anoaccessapplicationdata.data.UserData;
import net.anotheria.anosite.gen.anoaccessapplicationdata.data.UserDataXMLHelper;
import net.anotheria.anosite.gen.anoaccessapplicationdata.data.UserDataDocument;
import net.anotheria.anosite.gen.anoaccessconfiguration.service.AnoAccessConfigurationServiceException;

public class AnoAccessApplicationDataServiceImpl extends BasicCMSService implements IAnoAccessApplicationDataService, IModuleListener{

	// Generated by: class net.anotheria.asg.generator.model.docs.CMSBasedServiceGenerator.generateImplementation

	private static AnoAccessApplicationDataServiceImpl instance;

	private AnoAccessApplicationDataServiceImpl(){
		addServiceListener(new net.anotheria.anosite.cms.listener.CRUDLogListener());
		addServiceListener(new net.anotheria.anosite.cms.listener.UserAccessGrantListener());
		addServiceListener(new net.anotheria.anosite.cms.listener.AutoTransferAnoAccessApplicationDataListener());
		addModuleListener(ModuleAnoAccessApplicationData.MODULE_ID, this);
	}

	static final AnoAccessApplicationDataServiceImpl getInstance(){
		if (instance==null){
			instance = new AnoAccessApplicationDataServiceImpl();
		}
		return instance;
	}

	private ModuleAnoAccessApplicationData _getModuleAnoAccessApplicationData(){
		return (ModuleAnoAccessApplicationData) getModule(ModuleAnoAccessApplicationData.MODULE_ID);
	}

	@Override
	public void moduleLoaded(Module module){
		firePersistenceChangedEvent();
	}

	@Override
	public List<UserData> getUserDatas(){
		List<UserData> userdatas = new ArrayList<>();
		userdatas.addAll(_getModuleAnoAccessApplicationData().getUserDatas());
		return userdatas;
	}

	@Override
	public List<UserData> getUserDatas(SortType sortType){
		return StaticQuickSorter.sort(getUserDatas(), sortType);
	}

	/**
	 * Returns the UserData objects with the specified ids.
	 */
	public List<UserData> getUserDatas(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<UserData> all = getUserDatas();
		List<UserData> ret = new ArrayList<>();
		for (UserData userdata : all){
			if(ids.contains(userdata.getId())){
				ret.add(userdata);
			}
		}
		return ret;
	}

	/**
	 * Returns the UserData objects with the specified ids, sorted by given sorttype.
	 */
	public List<UserData> getUserDatas(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getUserDatas(ids), sortType);
	}

	@Override
	public void deleteUserData(UserData userdata){
		deleteUserData(userdata.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(userdata);
		}
	}

	@Override
	public void deleteUserData(String id){
		ModuleAnoAccessApplicationData module = _getModuleAnoAccessApplicationData();
		UserData varValue = hasServiceListeners()?module.getUserData(id):null;
		module.deleteUserData(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteUserDatas(List<UserData> list){
		ModuleAnoAccessApplicationData module = _getModuleAnoAccessApplicationData();
		for (UserData userdata : list){
			module.deleteUserData(userdata.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public UserData getUserData(String id){
		return _getModuleAnoAccessApplicationData().getUserData(id);
	}

	@Override
	public UserData importUserData(UserData userdata){
		ModuleAnoAccessApplicationData module = _getModuleAnoAccessApplicationData();
		module.importUserData((UserDataDocument)userdata);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(userdata);
		}
		return userdata;
	}

	@Override
	public List<UserData> importUserDatas(List<UserData> list){
		ModuleAnoAccessApplicationData module = _getModuleAnoAccessApplicationData();
		List<UserData> ret = new ArrayList<>();
		for (UserData userdata : list){
			UserData imported = module.importUserData((UserDataDocument)userdata);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (UserData userdata : ret)
				fireObjectImportedEvent(userdata);
		}
		return ret;
	}

	@Override
	public UserData createUserData(UserData userdata){
		ModuleAnoAccessApplicationData module = _getModuleAnoAccessApplicationData();
		module.createUserData((UserDataDocument)userdata);
		updateModule(module);
		fireObjectCreatedEvent(userdata);
		return userdata;
	}

	@Override
	/**
	 * Creates multiple new UserData objects.
	 * Returns the created versions.
	 */
	public List<UserData> createUserDatas(List<UserData> list){
		ModuleAnoAccessApplicationData module = _getModuleAnoAccessApplicationData();
		List<UserData> ret = new ArrayList<>();
		for (UserData userdata : list){
			UserData created = module.createUserData((UserDataDocument)userdata);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (UserData userdata : ret)
				fireObjectCreatedEvent(userdata);
		}
		return ret;
	}

	@Override
	public UserData updateUserData(UserData userdata){
		UserData oldVersion = null;
		ModuleAnoAccessApplicationData module = _getModuleAnoAccessApplicationData();
		if (hasServiceListeners())
			oldVersion = module.getUserData(userdata.getId());
		module.updateUserData((UserDataDocument)userdata);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, userdata);
		}
		return userdata;
	}

	@Override
	public List<UserData> updateUserDatas(List<UserData> list){
		List<UserData> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleAnoAccessApplicationData module = _getModuleAnoAccessApplicationData();
		for (UserData userdata : list){
			if (oldList!=null)
				oldList.add(module.getUserData(userdata.getId()));
			module.updateUserData((UserDataDocument)userdata);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<UserData> getUserDatasByProperty(String propertyName, Object value){
		List<UserData> allUserDatas = getUserDatas();
		List<UserData> ret = new ArrayList<>();
		for (int i=0; i<allUserDatas.size(); i++){
			UserData userdata = allUserDatas.get(i);
			try{
				Property property = ((UserDataDocument)userdata).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(userdata);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(userdata);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(userdata);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<UserData> getUserDatasByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getUserDatasByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on UserDatas
	 */
	public QueryResult executeQueryOnUserDatas(DocumentQuery query){
		List<UserData> allUserDatas = getUserDatas();
		QueryResult result = new QueryResult();
		for (int i=0; i<allUserDatas.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allUserDatas.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all UserData objects, where property matches.
	 */
	public List<UserData> getUserDatasByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<UserData> ret = new ArrayList<>();
		List<UserData> src = getUserDatas();
		for ( UserData userdata : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(userdata.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(userdata);
		}
		return ret;
	}

	/**
	 * Returns all UserData objects, where property matches, sorted
	 */
	public List<UserData> getUserDatasByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getUserDatasByProperty(property), sortType);
	}

	/**
	 * Returns UserData objects count.
	 */
	public int getUserDatasCount() {
		return _getModuleAnoAccessApplicationData().getUserDatas().size();
	}

	/**
	 * Returns UserData objects segment.
	 */
	public List<UserData> getUserDatas(Segment aSegment) {
		return Slicer.slice(aSegment, getUserDatas()).getSliceData();
	}

	/**
	 * Returns UserData objects segment, where property matched.
	 */
	public List<UserData> getUserDatasByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<UserData> ret = new ArrayList<>();
		List<UserData> src = getUserDatas();
		for (UserData userdata : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(userdata.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(userdata);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns UserData objects segment, where property matched, sorted.
	 */
	public List<UserData> getUserDatasByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getUserDatasByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchUserData(final String id, Set<String> addedDocuments, JSONArray data) throws AnoAccessApplicationDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("UserData" + id))
			return;

		try {
			final UserDataDocument userdata = _getModuleAnoAccessApplicationData().getUserData(id);
			addedDocuments.add("UserData" + id);


			if (!userdata.getRoles().isEmpty()) {
				for (String aRolesId: userdata.getRoles()) {
					getAnoAccessConfigurationService().fetchRole(aRolesId, addedDocuments, data);
				}
			}

			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(userdata);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "AnoAccessApplicationData");
			dataObject.put("document", "AnoAccessApplicationData_UserData");

			data.put(dataObject);

		}catch(AnoAccessConfigurationServiceException e){
			throw new AnoAccessApplicationDataServiceException("Problem with getting document from AnoAccessConfiguration" + e.getMessage());
		}catch(IOException e){
			throw new AnoAccessApplicationDataServiceException ("Problem with fetching data for this UserData instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new AnoAccessApplicationDataServiceException ("Problem with fetching data for this UserData instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredUserData(final JSONObject data) throws AnoAccessApplicationDataServiceException {
		try {
			String objectData = data.getString("object");
			UserData userdata = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), UserDataDocument.class);

			try {
				updateUserData(userdata);
			}catch(Exception e){
				importUserData(userdata);
			}
		}catch(JSONException e){
			throw new AnoAccessApplicationDataServiceException("Problem with getting data from json UserData instance :" + e.getMessage());
		}catch(IOException e){
			throw new AnoAccessApplicationDataServiceException("Problem with parsing data for this UserData instance :" + e.getMessage());
		}
	}

	public void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws AnoAccessApplicationDataServiceException {
		switch(documentName) {
			case DOCUMENT_ANOACCESSAPPLICATIONDATA_USERDATA:
				saveTransferredUserData(data);
				break;
			default:
				log.info("There is no correct document: " + documentName + "in this service");
				throw new AnoAccessApplicationDataServiceException("No such document");
		}
	}

	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service
	 */
	public QueryResult executeQueryOnAllObjects(DocumentQuery query){
		QueryResult ret = new QueryResult();
		ret.add(executeQueryOnUserDatas(query).getEntries());
		return ret;
	} //executeQueryOnAllObjects


	public XMLNode exportUserDatasToXML(){
		XMLNode ret = new XMLNode("UserDatas");
		List<UserData> list = getUserDatas();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (UserData object : list)
			ret.addChildNode(UserDataXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportUserDatasToXML(List<UserData> list){
		XMLNode ret = new XMLNode("UserDatas");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (UserData object : list)
			ret.addChildNode(UserDataXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportToXML(){
		XMLNode ret = new XMLNode("AnoAccessApplicationData");

		ret.addChildNode(exportUserDatasToXML());

		return ret;
	}
}
