/**
 ********************************************************************************
 *** ShowUserDatasAction.java                                                 ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessapplicationdata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.anoaccessapplicationdata.data.UserData;
import net.anotheria.anosite.gen.anoaccessapplicationdata.bean.UserDataListItemBean;
import net.anotheria.asg.data.LockableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.anoaccessapplicationdata.bean.UserDataListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;

public class ShowUserDatasAction extends BaseUserDataAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"UserData";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"UserData";
	private static Logger log = LoggerFactory.getLogger(ShowUserDatasAction.class);
	private Sorter<UserDataListItemBean> sorter;

	private IAttributeDecorator idDecorator;
	private IAttributeDecorator userIdDecorator;

	private DocumentFilter userIdFilterAZ;

	public ShowUserDatasAction(){
		sorter = new QuickSorter<UserDataListItemBean>();
		try{ 
			idDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.IDItoADecorator").newInstance();
			userIdDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate decorator:", e);
		}
		try{ 
			userIdFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		int sortMethod = UserDataListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = UserDataListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		UserDataListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new UserDataListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (UserDataListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new UserDataListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<UserData> _unfiltered_userdatas = getAnoAccessApplicationDataService().getUserDatas();
		List<UserData> userdatas = new ArrayList<UserData>();
		for (int i=0; i<_unfiltered_userdatas.size(); i++){
			boolean mayPass = true;
			mayPass = mayPass && (userIdFilterAZ.mayPass(_unfiltered_userdatas.get(i), "userId", filterParameter0));
			if (mayPass)
				userdatas.add(_unfiltered_userdatas.get(i));
		}
		List<UserDataListItemBean> beans = new ArrayList<UserDataListItemBean>(userdatas.size());
		for (UserData userdata : userdatas){
			checkUserDatas(userdata, req);
			UserDataListItemBean bean = makeUserDataListItemBean(userdata);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "userdatas", beans);
		addBeanToRequest(req, "userIdFilterAZ", userIdFilterAZ.getTriggerer("userId"));
		return mapping.success();
	}

	protected UserDataListItemBean makeUserDataListItemBean(UserData userdata) {
		UserDataListItemBean bean = new UserDataListItemBean();
		bean.setPlainId(userdata.getId());
		bean.setIdForSorting(userdata.getId());
		bean.setId(idDecorator.decorate(userdata, "id", "3"));
		bean.setUserIdForSorting(userdata.getUserId());
		bean.setUserId(userIdDecorator.decorate(userdata, "userId", "null"));
		bean.setRoles(userdata.getRoles());
		bean.setLocked(((LockableObject)userdata).isLocked());
		bean.setLockerId(((LockableObject)userdata).getLockerId());
		bean.setLockingTime(NumberUtils.makeISO8601TimestampString(((LockableObject)userdata).getLockingTime()) + " till: " + NumberUtils.makeISO8601TimestampString(((LockableObject)userdata).getLockingTime() + getLockingTimeout()));
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(userdata.getLastUpdateTimestamp()));
		return bean;
	}
}
