/**
 ********************************************************************************
 *** MultiOpDialogUserDatasAction.java                                        ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessapplicationdata.action;

import net.anotheria.util.NumberUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.anoaccessapplicationdata.data.UserDataFactory;
import net.anotheria.anosite.gen.anoaccessapplicationdata.data.UserData;
import net.anotheria.anosite.gen.anoaccessapplicationdata.bean.EditUserDataFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;

public class MultiOpDialogUserDatasAction extends BaseUserDataAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("anoaccessapplicationdataUserDataDelete"))
			return anoaccessapplicationdataUserDataDelete(mapping, req, res);
		if (path.equals("anoaccessapplicationdataUserDataDuplicate"))
			return anoaccessapplicationdataUserDataDuplicate(mapping, req, res);
		if (path.equals("anoaccessapplicationdataUserDataUpdate"))
			return anoaccessapplicationdataUserDataUpdate(mapping, req, res);
		if (path.equals("anoaccessapplicationdataUserDataClose"))
			return anoaccessapplicationdataUserDataClose(mapping, req, res);
		if (path.equals("anoaccessapplicationdataUserDataLock"))
			return anoaccessapplicationdataUserDataLock(mapping, req, res);
		if (path.equals("anoaccessapplicationdataUserDataUnLock"))
			return anoaccessapplicationdataUserDataUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand anoaccessapplicationdataUserDataDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			UserData userdataCurr = getAnoAccessApplicationDataService().getUserData(id);
			if (userdataCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)userdataCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getAnoAccessApplicationDataService().deleteUserData(id);
		}
		res.sendRedirect("anoaccessapplicationdataUserDataShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand anoaccessapplicationdataUserDataDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		UserData userdataSrc = getAnoAccessApplicationDataService().getUserData(id);
		UserData userdataDest = UserDataFactory.createUserData(userdataSrc);



		UserData userdataCreated = getAnoAccessApplicationDataService().createUserData(userdataDest);
		res.sendRedirect("anoaccessapplicationdataUserDataEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+userdataCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand anoaccessapplicationdataUserDataUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditUserDataFB form = new EditUserDataFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		UserData userdata = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		userdata = (UserData)getAnoAccessApplicationDataService().getUserData(form.getId()).clone();
	}else{
		userdata = UserDataFactory.createUserData();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	userdata.setUserId(form.getUserId());
	// skipped container roles

	UserData updatedCopy = null;
	if (create){
		updatedCopy = getAnoAccessApplicationDataService().createUserData(userdata);
	}else{
		canUpdateUserDatas(userdata, req);
		checkUserDatas(userdata, req);
		updatedCopy = getAnoAccessApplicationDataService().updateUserData(userdata);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("anoaccessapplicationdataUserDataEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(userdata, req);
		res.sendRedirect("anoaccessapplicationdataUserDataShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(UserData userdata, HttpServletRequest req) throws Exception{
	if(((LockableObject)userdata).isLocked())
		unLockUserDatas(userdata, req, false);
}

public ActionCommand anoaccessapplicationdataUserDataLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	UserData userdataCurr = id != null && !id.equals("") ? getAnoAccessApplicationDataService().getUserData(id) : null;
	if(userdataCurr != null && userdataCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)userdataCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockUserDatas(userdataCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, userdataCurr));
	return null;
}

public ActionCommand anoaccessapplicationdataUserDataUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	UserData userdataCurr = id != null && !id.equals("") ? getAnoAccessApplicationDataService().getUserData(id) : null;
	if(userdataCurr != null && userdataCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)userdataCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockUserDatas(userdataCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, userdataCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, UserData item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "anoaccessapplicationdataUserDataShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "anoaccessapplicationdataUserDataEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "anoaccessapplicationdataUserDataShow?ts="+System.currentTimeMillis();
}

public ActionCommand anoaccessapplicationdataUserDataClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	UserData userdataCurr = id != null && !id.equals("") ? getAnoAccessApplicationDataService().getUserData(id) : null;
	if(userdataCurr != null && userdataCurr instanceof LockableObject && ((LockableObject)userdataCurr).isLocked()) 
		unLockUserDatas(userdataCurr, req, false);
	res.sendRedirect("anoaccessapplicationdataUserDataShow?ts="+System.currentTimeMillis());
	return null;
}

}
