/**
 ********************************************************************************
 *** UploadImageResource.java                                                 ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.shared.rest;

import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.webutils.filehandling.FileStorageConfig;
import net.anotheria.util.log.LogMessageUtil;

@Path("/asgimage")
public class UploadImageResource{

	// Generated by: class net.anotheria.asg.generator.apputil.BasicServiceUtilGenerator.generateUploadImageResource

	private static final Logger LOGGER = LoggerFactory.getLogger(UploadImageResource.class);

	private static final FileStorageConfig CONFIG = FileStorageConfig.getInstance();

	@Context
	private UriInfo context;

	public UploadImageResource(){}

	@POST
	@Path("/upload")
	@Consumes(MediaType.MULTIPART_FORM_DATA)
	@Produces(MediaType.APPLICATION_JSON)
	public Response uploadFile( @FormDataParam("file") InputStream uploadedInputStream, @FormDataParam("file") FormDataContentDisposition fileDetail) {
		if (uploadedInputStream == null || fileDetail == null)
			return Response.status(400).entity("Invalid form data").build();

		String uploadedFileLocation = CONFIG.getDirectory() + File.separator + fileDetail.getFileName();
		try {
			writeToFile(uploadedInputStream, uploadedFileLocation);
		}catch(IOException e){
			String failMsg = LogMessageUtil.failMsg(e);
			LOGGER.error(failMsg);
			return Response.status(500).entity(failMsg).build();
		}
		return Response.status(201).build();
	}

	private void writeToFile(InputStream uploadedInputStream, String uploadedFileLocation) throws IOException {
		OutputStream out = new FileOutputStream(uploadedFileLocation);
		int read = 0;
		byte[] bytes = new byte[4096];;
		while ((read = uploadedInputStream.read(bytes)) != -1) {
			out.write(bytes, 0, read);
		}
		out.flush();
		out.close();
	}
}
