/**
 ********************************************************************************
 *** BaseAdminapiAction.java                                                  ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.shared.action;

import net.anotheria.anoplass.api.APIFinder;
import net.anotheria.anosite.api.configuration.SystemConfigurationAPI;
import net.anotheria.util.StringUtils;
import net.anotheria.anodoc.util.context.ContextManager;
import net.anotheria.webutils.actions.*;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.webutils.bean.NavigationItemBean;
import net.anotheria.util.sorter.SortType;
import net.anotheria.anosite.cms.user.CMSUserManager;
import net.anotheria.asg.util.locking.config.LockingConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.Extension;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anosite.gen.asgenericaction.service.IASGenericActionService;
import net.anotheria.anosite.gen.asuserdata.service.IASUserDataService;
import net.anotheria.anosite.gen.assitedata.service.IASSiteDataService;
import net.anotheria.anosite.gen.asgenericdata.service.IASGenericDataService;
import net.anotheria.anosite.gen.images.service.IImagesService;
import net.anotheria.anosite.gen.ascustomdata.service.IASCustomDataService;
import net.anotheria.anosite.gen.asresourcedata.service.IASResourceDataService;
import net.anotheria.anosite.gen.anoaccessapplicationdata.service.IAnoAccessApplicationDataService;
import net.anotheria.anosite.gen.asfederateddata.service.IASFederatedDataService;
import net.anotheria.anosite.gen.aslayoutdata.service.IASLayoutDataService;
import net.anotheria.anosite.gen.asaction.service.IASActionService;
import net.anotheria.anosite.gen.aswebdata.service.IASWebDataService;
import net.anotheria.anosite.gen.asexperiment.service.IASExperimentService;
import net.anotheria.anosite.gen.ascustomaction.service.IASCustomActionService;
import net.anotheria.anosite.gen.asfeature.service.IASFeatureService;
import net.anotheria.anosite.gen.anoaccessconfiguration.service.IAnoAccessConfigurationService;
import net.anotheria.anosite.gen.aswizarddata.service.IASWizardDataService;
import net.anotheria.anosite.gen.asbrand.service.IASBrandService;
import net.anotheria.anosite.gen.assiteconfig.service.IASSiteConfigService;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.shared.service.AdminapiLanguageUtils;
import java.util.Collection;
import net.anotheria.asg.data.AbstractASGDocument;
import java.io.Serializable;

public abstract class BaseAdminapiAction extends BaseAction{

// net.anotheria.asg.generator.view.action.BaseActionGenerator
	// Generated by: class net.anotheria.asg.generator.view.action.BaseActionGenerator.generateBaseAction

	public static final String BEAN_MAIN_NAVIGATION = "mainNavigation";
	public static final String BEAN_CURRENT_SYSTEM = "currentSystem";
	public static final String BEAN_CURRENT_APPLICATION = "currentApplication";
	public static final String BEAN_SEARCH_SCOPE = "searchScope";
	public static final String BEAN_DOCUMENT_DEF_NAME = "documentName";
	public static final String BEAN_MODULE_DEF_NAME = "moduleName";
	public static final String FLAG_DISABLED_SEARCH = "disabledSearchFlag";
	public static final String PARAM_SORT_TYPE = "pSortType";
	public static final String PARAM_SORT_TYPE_NAME = "pSortName";
	public static final String PARAM_SORT_ORDER = "pSortOrder";

	// prefixes for session attributes.
	public static final String SA_PREFIX = "asg.sa.";
	public static final String SA_SORT_TYPE_PREFIX = SA_PREFIX+"sorttype.";
	public static final String SA_FILTER_PREFIX = SA_PREFIX+"filter.";

	public static final String BEAN_VIEW_SELECTOR = "views";

	public static final String BEAN_USER_DEF_ID = "currentUserDefId";

	private static Object serviceInstantiationLock = new Object();
	private static volatile IASGenericActionService asgenericactionService;
	private static volatile IASUserDataService asuserdataService;
	private static volatile IASSiteDataService assitedataService;
	private static volatile IASGenericDataService asgenericdataService;
	private static volatile IImagesService imagesService;
	private static volatile IASCustomDataService ascustomdataService;
	private static volatile IASResourceDataService asresourcedataService;
	private static volatile IAnoAccessApplicationDataService anoaccessapplicationdataService;
	private static volatile IASFederatedDataService asfederateddataService;
	private static volatile IASLayoutDataService aslayoutdataService;
	private static volatile IASActionService asactionService;
	private static volatile IASWebDataService aswebdataService;
	private static volatile IASExperimentService asexperimentService;
	private static volatile IASCustomActionService ascustomactionService;
	private static volatile IASFeatureService asfeatureService;
	private static volatile IAnoAccessConfigurationService anoaccessconfigurationService;
	private static volatile IASWizardDataService aswizarddataService;
	private static volatile IASBrandService asbrandService;
	private static volatile IASSiteConfigService assiteconfigService;
	private static SystemConfigurationAPI systemConfigurationAPI = APIFinder.findAPI(SystemConfigurationAPI.class);
	private static CMSUserManager userManager;
	private static LockingConfig lockConfig;;
	private static Logger log = LoggerFactory.getLogger(BaseAdminapiAction.class);
	static{

		/**
		 * //initializing user manager
		 */
		try{
			userManager = CMSUserManager.getInstance();
		}catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Can't init user manager", e);
		}

		/**
		 * initializing lockConfig
		 */
		try{
			lockConfig = LockingConfig.getInstance();
		}catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Can't init lockConfig", e);
		}
	} //

	public void preProcess(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception {
		super.preProcess(mapping, req, res);

		String userId = (String)getBeanFromSession(req, BEAN_USER_DEF_ID);
		if (userId != null) {
			String login = CMSUserManager.getLoginById(userId);
			addBeanToSession(req, BEAN_USER_ID, login);
		} //if

		prepareMenu(req);
		addBeanToSession(req, BEAN_CURRENT_SYSTEM, systemConfigurationAPI.getCurrentSystemExpanded());
		addBeanToSession(req, BEAN_CURRENT_APPLICATION, systemConfigurationAPI.getCurrentApplication());
	} //preProcess

	public abstract ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception;

	// Generated by: class net.anotheria.asg.generator.view.action.BaseActionGenerator.generateBaseAction

	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception {
		if (isAuthorizationRequired()){
			boolean authorized = checkAuthorization(req);
			if (!authorized){
				String url = req.getRequestURI();
				String qs = req.getQueryString();
				if (!StringUtils.isEmpty(qs))
					url += "?"+qs;;
				addBeanToSession(req, BEAN_TARGET_ACTION, url);
				String redUrl = "/cms/login";
				res.sendRedirect(redUrl);
				return null;
			} //if
		} //if

		checkAccessPermissions(req);

		addBeanToRequest(req, BEAN_DOCUMENT_DEF_NAME, getCurrentDocumentDefName());
		addBeanToRequest(req, BEAN_MODULE_DEF_NAME, getActiveMainNavi());

		return anoDocExecute(mapping, req, res);
	} //execute

	protected IASGenericActionService getASGenericActionService(){
		if (asgenericactionService==null){
			synchronized(serviceInstantiationLock){
				if (asgenericactionService==null){
					try{
						asgenericactionService = MetaFactory.get(IASGenericActionService.class, Extension.EDITORINTERFACE);
					}catch(MetaFactoryException e){
						log.error(MarkerFactory.getMarker("FATAL"), "Can't load editor instance of module service ASGenericAction", e);
					}
				} //... if null
			} //... synch
		} //... if
		return asgenericactionService;
	} //end  getASGenericActionService()

	protected IASUserDataService getASUserDataService(){
		if (asuserdataService==null){
			synchronized(serviceInstantiationLock){
				if (asuserdataService==null){
					try{
						asuserdataService = MetaFactory.get(IASUserDataService.class, Extension.EDITORINTERFACE);
					}catch(MetaFactoryException e){
						log.error(MarkerFactory.getMarker("FATAL"), "Can't load editor instance of module service ASUserData", e);
					}
				} //... if null
			} //... synch
		} //... if
		return asuserdataService;
	} //end  getASUserDataService()

	protected IASSiteDataService getASSiteDataService(){
		if (assitedataService==null){
			synchronized(serviceInstantiationLock){
				if (assitedataService==null){
					try{
						assitedataService = MetaFactory.get(IASSiteDataService.class, Extension.EDITORINTERFACE);
					}catch(MetaFactoryException e){
						log.error(MarkerFactory.getMarker("FATAL"), "Can't load editor instance of module service ASSiteData", e);
					}
				} //... if null
			} //... synch
		} //... if
		return assitedataService;
	} //end  getASSiteDataService()

	protected IASGenericDataService getASGenericDataService(){
		if (asgenericdataService==null){
			synchronized(serviceInstantiationLock){
				if (asgenericdataService==null){
					try{
						asgenericdataService = MetaFactory.get(IASGenericDataService.class, Extension.EDITORINTERFACE);
					}catch(MetaFactoryException e){
						log.error(MarkerFactory.getMarker("FATAL"), "Can't load editor instance of module service ASGenericData", e);
					}
				} //... if null
			} //... synch
		} //... if
		return asgenericdataService;
	} //end  getASGenericDataService()

	protected IImagesService getImagesService(){
		if (imagesService==null){
			synchronized(serviceInstantiationLock){
				if (imagesService==null){
					try{
						imagesService = MetaFactory.get(IImagesService.class, Extension.EDITORINTERFACE);
					}catch(MetaFactoryException e){
						log.error(MarkerFactory.getMarker("FATAL"), "Can't load editor instance of module service Images", e);
					}
				} //... if null
			} //... synch
		} //... if
		return imagesService;
	} //end  getImagesService()

	protected IASCustomDataService getASCustomDataService(){
		if (ascustomdataService==null){
			synchronized(serviceInstantiationLock){
				if (ascustomdataService==null){
					try{
						ascustomdataService = MetaFactory.get(IASCustomDataService.class, Extension.EDITORINTERFACE);
					}catch(MetaFactoryException e){
						log.error(MarkerFactory.getMarker("FATAL"), "Can't load editor instance of module service ASCustomData", e);
					}
				} //... if null
			} //... synch
		} //... if
		return ascustomdataService;
	} //end  getASCustomDataService()

	protected IASResourceDataService getASResourceDataService(){
		if (asresourcedataService==null){
			synchronized(serviceInstantiationLock){
				if (asresourcedataService==null){
					try{
						asresourcedataService = MetaFactory.get(IASResourceDataService.class, Extension.EDITORINTERFACE);
					}catch(MetaFactoryException e){
						log.error(MarkerFactory.getMarker("FATAL"), "Can't load editor instance of module service ASResourceData", e);
					}
				} //... if null
			} //... synch
		} //... if
		return asresourcedataService;
	} //end  getASResourceDataService()

	protected IAnoAccessApplicationDataService getAnoAccessApplicationDataService(){
		if (anoaccessapplicationdataService==null){
			synchronized(serviceInstantiationLock){
				if (anoaccessapplicationdataService==null){
					try{
						anoaccessapplicationdataService = MetaFactory.get(IAnoAccessApplicationDataService.class, Extension.EDITORINTERFACE);
					}catch(MetaFactoryException e){
						log.error(MarkerFactory.getMarker("FATAL"), "Can't load editor instance of module service AnoAccessApplicationData", e);
					}
				} //... if null
			} //... synch
		} //... if
		return anoaccessapplicationdataService;
	} //end  getAnoAccessApplicationDataService()

	protected IASFederatedDataService getASFederatedDataService(){
		if (asfederateddataService==null){
			synchronized(serviceInstantiationLock){
				if (asfederateddataService==null){
					try{
						asfederateddataService = MetaFactory.get(IASFederatedDataService.class, Extension.EDITORINTERFACE);
					}catch(MetaFactoryException e){
						log.error(MarkerFactory.getMarker("FATAL"), "Can't load editor instance of module service ASFederatedData", e);
					}
				} //... if null
			} //... synch
		} //... if
		return asfederateddataService;
	} //end  getASFederatedDataService()

	protected IASLayoutDataService getASLayoutDataService(){
		if (aslayoutdataService==null){
			synchronized(serviceInstantiationLock){
				if (aslayoutdataService==null){
					try{
						aslayoutdataService = MetaFactory.get(IASLayoutDataService.class, Extension.EDITORINTERFACE);
					}catch(MetaFactoryException e){
						log.error(MarkerFactory.getMarker("FATAL"), "Can't load editor instance of module service ASLayoutData", e);
					}
				} //... if null
			} //... synch
		} //... if
		return aslayoutdataService;
	} //end  getASLayoutDataService()

	protected IASActionService getASActionService(){
		if (asactionService==null){
			synchronized(serviceInstantiationLock){
				if (asactionService==null){
					try{
						asactionService = MetaFactory.get(IASActionService.class, Extension.EDITORINTERFACE);
					}catch(MetaFactoryException e){
						log.error(MarkerFactory.getMarker("FATAL"), "Can't load editor instance of module service ASAction", e);
					}
				} //... if null
			} //... synch
		} //... if
		return asactionService;
	} //end  getASActionService()

	protected IASWebDataService getASWebDataService(){
		if (aswebdataService==null){
			synchronized(serviceInstantiationLock){
				if (aswebdataService==null){
					try{
						aswebdataService = MetaFactory.get(IASWebDataService.class, Extension.EDITORINTERFACE);
					}catch(MetaFactoryException e){
						log.error(MarkerFactory.getMarker("FATAL"), "Can't load editor instance of module service ASWebData", e);
					}
				} //... if null
			} //... synch
		} //... if
		return aswebdataService;
	} //end  getASWebDataService()

	protected IASExperimentService getASExperimentService(){
		if (asexperimentService==null){
			synchronized(serviceInstantiationLock){
				if (asexperimentService==null){
					try{
						asexperimentService = MetaFactory.get(IASExperimentService.class, Extension.EDITORINTERFACE);
					}catch(MetaFactoryException e){
						log.error(MarkerFactory.getMarker("FATAL"), "Can't load editor instance of module service ASExperiment", e);
					}
				} //... if null
			} //... synch
		} //... if
		return asexperimentService;
	} //end  getASExperimentService()

	protected IASCustomActionService getASCustomActionService(){
		if (ascustomactionService==null){
			synchronized(serviceInstantiationLock){
				if (ascustomactionService==null){
					try{
						ascustomactionService = MetaFactory.get(IASCustomActionService.class, Extension.EDITORINTERFACE);
					}catch(MetaFactoryException e){
						log.error(MarkerFactory.getMarker("FATAL"), "Can't load editor instance of module service ASCustomAction", e);
					}
				} //... if null
			} //... synch
		} //... if
		return ascustomactionService;
	} //end  getASCustomActionService()

	protected IASFeatureService getASFeatureService(){
		if (asfeatureService==null){
			synchronized(serviceInstantiationLock){
				if (asfeatureService==null){
					try{
						asfeatureService = MetaFactory.get(IASFeatureService.class, Extension.EDITORINTERFACE);
					}catch(MetaFactoryException e){
						log.error(MarkerFactory.getMarker("FATAL"), "Can't load editor instance of module service ASFeature", e);
					}
				} //... if null
			} //... synch
		} //... if
		return asfeatureService;
	} //end  getASFeatureService()

	protected IAnoAccessConfigurationService getAnoAccessConfigurationService(){
		if (anoaccessconfigurationService==null){
			synchronized(serviceInstantiationLock){
				if (anoaccessconfigurationService==null){
					try{
						anoaccessconfigurationService = MetaFactory.get(IAnoAccessConfigurationService.class, Extension.EDITORINTERFACE);
					}catch(MetaFactoryException e){
						log.error(MarkerFactory.getMarker("FATAL"), "Can't load editor instance of module service AnoAccessConfiguration", e);
					}
				} //... if null
			} //... synch
		} //... if
		return anoaccessconfigurationService;
	} //end  getAnoAccessConfigurationService()

	protected IASWizardDataService getASWizardDataService(){
		if (aswizarddataService==null){
			synchronized(serviceInstantiationLock){
				if (aswizarddataService==null){
					try{
						aswizarddataService = MetaFactory.get(IASWizardDataService.class, Extension.EDITORINTERFACE);
					}catch(MetaFactoryException e){
						log.error(MarkerFactory.getMarker("FATAL"), "Can't load editor instance of module service ASWizardData", e);
					}
				} //... if null
			} //... synch
		} //... if
		return aswizarddataService;
	} //end  getASWizardDataService()

	protected IASBrandService getASBrandService(){
		if (asbrandService==null){
			synchronized(serviceInstantiationLock){
				if (asbrandService==null){
					try{
						asbrandService = MetaFactory.get(IASBrandService.class, Extension.EDITORINTERFACE);
					}catch(MetaFactoryException e){
						log.error(MarkerFactory.getMarker("FATAL"), "Can't load editor instance of module service ASBrand", e);
					}
				} //... if null
			} //... synch
		} //... if
		return asbrandService;
	} //end  getASBrandService()

	protected IASSiteConfigService getASSiteConfigService(){
		if (assiteconfigService==null){
			synchronized(serviceInstantiationLock){
				if (assiteconfigService==null){
					try{
						assiteconfigService = MetaFactory.get(IASSiteConfigService.class, Extension.EDITORINTERFACE);
					}catch(MetaFactoryException e){
						log.error(MarkerFactory.getMarker("FATAL"), "Can't load editor instance of module service ASSiteConfig", e);
					}
				} //... if null
			} //... synch
		} //... if
		return assiteconfigService;
	} //end  getASSiteConfigService()

	protected boolean isAuthorizationRequired(){
		return false;
	}

	private static final List<String> EMPTY_ROLE_LIST = new ArrayList<String>();
	protected List<String> getRequiredRoles(){
		return EMPTY_ROLE_LIST;
	}

	protected boolean checkAuthorization(HttpServletRequest req){
		String userId = (String )getBeanFromSession(req, BEAN_USER_ID);
		if(userId == null)
			return false;
		ContextManager.getCallContext().setCurrentAuthor(userId);
		return true;
	} //checkAuthorization

	public String getSubsystem() {
		return "asg";
	}

	protected String stripPath(String path){
		if (path==null || path.length()==0)
			throw new IllegalArgumentException("path null or empty");
		return path.startsWith("/") ? path.substring(1) : path;
	}

	protected boolean getSortOder(HttpServletRequest req){
		try{
			return getStringParameter(req, PARAM_SORT_ORDER).equals("ASC") ? SortType.ASC : SortType.DESC;
		}catch(Exception e){
			return SortType.ASC;
		}
	}

	protected long getLockingTimeout(){
		return lockConfig.getTimeout();
	}

	protected boolean isAutoLockingEnabled(){
		return lockConfig.isAutolocking();
	}

	private void checkAccessPermissions(HttpServletRequest req){
		List<String> requiredRoles = getRequiredRoles();
		if (requiredRoles==null || requiredRoles.size()==0)
			return;
		String userId = getUserId(req);
		if (userId==null || userId.length()==0)
			throw new RuntimeException("Permission denied, uid not found!");
		for (String role : requiredRoles){
			if (userManager.userInRole(userId, role))
				return;
		}
		throw new RuntimeException("Permission denied, expected one of those: "+requiredRoles);
	}

	protected boolean isUserInRole(HttpServletRequest req, String ... roles){
		String userId = getUserId(req);
		if (userId==null)
			return false;
		for (String role : roles){
			if (userManager.userInRole(userId, role))
				return true;
		}
		return false;
	}
	protected void prepareMenu(HttpServletRequest req) {
		List<NavigationItemBean> navigation = getMainNavigation(req);
		for (NavigationItemBean naviItem : navigation)
		if (naviItem.isActive())
		naviItem.setSubNavi(getSubNavigation());
		addBeanToRequest(req, BEAN_MAIN_NAVIGATION, navigation);
	}

	protected abstract List<NavigationItemBean> getSubNavigation();

	protected List<NavigationItemBean> getMainNavigation(HttpServletRequest req) {
		List<NavigationItemBean> menu = new ArrayList<NavigationItemBean>();
		if (isUserInRole(req, new String[]{"admin", "developer", "editor"})){
			menu.add(makeMenuItemBean("Content", "aswebdataPagexShow"));
		}
		if (isUserInRole(req, new String[]{"admin", "developer", "producer"})){
			menu.add(makeMenuItemBean("Site", "assitedataSiteShow"));
		}
		if (isUserInRole(req, new String[]{"developer"})){
			menu.add(makeMenuItemBean("Site Config", "assiteconfigFilteredIPShow"));
		}
		if (isUserInRole(req, new String[]{"admin", "developer", "producer"})){
			menu.add(makeMenuItemBean("Layout", "aslayoutdataPageStyleShow"));
		}
		if (isUserInRole(req, new String[]{"admin", "developer"})){
			menu.add(makeMenuItemBean("Definitions", "asgenericdataGenericBoxTypeShow"));
		}
		if (isUserInRole(req, new String[]{"admin", "developer", "editor", "producer"})){
			menu.add(makeMenuItemBean("Resources", "asresourcedataTextResourceShow"));
		}
		if (isUserInRole(req, new String[]{"admin", "developer"})){
			menu.add(makeMenuItemBean("Actions", "ascustomactionActionMappingDefShow"));
		}
		if (isUserInRole(req, new String[]{"admin", "developer", "editor"})){
			menu.add(makeMenuItemBean("Wizard", "aswizarddataWizardDefShow"));
		}
		if (isUserInRole(req, new String[]{"admin"})){
			menu.add(makeMenuItemBean("UserManagement", "asuserdataUserDefShow"));
		}
		if (isUserInRole(req, new String[]{"admin", "developer", "editor"})){
			menu.add(makeMenuItemBean("Ano-Access Configuration", "anoaccessconfigurationAccessOperationShow"));
		}
		if (isUserInRole(req, new String[]{"admin", "developer", "editor"})){
			menu.add(makeMenuItemBean("Ano-Access Data", "anoaccessapplicationdataUserDataShow"));
		}
		if (isUserInRole(req, new String[]{"admin", "developer", "editor"})){
			menu.add(makeMenuItemBean("Features", "asfeatureFeatureShow"));
		}
		if (isUserInRole(req, new String[]{"admin", "developer", "editor"})){
			menu.add(makeMenuItemBean("Brands", "asbrandBrandShow"));
		}
		if (isUserInRole(req, new String[]{"admin", "developer", "editor"})){
			menu.add(makeMenuItemBean("Tools", "asgLocalizationBundleExportView"));
		}
		return menu;
	}

	protected abstract String getActiveMainNavi();

	protected abstract String getCurrentModuleDefName();
	protected abstract String getCurrentDocumentDefName();

	/**
	 * Get current application supported languages wrapper method.
	 */
	public static List<String> getSupportedLanguages() {
		return AdminapiLanguageUtils.getSupportedLanguages();
	}

	private NavigationItemBean makeMenuItemBean(String title, String link){
		NavigationItemBean bean = new NavigationItemBean();
		bean.setCaption(title);
		bean.setLink(link);
		bean.setActive(title.equals(getActiveMainNavi()));
		return bean;
	}



	/**
	 * Actually Session Attribute name for holding collection of locked objects....
	 */
	private static final String LOCKED_OBJECTS_COLLECTION_SESSION_ATTRIBUTE_NAME = "lokedDocumentsCollection";


	/**
	 * Adding attribute to the session list as LockedDocumentAttribute. for Locking and Unlocking functionality
	 */
	protected void addLockedAttribute(HttpServletRequest req, AbstractASGDocument doc) {
		List<LockedDocumentAttribute> attributes = getLockedAttributesList(req);
		LockedDocumentAttribute docAtt = new LockedDocumentAttribute(doc);
		if (!attributes.contains(docAtt)) {
			attributes.add(docAtt);
			refreshSessionLockedAtribute(req, attributes);
		}
	}

	/**
	 * Putting attribute to the HttpSession.
	 */
	private void refreshSessionLockedAtribute(HttpServletRequest req, List<LockedDocumentAttribute> attributes) {
		req.getSession().setAttribute(LOCKED_OBJECTS_COLLECTION_SESSION_ATTRIBUTE_NAME, attributes);
	}

	/**
	 * Removing attributes List from session.
	 */
	protected void removeLockedAttribute(HttpServletRequest req, AbstractASGDocument doc) {
		List<LockedDocumentAttribute> attributes = getLockedAttributesList(req);
		LockedDocumentAttribute docAtt = new LockedDocumentAttribute(doc);
		if (attributes.contains(docAtt)) {
			attributes.remove(docAtt);
			refreshSessionLockedAtribute(req, attributes);
		}
	}

	/**
	 * Return true if current document represented as  <a>LockedDocumentAttribute</a>. in session attributes list.
	 */
	protected boolean containsLockedAttribute(HttpServletRequest req, AbstractASGDocument doc) {
		List<LockedDocumentAttribute> attributes = getLockedAttributesList(req);
		LockedDocumentAttribute docAtt = new LockedDocumentAttribute(doc);
		return attributes.contains(docAtt);
	}

	/**
	 * Getting attributes List<LockedDocumentAttribute> - from session.
	 */
	@SuppressWarnings("unchecked")
	private List<LockedDocumentAttribute> getLockedAttributesList(HttpServletRequest req) {
		List<LockedDocumentAttribute> attributes = null;
		Object sessionBean = req.getSession().getAttribute(LOCKED_OBJECTS_COLLECTION_SESSION_ATTRIBUTE_NAME);
		if (sessionBean != null && sessionBean instanceof Collection<?>){ 
			attributes = (List<LockedDocumentAttribute>) sessionBean;
		}
		return attributes == null ? new ArrayList<LockedDocumentAttribute>() : attributes;
	}


	/**
	 * Actually simplest been - which should hold information  about document ID and Clazz.
	 */
	public static class LockedDocumentAttribute implements Serializable{

		/**
		 * SerialVersionUID UID.
		 */
		private static final long serialVersionUID = 1L;
		/**
		 * LockedDocumentAttribute "docId".
		 */
		private String docId;

		/**
		 * LockedDocumentAttribute "documentClazz".
		 */
		private Class<? extends AbstractASGDocument> documentClazz;

		/**
		 * Public constructor.
		 */
		public LockedDocumentAttribute(AbstractASGDocument doc) {
			this.docId = doc.getId();
			this.documentClazz = doc.getClass();
		}

		public String getDocId() {
			return docId;
		}

		public Class<? extends AbstractASGDocument> getDocumentClazz() {
			return documentClazz;
		}

		public void setDocId(String aDocId) {
			this.docId = aDocId;
		}

		public void setDocumentClazz(Class<? extends AbstractASGDocument> aDocumentClazz) {
			this.documentClazz = aDocumentClazz;
		}

		public boolean equals(Object o) {
			return o!=null && (this == o || o instanceof LockedDocumentAttribute && ((LockedDocumentAttribute) o).getDocId().equals(getDocId()) && 
 				 ((LockedDocumentAttribute) o).getDocumentClazz().equals(getDocumentClazz()));
		}

		public int hashCode() {
			int result = docId != null ? docId.hashCode() : 0;
			final int mult = 31;
			result = mult * result + (documentClazz != null ? documentClazz.hashCode() : 0);
			return result;
		}

		public String toString() {
			final StringBuilder sb = new StringBuilder();
			sb.append("LockedDocumentAttribute");
			sb.append("{docId='").append(docId).append('\'');
			sb.append(", documentClazz=").append(documentClazz);
			sb.append('}');
			return sb.toString();
		}


	}
}
