/**
 ********************************************************************************
 *** ModuleImages.java                                                        ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.images.data;

import net.anotheria.anodoc.data.Module;
import net.anotheria.anodoc.data.DocumentList;
import net.anotheria.anodoc.data.IDHolder;
import net.anotheria.anodoc.data.NoSuchDocumentListException;
import java.util.List;

public class ModuleImages extends Module{


	public static final String MODULE_ID = "images";

	public static final String LIST_IMAGE = "list_image";
	public static final String ID_HOLDER_IMAGE = IDHolder.DOC_ID_HOLDER_PRE+"image";

	public ModuleImages(){
		super(MODULE_ID);
	}

	@SuppressWarnings("unchecked")
	private DocumentList<ImageDocument> _getImages(){
		try{
			return getList(LIST_IMAGE);
		}catch(NoSuchDocumentListException e){
			return new DocumentList<ImageDocument>(LIST_IMAGE);
		}
	}

	private void _updateImages(DocumentList<ImageDocument> list){
		putList(list);
	}

	public List<ImageDocument> getImages(){
		return _getImages().getList();
	}

	public ImageDocument getImage(String id){
		return _getImages().getDocumentById(id);
	}

	public void updateImage(ImageDocument image){
		DocumentList<ImageDocument> images = _getImages();
		images.removeDocumentById(image.getId());
		image.setLastUpdateNow();
		image.setCallContextAuthor();
		images.addDocument(image);
		_updateImages(images);
	}

	public void deleteImage(String id){
		DocumentList<ImageDocument> entries = _getImages();
		entries.removeDocumentById(id);
		_updateImages(entries);
	}

	public ImageDocument createImage(ImageDocument image ){
		IDHolder idh = _getIdHolder(ID_HOLDER_IMAGE);
		int id = idh.getNextIdInt();
		image.renameTo(""+id);
		putDocument(idh);

		DocumentList<ImageDocument> entries = _getImages();
		image.setLastUpdateNow();
		image.setCallContextAuthor();
		entries.addDocument(image);
		_updateImages(entries);
		return image;
	}

	public ImageDocument importImage(ImageDocument image ){
		IDHolder idh = _getIdHolder(ID_HOLDER_IMAGE);
		idh.adjustTill(image.getId());
		putDocument(idh);

		DocumentList<ImageDocument> entries = _getImages();
		image.setLastUpdateNow();
		image.setCallContextAuthor();
		entries.addDocument(image);
		_updateImages(entries);
		return image;
	}


}
