/**
 ********************************************************************************
 *** MultiOpDialogWizardDefsAction.java                                       ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswizarddata.action;

import net.anotheria.util.NumberUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.aswizarddata.data.WizardDefFactory;
import net.anotheria.anosite.gen.aswizarddata.data.WizardDef;
import net.anotheria.anosite.gen.aswizarddata.bean.EditWizardDefFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;

public class MultiOpDialogWizardDefsAction extends BaseWizardDefAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("aswizarddataWizardDefDelete"))
			return aswizarddataWizardDefDelete(mapping, req, res);
		if (path.equals("aswizarddataWizardDefDuplicate"))
			return aswizarddataWizardDefDuplicate(mapping, req, res);
		if (path.equals("aswizarddataWizardDefUpdate"))
			return aswizarddataWizardDefUpdate(mapping, req, res);
		if (path.equals("aswizarddataWizardDefClose"))
			return aswizarddataWizardDefClose(mapping, req, res);
		if (path.equals("aswizarddataWizardDefLock"))
			return aswizarddataWizardDefLock(mapping, req, res);
		if (path.equals("aswizarddataWizardDefUnLock"))
			return aswizarddataWizardDefUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand aswizarddataWizardDefDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			WizardDef wizarddefCurr = getASWizardDataService().getWizardDef(id);
			if (wizarddefCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)wizarddefCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASWizardDataService().deleteWizardDef(id);
		}
		res.sendRedirect("aswizarddataWizardDefShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand aswizarddataWizardDefDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		WizardDef wizarddefSrc = getASWizardDataService().getWizardDef(id);
		WizardDef wizarddefDest = WizardDefFactory.createWizardDef(wizarddefSrc);



		WizardDef wizarddefCreated = getASWizardDataService().createWizardDef(wizarddefDest);
		res.sendRedirect("aswizarddataWizardDefEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+wizarddefCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand aswizarddataWizardDefUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditWizardDefFB form = new EditWizardDefFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		WizardDef wizarddef = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		wizarddef = (WizardDef)getASWizardDataService().getWizardDef(form.getId()).clone();
	}else{
		wizarddef = WizardDefFactory.createWizardDef();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	wizarddef.setName(form.getName());
	// skipped container wizardSteps
	wizarddef.setHandler(form.getHandler());
	wizarddef.setWizardCancelRedirectUrl(form.getWizardCancelRedirectUrl());
	wizarddef.setWizardFinishRedirectUrl(form.getWizardFinishRedirectUrl());
	wizarddef.setAccessOperation(form.getAccessOperation());

	WizardDef updatedCopy = null;
	if (create){
		updatedCopy = getASWizardDataService().createWizardDef(wizarddef);
	}else{
		canUpdateWizardDefs(wizarddef, req);
		checkWizardDefs(wizarddef, req);
		updatedCopy = getASWizardDataService().updateWizardDef(wizarddef);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("aswizarddataWizardDefEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(wizarddef, req);
		res.sendRedirect("aswizarddataWizardDefShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(WizardDef wizarddef, HttpServletRequest req) throws Exception{
	if(((LockableObject)wizarddef).isLocked())
		unLockWizardDefs(wizarddef, req, false);
}

public ActionCommand aswizarddataWizardDefLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	WizardDef wizarddefCurr = id != null && !id.equals("") ? getASWizardDataService().getWizardDef(id) : null;
	if(wizarddefCurr != null && wizarddefCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)wizarddefCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockWizardDefs(wizarddefCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, wizarddefCurr));
	return null;
}

public ActionCommand aswizarddataWizardDefUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	WizardDef wizarddefCurr = id != null && !id.equals("") ? getASWizardDataService().getWizardDef(id) : null;
	if(wizarddefCurr != null && wizarddefCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)wizarddefCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockWizardDefs(wizarddefCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, wizarddefCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, WizardDef item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "aswizarddataWizardDefShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "aswizarddataWizardDefEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "aswizarddataWizardDefShow?ts="+System.currentTimeMillis();
}

public ActionCommand aswizarddataWizardDefClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	WizardDef wizarddefCurr = id != null && !id.equals("") ? getASWizardDataService().getWizardDef(id) : null;
	if(wizarddefCurr != null && wizarddefCurr instanceof LockableObject && ((LockableObject)wizarddefCurr).isLocked()) 
		unLockWizardDefs(wizarddefCurr, req, false);
	res.sendRedirect("aswizarddataWizardDefShow?ts="+System.currentTimeMillis());
	return null;
}

}
