/**
 ********************************************************************************
 *** MultiOpPagexsC3Action.java                                               ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.action;

import java.util.List;
import java.util.ArrayList;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.aswebdata.data.PagexFactory;
import net.anotheria.anosite.gen.aswebdata.data.Pagex;
import net.anotheria.anosite.gen.aswebdata.bean.C3ElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.aswebdata.bean.C3QuickAddFB;
import net.anotheria.anosite.gen.aswebdata.data.Box;
import net.anotheria.anosite.gen.aswebdata.data.BoxSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpPagexsC3Action extends BasePagexAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("aswebdataPagexC3Show"))
			return aswebdataPagexC3Show(mapping, req, res);
		if (path.equals("aswebdataPagexC3Add"))
			return aswebdataPagexC3Add(mapping, req, res);
		if (path.equals("aswebdataPagexC3Delete"))
			return aswebdataPagexC3Delete(mapping, req, res);
		if (path.equals("aswebdataPagexC3Move"))
			return aswebdataPagexC3Move(mapping, req, res);
		if (path.equals("aswebdataPagexC3QuickAdd"))
			return aswebdataPagexC3QuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand aswebdataPagexC3Show(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Pagex pagex = getASWebDataService().getPagex(id);
		addBeanToRequest(req, "ownerId", id);
		checkPagexs(pagex, req);

		C3ElementFB form = new C3ElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(pagex.getId());
		addBeanToRequest(req, "aswebdataPagexC3ElementForm", form);

		C3QuickAddFB quickAddForm = new C3QuickAddFB() ;
		quickAddForm.setOwnerId(pagex.getId());
		addBeanToRequest(req, "aswebdataPagexC3QuickAddForm", quickAddForm);


		//link box to ASWebData.Box
		List<Box> boxs = getASWebDataService().getBoxs(new BoxSortType(BoxSortType.SORT_BY_NAME));
		List<LabelValueBean> boxsValues = new ArrayList<LabelValueBean>(boxs.size());
		for (int i=0; i<boxs.size(); i++){
			net.anotheria.anosite.gen.aswebdata.data.Box tmp_box = (net.anotheria.anosite.gen.aswebdata.data.Box) boxs.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_box.getId(), tmp_box.getName()+" ["+tmp_box.getId()+"]" );
			boxsValues.add(bean);
		}
		addBeanToRequest(req, "boxValuesCollection", boxsValues);
		// generate list ...
		int size = pagex.getC3Size();
		List<C3ElementFB> beans = new ArrayList<C3ElementFB>(size);
		for (int i=0; i<size; i++){
			String value = pagex.getC3Element(i);
			C3ElementFB bean = new C3ElementFB();
			bean.setOwnerId(pagex.getId());
			bean.setPosition(i);
			bean.setBox(value);
			try{
				Box tmp_box = getASWebDataService().getBox(value);
				bean.setDescription(tmp_box.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand aswebdataPagexC3Delete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Pagex pagexCurr = getASWebDataService().getPagex(id);
		canUpdatePagexs(pagexCurr, req);
		checkPagexs(pagexCurr, req);
		int position = getIntParameter(req, "pPosition");
		Pagex pagex = getASWebDataService().getPagex(id);
		pagex.removeC3Element(position);
		getASWebDataService().updatePagex(pagex);
		return aswebdataPagexC3Show(mapping, req, res);
	}

	public ActionCommand aswebdataPagexC3Move(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		Pagex pagex = getASWebDataService().getPagex(id);
		canUpdatePagexs(pagex, req);
		checkPagexs(pagex, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(pagex, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(pagex, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(pagex, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(pagex, position);
		return aswebdataPagexC3Show(mapping, req, res);
	}

	private void moveUp(Pagex pagex, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		pagex.swapC3Element(position, position-1);
		getASWebDataService().updatePagex(pagex);
	}

	private void moveTop(Pagex pagex, int position) throws ASGRuntimeException {
		List<String> targetList = pagex.getC3();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		pagex.setC3(targetList);
		getASWebDataService().updatePagex(pagex);
	}

	private void moveDown(Pagex pagex, int position) throws ASGRuntimeException {
		if (position<pagex.getC3Size()-1){
			pagex.swapC3Element(position, position+1);
			getASWebDataService().updatePagex(pagex);
		}
	}

	private void moveBottom(Pagex pagex, int position) throws ASGRuntimeException {
		List<String> targetList = pagex.getC3();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		pagex.setC3(targetList);
		getASWebDataService().updatePagex(pagex);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand aswebdataPagexC3Add(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		C3ElementFB form = new C3ElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Pagex pagex;
		pagex = getASWebDataService().getPagex(id);
		canUpdatePagexs(pagex, req);
		checkPagexs(pagex, req);
		pagex.addC3Element(form.getBox());
		getASWebDataService().updatePagex(pagex);
		return aswebdataPagexC3Show(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand aswebdataPagexC3QuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		C3QuickAddFB form = new C3QuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Pagex pagex;
		pagex = getASWebDataService().getPagex(id);
		canUpdatePagexs(pagex, req);
		checkPagexs(pagex, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				pagex.addC3Element(""+i);
			}
		}
		getASWebDataService().updatePagex(pagex);
		return aswebdataPagexC3Show(mapping, req, res);
	}

}
