/**
 ********************************************************************************
 *** MultiOpPagexsAttributesAction.java                                       ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.action;

import java.util.List;
import java.util.ArrayList;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.aswebdata.data.PagexFactory;
import net.anotheria.anosite.gen.aswebdata.data.Pagex;
import net.anotheria.anosite.gen.aswebdata.bean.AttributesElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.aswebdata.bean.AttributesQuickAddFB;
import net.anotheria.anosite.gen.aswebdata.data.Attribute;
import net.anotheria.anosite.gen.aswebdata.data.AttributeSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpPagexsAttributesAction extends BasePagexAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("aswebdataPagexAttributesShow"))
			return aswebdataPagexAttributesShow(mapping, req, res);
		if (path.equals("aswebdataPagexAttributesAdd"))
			return aswebdataPagexAttributesAdd(mapping, req, res);
		if (path.equals("aswebdataPagexAttributesDelete"))
			return aswebdataPagexAttributesDelete(mapping, req, res);
		if (path.equals("aswebdataPagexAttributesMove"))
			return aswebdataPagexAttributesMove(mapping, req, res);
		if (path.equals("aswebdataPagexAttributesQuickAdd"))
			return aswebdataPagexAttributesQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand aswebdataPagexAttributesShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Pagex pagex = getASWebDataService().getPagex(id);
		addBeanToRequest(req, "ownerId", id);
		checkPagexs(pagex, req);

		AttributesElementFB form = new AttributesElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(pagex.getId());
		addBeanToRequest(req, "aswebdataPagexAttributesElementForm", form);

		AttributesQuickAddFB quickAddForm = new AttributesQuickAddFB() ;
		quickAddForm.setOwnerId(pagex.getId());
		addBeanToRequest(req, "aswebdataPagexAttributesQuickAddForm", quickAddForm);


		//link attribute to Attribute
		List<Attribute> attributes = getASWebDataService().getAttributes(new AttributeSortType(AttributeSortType.SORT_BY_NAME));
		List<LabelValueBean> attributesValues = new ArrayList<LabelValueBean>(attributes.size());
		for (int i=0; i<attributes.size(); i++){
			net.anotheria.anosite.gen.aswebdata.data.Attribute tmp_attribute = (net.anotheria.anosite.gen.aswebdata.data.Attribute) attributes.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_attribute.getId(), tmp_attribute.getName()+" ["+tmp_attribute.getId()+"]" );
			attributesValues.add(bean);
		}
		addBeanToRequest(req, "attributeValuesCollection", attributesValues);
		// generate list ...
		int size = pagex.getAttributesSize();
		List<AttributesElementFB> beans = new ArrayList<AttributesElementFB>(size);
		for (int i=0; i<size; i++){
			String value = pagex.getAttributesElement(i);
			AttributesElementFB bean = new AttributesElementFB();
			bean.setOwnerId(pagex.getId());
			bean.setPosition(i);
			bean.setAttribute(value);
			try{
				Attribute tmp_attribute = getASWebDataService().getAttribute(value);
				bean.setDescription(tmp_attribute.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand aswebdataPagexAttributesDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Pagex pagexCurr = getASWebDataService().getPagex(id);
		canUpdatePagexs(pagexCurr, req);
		checkPagexs(pagexCurr, req);
		int position = getIntParameter(req, "pPosition");
		Pagex pagex = getASWebDataService().getPagex(id);
		pagex.removeAttributesElement(position);
		getASWebDataService().updatePagex(pagex);
		return aswebdataPagexAttributesShow(mapping, req, res);
	}

	public ActionCommand aswebdataPagexAttributesMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		Pagex pagex = getASWebDataService().getPagex(id);
		canUpdatePagexs(pagex, req);
		checkPagexs(pagex, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(pagex, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(pagex, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(pagex, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(pagex, position);
		return aswebdataPagexAttributesShow(mapping, req, res);
	}

	private void moveUp(Pagex pagex, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		pagex.swapAttributesElement(position, position-1);
		getASWebDataService().updatePagex(pagex);
	}

	private void moveTop(Pagex pagex, int position) throws ASGRuntimeException {
		List<String> targetList = pagex.getAttributes();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		pagex.setAttributes(targetList);
		getASWebDataService().updatePagex(pagex);
	}

	private void moveDown(Pagex pagex, int position) throws ASGRuntimeException {
		if (position<pagex.getAttributesSize()-1){
			pagex.swapAttributesElement(position, position+1);
			getASWebDataService().updatePagex(pagex);
		}
	}

	private void moveBottom(Pagex pagex, int position) throws ASGRuntimeException {
		List<String> targetList = pagex.getAttributes();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		pagex.setAttributes(targetList);
		getASWebDataService().updatePagex(pagex);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand aswebdataPagexAttributesAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		AttributesElementFB form = new AttributesElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Pagex pagex;
		pagex = getASWebDataService().getPagex(id);
		canUpdatePagexs(pagex, req);
		checkPagexs(pagex, req);
		pagex.addAttributesElement(form.getAttribute());
		getASWebDataService().updatePagex(pagex);
		return aswebdataPagexAttributesShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand aswebdataPagexAttributesQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		AttributesQuickAddFB form = new AttributesQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Pagex pagex;
		pagex = getASWebDataService().getPagex(id);
		canUpdatePagexs(pagex, req);
		checkPagexs(pagex, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				pagex.addAttributesElement(""+i);
			}
		}
		getASWebDataService().updatePagex(pagex);
		return aswebdataPagexAttributesShow(mapping, req, res);
	}

}
