/**
 ********************************************************************************
 *** MultiOpDialogPagexsAction.java                                           ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.action;

import net.anotheria.util.NumberUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.aswebdata.data.PagexFactory;
import net.anotheria.anosite.gen.aswebdata.data.Pagex;
import net.anotheria.anosite.gen.aswebdata.bean.EditPagexFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import net.anotheria.asg.data.MultilingualObject;

public class MultiOpDialogPagexsAction extends BasePagexAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("aswebdataPagexDelete"))
			return aswebdataPagexDelete(mapping, req, res);
		if (path.equals("aswebdataPagexDuplicate"))
			return aswebdataPagexDuplicate(mapping, req, res);
		if (path.equals("aswebdataPagexUpdate"))
			return aswebdataPagexUpdate(mapping, req, res);
		if (path.equals("aswebdataPagexClose"))
			return aswebdataPagexClose(mapping, req, res);
		if (path.equals("aswebdataPagexCopyLang"))
			return aswebdataPagexCopyLang(mapping, req, res);
		if (path.equals("aswebdataPagexSwitchMultilang"))
			return aswebdataPagexSwitchMultilang(mapping, req, res);
		if (path.equals("aswebdataPagexLock"))
			return aswebdataPagexLock(mapping, req, res);
		if (path.equals("aswebdataPagexUnLock"))
			return aswebdataPagexUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand aswebdataPagexDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			Pagex pagexCurr = getASWebDataService().getPagex(id);
			if (pagexCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)pagexCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASWebDataService().deletePagex(id);
		}
		res.sendRedirect("aswebdataPagexShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand aswebdataPagexDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		Pagex pagexSrc = getASWebDataService().getPagex(id);
		Pagex pagexDest = PagexFactory.createPagex(pagexSrc);











		Pagex pagexCreated = getASWebDataService().createPagex(pagexDest);
		res.sendRedirect("aswebdataPagexEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+pagexCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand aswebdataPagexUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditPagexFB form = new EditPagexFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		Pagex pagex = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		pagex = (Pagex)getASWebDataService().getPagex(form.getId()).clone();
	}else{
		pagex = PagexFactory.createPagex();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	pagex.setName(form.getName());
	pagex.setLocalizedNameEN(form.getLocalizedNameEN());
	pagex.setTitleEN(form.getTitleEN());
	pagex.setKeywordsEN(form.getKeywordsEN());
	pagex.setDescriptionEN(form.getDescriptionEN());
	// skipped container mediaLinks
	// skipped container scripts
	// skipped container localizations
	pagex.setTemplate(form.getTemplate());
	// skipped container attributes
	// skipped container c1
	// skipped container c2
	// skipped container c3
	// skipped container header
	// skipped container footer
	pagex.setHttpsonly(form.isHttpsonly());
	pagex.setAccessOperation(form.getAccessOperation());
	pagex.setFeature(form.getFeature());

	Pagex updatedCopy = null;
	if (create){
		updatedCopy = getASWebDataService().createPagex(pagex);
	}else{
		canUpdatePagexs(pagex, req);
		checkPagexs(pagex, req);
		updatedCopy = getASWebDataService().updatePagex(pagex);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("aswebdataPagexEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(pagex, req);
		res.sendRedirect("aswebdataPagexShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(Pagex pagex, HttpServletRequest req) throws Exception{
	if(((LockableObject)pagex).isLocked())
		unLockPagexs(pagex, req, false);
}

public ActionCommand aswebdataPagexCopyLang(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String sourceLanguage = req.getParameter("pSrcLang");
	if (sourceLanguage==null || sourceLanguage.length()==0)
		throw new RuntimeException("No source language");

	String destLanguage = req.getParameter("pDestLang");
	if (destLanguage==null || destLanguage.length()==0)
		throw new RuntimeException("No destination language");

	String id = getStringParameter(req, PARAM_ID);
	Pagex pagex = getASWebDataService().getPagex(id);
	canUpdatePagexs(pagex, req);
	checkPagexs(pagex, req);
	pagex.copyLANG2LANG(sourceLanguage, destLanguage);
	getASWebDataService().updatePagex(pagex);
	res.sendRedirect("aswebdataPagexEdit?ts="+System.currentTimeMillis()+"&pId="+id);
	return null;
}

public ActionCommand aswebdataPagexSwitchMultilang(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	String value = getStringParameter(req, "value");
	Pagex pagex = getASWebDataService().getPagex(id);
	canUpdatePagexs(pagex, req);
	checkPagexs(pagex, req);
	((MultilingualObject)pagex).setMultilingualDisabledInstance(Boolean.valueOf(value));
	getASWebDataService().updatePagex(pagex);
	res.sendRedirect("aswebdataPagexEdit?ts="+System.currentTimeMillis()+"&pId="+id);
	return null;
}

public ActionCommand aswebdataPagexLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Pagex pagexCurr = id != null && !id.equals("") ? getASWebDataService().getPagex(id) : null;
	if(pagexCurr != null && pagexCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)pagexCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockPagexs(pagexCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, pagexCurr));
	return null;
}

public ActionCommand aswebdataPagexUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Pagex pagexCurr = id != null && !id.equals("") ? getASWebDataService().getPagex(id) : null;
	if(pagexCurr != null && pagexCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)pagexCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockPagexs(pagexCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, pagexCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, Pagex item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "aswebdataPagexShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "aswebdataPagexEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "aswebdataPagexShow?ts="+System.currentTimeMillis();
}

public ActionCommand aswebdataPagexClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Pagex pagexCurr = id != null && !id.equals("") ? getASWebDataService().getPagex(id) : null;
	if(pagexCurr != null && pagexCurr instanceof LockableObject && ((LockableObject)pagexCurr).isLocked()) 
		unLockPagexs(pagexCurr, req, false);
	res.sendRedirect("aswebdataPagexShow?ts="+System.currentTimeMillis());
	return null;
}

}
