/**
 ********************************************************************************
 *** MultiOpBoxsMediaLinksAction.java                                         ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.action;

import java.util.List;
import java.util.ArrayList;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.aswebdata.data.BoxFactory;
import net.anotheria.anosite.gen.aswebdata.data.Box;
import net.anotheria.anosite.gen.aswebdata.bean.MediaLinksElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.aswebdata.bean.MediaLinksQuickAddFB;
import net.anotheria.anosite.gen.assitedata.data.MediaLink;
import net.anotheria.anosite.gen.assitedata.data.MediaLinkSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpBoxsMediaLinksAction extends BaseBoxAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("aswebdataBoxMediaLinksShow"))
			return aswebdataBoxMediaLinksShow(mapping, req, res);
		if (path.equals("aswebdataBoxMediaLinksAdd"))
			return aswebdataBoxMediaLinksAdd(mapping, req, res);
		if (path.equals("aswebdataBoxMediaLinksDelete"))
			return aswebdataBoxMediaLinksDelete(mapping, req, res);
		if (path.equals("aswebdataBoxMediaLinksMove"))
			return aswebdataBoxMediaLinksMove(mapping, req, res);
		if (path.equals("aswebdataBoxMediaLinksQuickAdd"))
			return aswebdataBoxMediaLinksQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand aswebdataBoxMediaLinksShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Box box = getASWebDataService().getBox(id);
		addBeanToRequest(req, "ownerId", id);
		checkBoxs(box, req);

		MediaLinksElementFB form = new MediaLinksElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(box.getId());
		addBeanToRequest(req, "aswebdataBoxMediaLinksElementForm", form);

		MediaLinksQuickAddFB quickAddForm = new MediaLinksQuickAddFB() ;
		quickAddForm.setOwnerId(box.getId());
		addBeanToRequest(req, "aswebdataBoxMediaLinksQuickAddForm", quickAddForm);


		//link mediaLink to ASSiteData.MediaLink
		List<MediaLink> medialinks = getASSiteDataService().getMediaLinks(new MediaLinkSortType(MediaLinkSortType.SORT_BY_NAME));
		List<LabelValueBean> medialinksValues = new ArrayList<LabelValueBean>(medialinks.size());
		for (int i=0; i<medialinks.size(); i++){
			net.anotheria.anosite.gen.assitedata.data.MediaLink tmp_medialink = (net.anotheria.anosite.gen.assitedata.data.MediaLink) medialinks.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_medialink.getId(), tmp_medialink.getName()+" ["+tmp_medialink.getId()+"]" );
			medialinksValues.add(bean);
		}
		addBeanToRequest(req, "medialinkValuesCollection", medialinksValues);
		// generate list ...
		int size = box.getMediaLinksSize();
		List<MediaLinksElementFB> beans = new ArrayList<MediaLinksElementFB>(size);
		for (int i=0; i<size; i++){
			String value = box.getMediaLinksElement(i);
			MediaLinksElementFB bean = new MediaLinksElementFB();
			bean.setOwnerId(box.getId());
			bean.setPosition(i);
			bean.setMediaLink(value);
			try{
				MediaLink tmp_medialink = getASSiteDataService().getMediaLink(value);
				bean.setDescription(tmp_medialink.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand aswebdataBoxMediaLinksDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Box boxCurr = getASWebDataService().getBox(id);
		canUpdateBoxs(boxCurr, req);
		checkBoxs(boxCurr, req);
		int position = getIntParameter(req, "pPosition");
		Box box = getASWebDataService().getBox(id);
		box.removeMediaLinksElement(position);
		getASWebDataService().updateBox(box);
		return aswebdataBoxMediaLinksShow(mapping, req, res);
	}

	public ActionCommand aswebdataBoxMediaLinksMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		Box box = getASWebDataService().getBox(id);
		canUpdateBoxs(box, req);
		checkBoxs(box, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(box, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(box, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(box, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(box, position);
		return aswebdataBoxMediaLinksShow(mapping, req, res);
	}

	private void moveUp(Box box, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		box.swapMediaLinksElement(position, position-1);
		getASWebDataService().updateBox(box);
	}

	private void moveTop(Box box, int position) throws ASGRuntimeException {
		List<String> targetList = box.getMediaLinks();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		box.setMediaLinks(targetList);
		getASWebDataService().updateBox(box);
	}

	private void moveDown(Box box, int position) throws ASGRuntimeException {
		if (position<box.getMediaLinksSize()-1){
			box.swapMediaLinksElement(position, position+1);
			getASWebDataService().updateBox(box);
		}
	}

	private void moveBottom(Box box, int position) throws ASGRuntimeException {
		List<String> targetList = box.getMediaLinks();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		box.setMediaLinks(targetList);
		getASWebDataService().updateBox(box);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand aswebdataBoxMediaLinksAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		MediaLinksElementFB form = new MediaLinksElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Box box;
		box = getASWebDataService().getBox(id);
		canUpdateBoxs(box, req);
		checkBoxs(box, req);
		box.addMediaLinksElement(form.getMediaLink());
		getASWebDataService().updateBox(box);
		return aswebdataBoxMediaLinksShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand aswebdataBoxMediaLinksQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		MediaLinksQuickAddFB form = new MediaLinksQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Box box;
		box = getASWebDataService().getBox(id);
		canUpdateBoxs(box, req);
		checkBoxs(box, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				box.addMediaLinksElement(""+i);
			}
		}
		getASWebDataService().updateBox(box);
		return aswebdataBoxMediaLinksShow(mapping, req, res);
	}

}
