/**
 ********************************************************************************
 *** EditPagexAction.java                                                     ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.action;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.aswebdata.bean.EditPagexFB;
import net.anotheria.anosite.gen.aswebdata.data.Pagex;
import net.anotheria.asg.data.MultilingualObject;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.asg.util.bean.LinkToMeBean;
import net.anotheria.anosite.gen.assitedata.data.Site;
import net.anotheria.anosite.gen.assitedata.data.NaviItem;
import net.anotheria.anosite.gen.assitedata.data.EntryPoint;
import net.anotheria.anosite.gen.assitedata.data.PageAlias;
import net.anotheria.anosite.gen.ascustomaction.data.ActionMappingDef;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.anosite.gen.assitedata.data.PageTemplate;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.AccessOperation;
import net.anotheria.anosite.gen.asfeature.data.Feature;

public class EditPagexAction extends ShowPagexsAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateEditAction

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateEditActionMethod

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		EditPagexFB form = new EditPagexFB() ;
		Pagex pagex = getASWebDataService().getPagex(id);
		checkPagexs(pagex, req);
		if(pagex instanceof LockableObject && !((LockableObject)pagex).isLocked() && isAutoLockingEnabled())
			lockPagexs(pagex, req);
		form.setId(pagex.getId());
		form.setName(pagex.getName());
		form.setLocalizedNameEN(pagex.getLocalizedNameEN());
		form.setTitleEN(pagex.getTitleEN());
		form.setKeywordsEN(pagex.getKeywordsEN());
		form.setDescriptionEN(pagex.getDescriptionEN());
		// mediaLinks is a table, storing size only
		form.setMediaLinks(pagex.getMediaLinksSize());
		// scripts is a table, storing size only
		form.setScripts(pagex.getScriptsSize());
		// localizations is a table, storing size only
		form.setLocalizations(pagex.getLocalizationsSize());
		form.setTemplate(pagex.getTemplate());
		form.setTemplatelink("assitedataPageTemplateEdit?pId="+pagex.getTemplate());
		// attributes is a table, storing size only
		form.setAttributes(pagex.getAttributesSize());
		// c1 is a table, storing size only
		form.setC1(pagex.getC1Size());
		// c2 is a table, storing size only
		form.setC2(pagex.getC2Size());
		// c3 is a table, storing size only
		form.setC3(pagex.getC3Size());
		// header is a table, storing size only
		form.setHeader(pagex.getHeaderSize());
		// footer is a table, storing size only
		form.setFooter(pagex.getFooterSize());
		form.setHttpsonly(pagex.getHttpsonly());
		form.setAccessOperation(pagex.getAccessOperation());
		form.setFeature(pagex.getFeature());
		form.setMultilingualInstanceDisabled(((MultilingualObject)pagex).isMultilingualDisabledInstance());
		form.setLocked(((LockableObject)pagex).isLocked());
		form.setLockerId(((LockableObject)pagex).getLockerId());
		form.setLockingTime(net.anotheria.util.NumberUtils.makeISO8601TimestampString(((LockableObject)pagex).getLockingTime()) + " automatic unlock expected AT : " + net.anotheria.util.NumberUtils.makeISO8601TimestampString(((LockableObject)pagex).getLockingTime() + getLockingTimeout()));


		//link template to ASSiteData.PageTemplate
		List<PageTemplate> pagetemplates = getASSiteDataService().getPageTemplates();
		List<LabelValueBean> pagetemplatesValues = new ArrayList<LabelValueBean>(pagetemplates.size()+1);
		pagetemplatesValues.add(new LabelValueBean("", "-----"));
		for (net.anotheria.anosite.gen.assitedata.data.PageTemplate pagetemplateTemp : pagetemplates){
			LabelValueBean bean = new LabelValueBean(pagetemplateTemp.getId(), pagetemplateTemp.getName() + " [" + pagetemplateTemp.getId() + "]" );
			pagetemplatesValues.add(bean);
		}
		form.setTemplateCollection(pagetemplatesValues);
		try{
			form.setTemplateCurrentValue(getASSiteDataService().getPageTemplate(pagex.getTemplate()).getName());
		}catch(Exception e){
			form.setTemplateCurrentValue("none");
			form.setTemplateIdOfCurrentValue("none");
		}

		//link accessOperation to AnoAccessConfiguration.AccessOperation
		List<AccessOperation> accessoperations = getAnoAccessConfigurationService().getAccessOperations();
		List<LabelValueBean> accessoperationsValues = new ArrayList<LabelValueBean>(accessoperations.size()+1);
		accessoperationsValues.add(new LabelValueBean("", "-----"));
		for (net.anotheria.anosite.gen.anoaccessconfiguration.data.AccessOperation accessoperationTemp : accessoperations){
			LabelValueBean bean = new LabelValueBean(accessoperationTemp.getId(), accessoperationTemp.getName() + " [" + accessoperationTemp.getId() + "]" );
			accessoperationsValues.add(bean);
		}
		form.setAccessOperationCollection(accessoperationsValues);
		try{
			form.setAccessOperationCurrentValue(getAnoAccessConfigurationService().getAccessOperation(pagex.getAccessOperation()).getName());
		}catch(Exception e){
			form.setAccessOperationCurrentValue("none");
			form.setAccessOperationIdOfCurrentValue("none");
		}

		//link feature to ASFeature.Feature
		List<Feature> features = getASFeatureService().getFeatures();
		List<LabelValueBean> featuresValues = new ArrayList<LabelValueBean>(features.size()+1);
		featuresValues.add(new LabelValueBean("", "-----"));
		for (net.anotheria.anosite.gen.asfeature.data.Feature featureTemp : features){
			LabelValueBean bean = new LabelValueBean(featureTemp.getId(), featureTemp.getName() + " [" + featureTemp.getId() + "]" );
			featuresValues.add(bean);
		}
		form.setFeatureCollection(featuresValues);
		try{
			form.setFeatureCurrentValue(getASFeatureService().getFeature(pagex.getFeature()).getName());
		}catch(Exception e){
			form.setFeatureCurrentValue("none");
			form.setFeatureIdOfCurrentValue("none");
		}
		addBeanToRequest(req, "objectId" , pagex.getId());
		addBeanToRequest(req, "EditASWebDataPagexForm" , form);
		addBeanToRequest(req, "objectInfoString" , pagex.getObjectInfo().toString());
		addBeanToRequest(req, "apply.label.prefix", "Apply");
		addBeanToRequest(req, "save.label.prefix", "Save");
		addBeanToRequest(req, "transfer.label.prefix", "Transfer");

		addFieldExplanations(req, pagex);


		// Generating back link handling...
		List<LinkToMeBean> linksToMe = findLinksToCurrentDocument(pagex.getId());
		if (linksToMe.size()>0)
			req.setAttribute("linksToMe", linksToMe);
		return mapping.success();
	}

	private List<LinkToMeBean> findLinksToCurrentDocument(String documentId){
		List<LinkToMeBean> ret = new ArrayList<LinkToMeBean>();
		try{
			ret.addAll(findLinkToCurrentDocumentInASSiteDataSiteStartpage(documentId));
		}catch(Exception ignored){
		}
		try{
			ret.addAll(findLinkToCurrentDocumentInASSiteDataSiteSearchpage(documentId));
		}catch(Exception ignored){
		}
		try{
			ret.addAll(findLinkToCurrentDocumentInASSiteDataNaviItemInternalLink(documentId));
		}catch(Exception ignored){
		}
		try{
			ret.addAll(findLinkToCurrentDocumentInASSiteDataEntryPointStartPage(documentId));
		}catch(Exception ignored){
		}
		try{
			ret.addAll(findLinkToCurrentDocumentInASSiteDataPageAliasTargetPage(documentId));
		}catch(Exception ignored){
		}
		try{
			ret.addAll(findLinkToCurrentDocumentInASCustomActionActionMappingDefPage(documentId));
		}catch(Exception ignored){
		}
		return ret;
	}
	private List<LinkToMeBean> findLinkToCurrentDocumentInASSiteDataSiteStartpage(String documentId) throws net.anotheria.anosite.gen.assitedata.service.ASSiteDataServiceException{
		List<LinkToMeBean> ret = new ArrayList<LinkToMeBean>();
		QueryProperty p = new QueryProperty(Site.LINK_PROP_STARTPAGE, documentId);
		// temporarly - replacy with query property
		List<Site> list = getASSiteDataService().getSitesByProperty(p.getName(), p.getValue());
		for (Site doc : list ){
			ret.add(new LinkToMeBean(doc, "startpage"));
		}
		return ret;
	}
	private List<LinkToMeBean> findLinkToCurrentDocumentInASSiteDataSiteSearchpage(String documentId) throws net.anotheria.anosite.gen.assitedata.service.ASSiteDataServiceException{
		List<LinkToMeBean> ret = new ArrayList<LinkToMeBean>();
		QueryProperty p = new QueryProperty(Site.LINK_PROP_SEARCHPAGE, documentId);
		// temporarly - replacy with query property
		List<Site> list = getASSiteDataService().getSitesByProperty(p.getName(), p.getValue());
		for (Site doc : list ){
			ret.add(new LinkToMeBean(doc, "searchpage"));
		}
		return ret;
	}
	private List<LinkToMeBean> findLinkToCurrentDocumentInASSiteDataNaviItemInternalLink(String documentId) throws net.anotheria.anosite.gen.assitedata.service.ASSiteDataServiceException{
		List<LinkToMeBean> ret = new ArrayList<LinkToMeBean>();
		QueryProperty p = new QueryProperty(NaviItem.LINK_PROP_INTERNAL_LINK, documentId);
		// temporarly - replacy with query property
		List<NaviItem> list = getASSiteDataService().getNaviItemsByProperty(p.getName(), p.getValue());
		for (NaviItem doc : list ){
			ret.add(new LinkToMeBean(doc, "internalLink"));
		}
		return ret;
	}
	private List<LinkToMeBean> findLinkToCurrentDocumentInASSiteDataEntryPointStartPage(String documentId) throws net.anotheria.anosite.gen.assitedata.service.ASSiteDataServiceException{
		List<LinkToMeBean> ret = new ArrayList<LinkToMeBean>();
		QueryProperty p = new QueryProperty(EntryPoint.LINK_PROP_START_PAGE, documentId);
		// temporarly - replacy with query property
		List<EntryPoint> list = getASSiteDataService().getEntryPointsByProperty(p.getName(), p.getValue());
		for (EntryPoint doc : list ){
			ret.add(new LinkToMeBean(doc, "startPage"));
		}
		return ret;
	}
	private List<LinkToMeBean> findLinkToCurrentDocumentInASSiteDataPageAliasTargetPage(String documentId) throws net.anotheria.anosite.gen.assitedata.service.ASSiteDataServiceException{
		List<LinkToMeBean> ret = new ArrayList<LinkToMeBean>();
		QueryProperty p = new QueryProperty(PageAlias.LINK_PROP_TARGET_PAGE, documentId);
		// temporarly - replacy with query property
		List<PageAlias> list = getASSiteDataService().getPageAliassByProperty(p.getName(), p.getValue());
		for (PageAlias doc : list ){
			ret.add(new LinkToMeBean(doc, "targetPage"));
		}
		return ret;
	}
	private List<LinkToMeBean> findLinkToCurrentDocumentInASCustomActionActionMappingDefPage(String documentId) throws net.anotheria.anosite.gen.ascustomaction.service.ASCustomActionServiceException{
		List<LinkToMeBean> ret = new ArrayList<LinkToMeBean>();
		QueryProperty p = new QueryProperty(ActionMappingDef.LINK_PROP_PAGE, documentId);
		// temporarly - replacy with query property
		List<ActionMappingDef> list = getASCustomActionService().getActionMappingDefsByProperty(p.getName(), p.getValue());
		for (ActionMappingDef doc : list ){
			ret.add(new LinkToMeBean(doc, "page"));
		}
		return ret;
	}
}
