/**
 ********************************************************************************
 *** BasePagexAction.java                                                     ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.action;

import net.anotheria.anosite.gen.shared.action.BaseContentAction;
import jakarta.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.aswebdata.data.Pagex;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BasePagexAction extends BaseContentAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Page";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASWebData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "Pagex";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, Pagex pagex) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASWebData.Pagex").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Pagex", pagex, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Pagex", pagex, "localizedName");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.localizedName", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Pagex", pagex, "title");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.title", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Pagex", pagex, "keywords");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.keywords", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Pagex", pagex, "description");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.description", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Pagex", pagex, "mediaLinks");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.mediaLinks", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Pagex", pagex, "scripts");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.scripts", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Pagex", pagex, "attributes");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.attributes", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Pagex", pagex, "c1");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.c1", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Pagex", pagex, "c2");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.c2", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Pagex", pagex, "c3");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.c3", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Pagex", pagex, "header");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.header", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Pagex", pagex, "footer");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.footer", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Pagex", pagex, "localizations");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.localizations", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Pagex", pagex, "httpsonly");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.httpsonly", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockPagexs(Pagex pagex, HttpServletRequest req) throws Exception{
		if(pagex instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)pagex;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASWebDataService().updatePagex( pagex);
			logger.info("Lock-OPERATION, document with id : ["+pagex.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockPagexs(Pagex pagex, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(pagex instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)pagex;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASWebDataService().updatePagex( pagex);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+pagex.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+pagex.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkPagexs(Pagex pagex, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = pagex instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)pagex).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)pagex).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockPagexs(pagex, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdatePagexs(Pagex pagex, HttpServletRequest req) throws Exception{
		if(pagex instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)pagex, false, getUserId(req));
		}
		if (isTimeoutReached(pagex)) {
			checkPagexs(pagex, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(pagex, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(Pagex pagex){
		if (pagex instanceof LockableObject) {
			LockableObject lock = (LockableObject)pagex;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(Pagex pagex, HttpServletRequest req){
		if (pagex instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)pagex;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
