/**
 ********************************************************************************
 *** BaseBoxAction.java                                                       ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.action;

import net.anotheria.anosite.gen.shared.action.BaseContentAction;
import jakarta.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.aswebdata.data.Box;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseBoxAction extends BaseContentAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Box";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASWebData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "Box";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, Box box) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASWebData.Box").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Box", box, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Box", box, "content");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.content", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Box", box, "mediaLinks");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.mediaLinks", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Box", box, "scripts");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.scripts", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Box", box, "localizations");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.localizations", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Box", box, "subboxes");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.subboxes", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Box", box, "cssClass");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.cssClass", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Box", box, "parameter1");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameter1", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Box", box, "parameter2");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameter2", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Box", box, "parameter3");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameter3", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Box", box, "parameter4");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameter4", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Box", box, "parameter5");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameter5", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Box", box, "parameter6");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameter6", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Box", box, "parameter7");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameter7", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Box", box, "parameter8");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameter8", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Box", box, "parameter9");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameter9", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Box", box, "parameter10");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameter10", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Box", box, "guards");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.guards", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Box", box, "attributes");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.attributes", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockBoxs(Box box, HttpServletRequest req) throws Exception{
		if(box instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)box;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASWebDataService().updateBox( box);
			logger.info("Lock-OPERATION, document with id : ["+box.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockBoxs(Box box, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(box instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)box;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASWebDataService().updateBox( box);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+box.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+box.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkBoxs(Box box, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = box instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)box).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)box).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockBoxs(box, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateBoxs(Box box, HttpServletRequest req) throws Exception{
		if(box instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)box, false, getUserId(req));
		}
		if (isTimeoutReached(box)) {
			checkBoxs(box, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(box, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(Box box){
		if (box instanceof LockableObject) {
			LockableObject lock = (LockableObject)box;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(Box box, HttpServletRequest req){
		if (box instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)box;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
