/**
 ********************************************************************************
 *** MultiOpNaviItemsGuardsAction.java                                        ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import java.util.List;
import java.util.ArrayList;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.assitedata.data.NaviItemFactory;
import net.anotheria.anosite.gen.assitedata.data.NaviItem;
import net.anotheria.anosite.gen.assitedata.bean.GuardsElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.assitedata.bean.GuardsQuickAddFB;
import net.anotheria.anosite.gen.asfederateddata.data.GuardDef;
import net.anotheria.anosite.gen.asfederateddata.data.GuardDefSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpNaviItemsGuardsAction extends BaseNaviItemAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("assitedataNaviItemGuardsShow"))
			return assitedataNaviItemGuardsShow(mapping, req, res);
		if (path.equals("assitedataNaviItemGuardsAdd"))
			return assitedataNaviItemGuardsAdd(mapping, req, res);
		if (path.equals("assitedataNaviItemGuardsDelete"))
			return assitedataNaviItemGuardsDelete(mapping, req, res);
		if (path.equals("assitedataNaviItemGuardsMove"))
			return assitedataNaviItemGuardsMove(mapping, req, res);
		if (path.equals("assitedataNaviItemGuardsQuickAdd"))
			return assitedataNaviItemGuardsQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand assitedataNaviItemGuardsShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		NaviItem naviitem = getASSiteDataService().getNaviItem(id);
		addBeanToRequest(req, "ownerId", id);
		checkNaviItems(naviitem, req);

		GuardsElementFB form = new GuardsElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(naviitem.getId());
		addBeanToRequest(req, "assitedataNaviItemGuardsElementForm", form);

		GuardsQuickAddFB quickAddForm = new GuardsQuickAddFB() ;
		quickAddForm.setOwnerId(naviitem.getId());
		addBeanToRequest(req, "assitedataNaviItemGuardsQuickAddForm", quickAddForm);


		//link guard to ASFederatedData.GuardDef
		List<GuardDef> guarddefs = getASFederatedDataService().getGuardDefs(new GuardDefSortType(GuardDefSortType.SORT_BY_NAME));
		List<LabelValueBean> guarddefsValues = new ArrayList<LabelValueBean>(guarddefs.size());
		for (int i=0; i<guarddefs.size(); i++){
			net.anotheria.anosite.gen.asfederateddata.data.GuardDef tmp_guarddef = (net.anotheria.anosite.gen.asfederateddata.data.GuardDef) guarddefs.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_guarddef.getId(), tmp_guarddef.getName()+" ["+tmp_guarddef.getId()+"]" );
			guarddefsValues.add(bean);
		}
		addBeanToRequest(req, "guardValuesCollection", guarddefsValues);
		// generate list ...
		int size = naviitem.getGuardsSize();
		List<GuardsElementFB> beans = new ArrayList<GuardsElementFB>(size);
		for (int i=0; i<size; i++){
			String value = naviitem.getGuardsElement(i);
			GuardsElementFB bean = new GuardsElementFB();
			bean.setOwnerId(naviitem.getId());
			bean.setPosition(i);
			bean.setGuard(value);
			try{
				GuardDef tmp_guarddef = getASFederatedDataService().getGuardDef(value);
				bean.setDescription(tmp_guarddef.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand assitedataNaviItemGuardsDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		NaviItem naviitemCurr = getASSiteDataService().getNaviItem(id);
		canUpdateNaviItems(naviitemCurr, req);
		checkNaviItems(naviitemCurr, req);
		int position = getIntParameter(req, "pPosition");
		NaviItem naviitem = getASSiteDataService().getNaviItem(id);
		naviitem.removeGuardsElement(position);
		getASSiteDataService().updateNaviItem(naviitem);
		return assitedataNaviItemGuardsShow(mapping, req, res);
	}

	public ActionCommand assitedataNaviItemGuardsMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		NaviItem naviitem = getASSiteDataService().getNaviItem(id);
		canUpdateNaviItems(naviitem, req);
		checkNaviItems(naviitem, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(naviitem, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(naviitem, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(naviitem, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(naviitem, position);
		return assitedataNaviItemGuardsShow(mapping, req, res);
	}

	private void moveUp(NaviItem naviitem, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		naviitem.swapGuardsElement(position, position-1);
		getASSiteDataService().updateNaviItem(naviitem);
	}

	private void moveTop(NaviItem naviitem, int position) throws ASGRuntimeException {
		List<String> targetList = naviitem.getGuards();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		naviitem.setGuards(targetList);
		getASSiteDataService().updateNaviItem(naviitem);
	}

	private void moveDown(NaviItem naviitem, int position) throws ASGRuntimeException {
		if (position<naviitem.getGuardsSize()-1){
			naviitem.swapGuardsElement(position, position+1);
			getASSiteDataService().updateNaviItem(naviitem);
		}
	}

	private void moveBottom(NaviItem naviitem, int position) throws ASGRuntimeException {
		List<String> targetList = naviitem.getGuards();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		naviitem.setGuards(targetList);
		getASSiteDataService().updateNaviItem(naviitem);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand assitedataNaviItemGuardsAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		GuardsElementFB form = new GuardsElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		NaviItem naviitem;
		naviitem = getASSiteDataService().getNaviItem(id);
		canUpdateNaviItems(naviitem, req);
		checkNaviItems(naviitem, req);
		naviitem.addGuardsElement(form.getGuard());
		getASSiteDataService().updateNaviItem(naviitem);
		return assitedataNaviItemGuardsShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand assitedataNaviItemGuardsQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		GuardsQuickAddFB form = new GuardsQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		NaviItem naviitem;
		naviitem = getASSiteDataService().getNaviItem(id);
		canUpdateNaviItems(naviitem, req);
		checkNaviItems(naviitem, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				naviitem.addGuardsElement(""+i);
			}
		}
		getASSiteDataService().updateNaviItem(naviitem);
		return assitedataNaviItemGuardsShow(mapping, req, res);
	}

}
