/**
 ********************************************************************************
 *** MultiOpMediaLinksGuardsAction.java                                       ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import java.util.List;
import java.util.ArrayList;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.assitedata.data.MediaLinkFactory;
import net.anotheria.anosite.gen.assitedata.data.MediaLink;
import net.anotheria.anosite.gen.assitedata.bean.GuardsElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.assitedata.bean.GuardsQuickAddFB;
import net.anotheria.anosite.gen.asfederateddata.data.GuardDef;
import net.anotheria.anosite.gen.asfederateddata.data.GuardDefSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpMediaLinksGuardsAction extends BaseMediaLinkAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("assitedataMediaLinkGuardsShow"))
			return assitedataMediaLinkGuardsShow(mapping, req, res);
		if (path.equals("assitedataMediaLinkGuardsAdd"))
			return assitedataMediaLinkGuardsAdd(mapping, req, res);
		if (path.equals("assitedataMediaLinkGuardsDelete"))
			return assitedataMediaLinkGuardsDelete(mapping, req, res);
		if (path.equals("assitedataMediaLinkGuardsMove"))
			return assitedataMediaLinkGuardsMove(mapping, req, res);
		if (path.equals("assitedataMediaLinkGuardsQuickAdd"))
			return assitedataMediaLinkGuardsQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand assitedataMediaLinkGuardsShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		MediaLink medialink = getASSiteDataService().getMediaLink(id);
		addBeanToRequest(req, "ownerId", id);
		checkMediaLinks(medialink, req);

		GuardsElementFB form = new GuardsElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(medialink.getId());
		addBeanToRequest(req, "assitedataMediaLinkGuardsElementForm", form);

		GuardsQuickAddFB quickAddForm = new GuardsQuickAddFB() ;
		quickAddForm.setOwnerId(medialink.getId());
		addBeanToRequest(req, "assitedataMediaLinkGuardsQuickAddForm", quickAddForm);


		//link guard to ASFederatedData.GuardDef
		List<GuardDef> guarddefs = getASFederatedDataService().getGuardDefs(new GuardDefSortType(GuardDefSortType.SORT_BY_NAME));
		List<LabelValueBean> guarddefsValues = new ArrayList<LabelValueBean>(guarddefs.size());
		for (int i=0; i<guarddefs.size(); i++){
			net.anotheria.anosite.gen.asfederateddata.data.GuardDef tmp_guarddef = (net.anotheria.anosite.gen.asfederateddata.data.GuardDef) guarddefs.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_guarddef.getId(), tmp_guarddef.getName()+" ["+tmp_guarddef.getId()+"]" );
			guarddefsValues.add(bean);
		}
		addBeanToRequest(req, "guardValuesCollection", guarddefsValues);
		// generate list ...
		int size = medialink.getGuardsSize();
		List<GuardsElementFB> beans = new ArrayList<GuardsElementFB>(size);
		for (int i=0; i<size; i++){
			String value = medialink.getGuardsElement(i);
			GuardsElementFB bean = new GuardsElementFB();
			bean.setOwnerId(medialink.getId());
			bean.setPosition(i);
			bean.setGuard(value);
			try{
				GuardDef tmp_guarddef = getASFederatedDataService().getGuardDef(value);
				bean.setDescription(tmp_guarddef.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand assitedataMediaLinkGuardsDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		MediaLink medialinkCurr = getASSiteDataService().getMediaLink(id);
		canUpdateMediaLinks(medialinkCurr, req);
		checkMediaLinks(medialinkCurr, req);
		int position = getIntParameter(req, "pPosition");
		MediaLink medialink = getASSiteDataService().getMediaLink(id);
		medialink.removeGuardsElement(position);
		getASSiteDataService().updateMediaLink(medialink);
		return assitedataMediaLinkGuardsShow(mapping, req, res);
	}

	public ActionCommand assitedataMediaLinkGuardsMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		MediaLink medialink = getASSiteDataService().getMediaLink(id);
		canUpdateMediaLinks(medialink, req);
		checkMediaLinks(medialink, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(medialink, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(medialink, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(medialink, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(medialink, position);
		return assitedataMediaLinkGuardsShow(mapping, req, res);
	}

	private void moveUp(MediaLink medialink, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		medialink.swapGuardsElement(position, position-1);
		getASSiteDataService().updateMediaLink(medialink);
	}

	private void moveTop(MediaLink medialink, int position) throws ASGRuntimeException {
		List<String> targetList = medialink.getGuards();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		medialink.setGuards(targetList);
		getASSiteDataService().updateMediaLink(medialink);
	}

	private void moveDown(MediaLink medialink, int position) throws ASGRuntimeException {
		if (position<medialink.getGuardsSize()-1){
			medialink.swapGuardsElement(position, position+1);
			getASSiteDataService().updateMediaLink(medialink);
		}
	}

	private void moveBottom(MediaLink medialink, int position) throws ASGRuntimeException {
		List<String> targetList = medialink.getGuards();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		medialink.setGuards(targetList);
		getASSiteDataService().updateMediaLink(medialink);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand assitedataMediaLinkGuardsAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		GuardsElementFB form = new GuardsElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		MediaLink medialink;
		medialink = getASSiteDataService().getMediaLink(id);
		canUpdateMediaLinks(medialink, req);
		checkMediaLinks(medialink, req);
		medialink.addGuardsElement(form.getGuard());
		getASSiteDataService().updateMediaLink(medialink);
		return assitedataMediaLinkGuardsShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand assitedataMediaLinkGuardsQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		GuardsQuickAddFB form = new GuardsQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		MediaLink medialink;
		medialink = getASSiteDataService().getMediaLink(id);
		canUpdateMediaLinks(medialink, req);
		checkMediaLinks(medialink, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				medialink.addGuardsElement(""+i);
			}
		}
		getASSiteDataService().updateMediaLink(medialink);
		return assitedataMediaLinkGuardsShow(mapping, req, res);
	}

}
