/**
 ********************************************************************************
 *** EditEntryPointAction.java                                                ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.assitedata.bean.EditEntryPointFB;
import net.anotheria.anosite.gen.assitedata.data.EntryPoint;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anosite.gen.shared.data.PageAliasTypeEnum;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.anosite.gen.aswebdata.data.Pagex;
import net.anotheria.anosite.gen.assitedata.data.Site;
import net.anotheria.asg.exception.ConstantNotFoundException;

public class EditEntryPointAction extends ShowEntryPointsAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateEditAction

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateEditActionMethod

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		EditEntryPointFB form = new EditEntryPointFB() ;
		EntryPoint entrypoint = getASSiteDataService().getEntryPoint(id);
		checkEntryPoints(entrypoint, req);
		if(entrypoint instanceof LockableObject && !((LockableObject)entrypoint).isLocked() && isAutoLockingEnabled())
			lockEntryPoints(entrypoint, req);
		form.setId(entrypoint.getId());
		form.setName(entrypoint.getName());
		form.setStartPage(entrypoint.getStartPage());
		form.setStartSite(entrypoint.getStartSite());
		form.setType(entrypoint.getType());
		form.setDefaultEntry(entrypoint.getDefaultEntry());
		// domains is a table, storing size only
		form.setDomains(entrypoint.getDomainsSize());
		form.setLocked(((LockableObject)entrypoint).isLocked());
		form.setLockerId(((LockableObject)entrypoint).getLockerId());
		form.setLockingTime(net.anotheria.util.NumberUtils.makeISO8601TimestampString(((LockableObject)entrypoint).getLockingTime()) + " automatic unlock expected AT : " + net.anotheria.util.NumberUtils.makeISO8601TimestampString(((LockableObject)entrypoint).getLockingTime() + getLockingTimeout()));


		//link startPage to ASWebData.Pagex
		List<Pagex> pagexs = getASWebDataService().getPagexs();
		List<LabelValueBean> pagexsValues = new ArrayList<LabelValueBean>(pagexs.size()+1);
		pagexsValues.add(new LabelValueBean("", "-----"));
		for (net.anotheria.anosite.gen.aswebdata.data.Pagex pagexTemp : pagexs){
			LabelValueBean bean = new LabelValueBean(pagexTemp.getId(), pagexTemp.getName() + " [" + pagexTemp.getId() + "]" );
			pagexsValues.add(bean);
		}
		form.setStartPageCollection(pagexsValues);
		try{
			form.setStartPageCurrentValue(getASWebDataService().getPagex(entrypoint.getStartPage()).getName());
		}catch(Exception e){
			form.setStartPageCurrentValue("none");
			form.setStartPageIdOfCurrentValue("none");
		}

		//link startSite to ASSiteData.Site
		List<Site> sites = getASSiteDataService().getSites();
		List<LabelValueBean> sitesValues = new ArrayList<LabelValueBean>(sites.size()+1);
		sitesValues.add(new LabelValueBean("", "-----"));
		for (net.anotheria.anosite.gen.assitedata.data.Site siteTemp : sites){
			LabelValueBean bean = new LabelValueBean(siteTemp.getId(), siteTemp.getName() + " [" + siteTemp.getId() + "]" );
			sitesValues.add(bean);
		}
		form.setStartSiteCollection(sitesValues);
		try{
			form.setStartSiteCurrentValue(getASSiteDataService().getSite(entrypoint.getStartSite()).getName());
		}catch(Exception e){
			form.setStartSiteCurrentValue("none");
			form.setStartSiteIdOfCurrentValue("none");
		}
		// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateEnumerationPropertyHandling


		//enumeration PageAliasType
		PageAliasTypeEnum[] PageAliasType_values = PageAliasTypeEnum.values();
		List<LabelValueBean> PageAliasType_valuesListValues = new ArrayList<LabelValueBean>(PageAliasType_values.length);
		for (PageAliasTypeEnum element : PageAliasType_values) {
			LabelValueBean bean = new LabelValueBean(""+element.getValue(), element.name());
			PageAliasType_valuesListValues.add(bean);
		}
		form.setTypeCollection(PageAliasType_valuesListValues);
		try {
			form.setTypeCurrentValue(PageAliasTypeEnum.getConstantByValue(entrypoint.getType()).name());
		}catch(net.anotheria.asg.exception.ConstantNotFoundException e){
		} //try
		addBeanToRequest(req, "objectId" , entrypoint.getId());
		addBeanToRequest(req, "EditASSiteDataEntryPointForm" , form);
		addBeanToRequest(req, "objectInfoString" , entrypoint.getObjectInfo().toString());
		addBeanToRequest(req, "apply.label.prefix", "Apply");
		addBeanToRequest(req, "save.label.prefix", "Save");
		addBeanToRequest(req, "transfer.label.prefix", "Transfer");

		addFieldExplanations(req, entrypoint);

		return mapping.success();
	}

}
