/**
 ********************************************************************************
 *** BaseSiteAction.java                                                      ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import net.anotheria.anosite.gen.shared.action.BaseSitexAction;
import jakarta.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.assitedata.data.Site;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseSiteAction extends BaseSitexAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Site";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASSiteData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "Site";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, Site site) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASSiteData.Site").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.Site", site, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.Site", site, "title");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.title", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.Site", site, "keywords");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.keywords", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.Site", site, "description");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.description", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.Site", site, "subtitle");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.subtitle", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.Site", site, "mainNavi");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.mainNavi", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.Site", site, "topNavi");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.topNavi", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.Site", site, "languageselector");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.languageselector", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockSites(Site site, HttpServletRequest req) throws Exception{
		if(site instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)site;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASSiteDataService().updateSite( site);
			logger.info("Lock-OPERATION, document with id : ["+site.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockSites(Site site, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(site instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)site;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASSiteDataService().updateSite( site);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+site.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+site.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkSites(Site site, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = site instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)site).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)site).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockSites(site, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateSites(Site site, HttpServletRequest req) throws Exception{
		if(site instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)site, false, getUserId(req));
		}
		if (isTimeoutReached(site)) {
			checkSites(site, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(site, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(Site site){
		if (site instanceof LockableObject) {
			LockableObject lock = (LockableObject)site;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(Site site, HttpServletRequest req){
		if (site instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)site;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
