/**
 ********************************************************************************
 *** BaseScriptAction.java                                                    ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import net.anotheria.anosite.gen.shared.action.BaseSitexAction;
import jakarta.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.assitedata.data.Script;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseScriptAction extends BaseSitexAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Script";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASSiteData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "Script";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, Script script) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASSiteData.Script").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.Script", script, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.Script", script, "link");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.link", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.Script", script, "content");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.content", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.Script", script, "browserFiltering");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.browserFiltering", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.Script", script, "guards");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.guards", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockScripts(Script script, HttpServletRequest req) throws Exception{
		if(script instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)script;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASSiteDataService().updateScript( script);
			logger.info("Lock-OPERATION, document with id : ["+script.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockScripts(Script script, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(script instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)script;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASSiteDataService().updateScript( script);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+script.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+script.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkScripts(Script script, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = script instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)script).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)script).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockScripts(script, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateScripts(Script script, HttpServletRequest req) throws Exception{
		if(script instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)script, false, getUserId(req));
		}
		if (isTimeoutReached(script)) {
			checkScripts(script, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(script, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(Script script){
		if (script instanceof LockableObject) {
			LockableObject lock = (LockableObject)script;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(Script script, HttpServletRequest req){
		if (script instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)script;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
