/**
 ********************************************************************************
 *** BaseEntryPointAction.java                                                ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import net.anotheria.anosite.gen.shared.action.BaseSitexAction;
import jakarta.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.assitedata.data.EntryPoint;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseEntryPointAction extends BaseSitexAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "EntryPoint";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASSiteData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "EntryPoint";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, EntryPoint entrypoint) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASSiteData.EntryPoint").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.EntryPoint", entrypoint, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.EntryPoint", entrypoint, "type");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.type", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.EntryPoint", entrypoint, "defaultEntry");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.defaultEntry", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteData.EntryPoint", entrypoint, "domains");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.domains", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockEntryPoints(EntryPoint entrypoint, HttpServletRequest req) throws Exception{
		if(entrypoint instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)entrypoint;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASSiteDataService().updateEntryPoint( entrypoint);
			logger.info("Lock-OPERATION, document with id : ["+entrypoint.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockEntryPoints(EntryPoint entrypoint, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(entrypoint instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)entrypoint;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASSiteDataService().updateEntryPoint( entrypoint);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+entrypoint.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+entrypoint.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkEntryPoints(EntryPoint entrypoint, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = entrypoint instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)entrypoint).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)entrypoint).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockEntryPoints(entrypoint, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateEntryPoints(EntryPoint entrypoint, HttpServletRequest req) throws Exception{
		if(entrypoint instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)entrypoint, false, getUserId(req));
		}
		if (isTimeoutReached(entrypoint)) {
			checkEntryPoints(entrypoint, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(entrypoint, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(EntryPoint entrypoint){
		if (entrypoint instanceof LockableObject) {
			LockableObject lock = (LockableObject)entrypoint;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(EntryPoint entrypoint, HttpServletRequest req){
		if (entrypoint instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)entrypoint;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
