/**
 ********************************************************************************
 *** ASSiteConfigServiceImpl.java                                             ***
 *** The implementation of the IASSiteConfigService.                          ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assiteconfig.service;

import java.nio.charset.Charset;
import java.util.List;
import java.util.ArrayList;
import java.util.Set;
import net.anotheria.anodoc.data.Module;
import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.sorter.StaticQuickSorter;
import net.anotheria.util.slicer.Segment;
import net.anotheria.util.slicer.Slicer;
import net.anotheria.anosite.gen.assiteconfig.data.ModuleASSiteConfig;
import net.anotheria.anosite.gen.shared.service.BasicCMSService;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryResultEntry;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.util.StringUtils;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.xml.XMLAttribute;
import net.anotheria.asg.util.listener.IModuleListener;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import net.anotheria.anodoc.util.mapper.ObjectMapperUtil;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.anosite.gen.assiteconfig.data.FilteredIP;
import net.anotheria.anosite.gen.assiteconfig.data.FilteredIPXMLHelper;
import net.anotheria.anosite.gen.assiteconfig.data.FilteredIPDocument;

public class ASSiteConfigServiceImpl extends BasicCMSService implements IASSiteConfigService, IModuleListener{

	// Generated by: class net.anotheria.asg.generator.model.docs.CMSBasedServiceGenerator.generateImplementation

	private static ASSiteConfigServiceImpl instance;

	private ASSiteConfigServiceImpl(){
		addServiceListener(new net.anotheria.anosite.cms.listener.CRUDLogListener());
		addServiceListener(new net.anotheria.anosite.cms.listener.AutoTransferSiteConfigListener());
		addModuleListener(ModuleASSiteConfig.MODULE_ID, this);
	}

	static final ASSiteConfigServiceImpl getInstance(){
		if (instance==null){
			instance = new ASSiteConfigServiceImpl();
		}
		return instance;
	}

	private ModuleASSiteConfig _getModuleASSiteConfig(){
		return (ModuleASSiteConfig) getModule(ModuleASSiteConfig.MODULE_ID);
	}

	@Override
	public void moduleLoaded(Module module){
		firePersistenceChangedEvent();
	}

	@Override
	public List<FilteredIP> getFilteredIPs(){
		List<FilteredIP> filteredips = new ArrayList<>();
		filteredips.addAll(_getModuleASSiteConfig().getFilteredIPs());
		return filteredips;
	}

	@Override
	public List<FilteredIP> getFilteredIPs(SortType sortType){
		return StaticQuickSorter.sort(getFilteredIPs(), sortType);
	}

	/**
	 * Returns the FilteredIP objects with the specified ids.
	 */
	public List<FilteredIP> getFilteredIPs(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<FilteredIP> all = getFilteredIPs();
		List<FilteredIP> ret = new ArrayList<>();
		for (FilteredIP filteredip : all){
			if(ids.contains(filteredip.getId())){
				ret.add(filteredip);
			}
		}
		return ret;
	}

	/**
	 * Returns the FilteredIP objects with the specified ids, sorted by given sorttype.
	 */
	public List<FilteredIP> getFilteredIPs(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getFilteredIPs(ids), sortType);
	}

	@Override
	public void deleteFilteredIP(FilteredIP filteredip){
		deleteFilteredIP(filteredip.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(filteredip);
		}
	}

	@Override
	public void deleteFilteredIP(String id){
		ModuleASSiteConfig module = _getModuleASSiteConfig();
		FilteredIP varValue = hasServiceListeners()?module.getFilteredIP(id):null;
		module.deleteFilteredIP(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteFilteredIPs(List<FilteredIP> list){
		ModuleASSiteConfig module = _getModuleASSiteConfig();
		for (FilteredIP filteredip : list){
			module.deleteFilteredIP(filteredip.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public FilteredIP getFilteredIP(String id){
		return _getModuleASSiteConfig().getFilteredIP(id);
	}

	@Override
	public FilteredIP importFilteredIP(FilteredIP filteredip){
		ModuleASSiteConfig module = _getModuleASSiteConfig();
		module.importFilteredIP((FilteredIPDocument)filteredip);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(filteredip);
		}
		return filteredip;
	}

	@Override
	public List<FilteredIP> importFilteredIPs(List<FilteredIP> list){
		ModuleASSiteConfig module = _getModuleASSiteConfig();
		List<FilteredIP> ret = new ArrayList<>();
		for (FilteredIP filteredip : list){
			FilteredIP imported = module.importFilteredIP((FilteredIPDocument)filteredip);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (FilteredIP filteredip : ret)
				fireObjectImportedEvent(filteredip);
		}
		return ret;
	}

	@Override
	public FilteredIP createFilteredIP(FilteredIP filteredip){
		ModuleASSiteConfig module = _getModuleASSiteConfig();
		module.createFilteredIP((FilteredIPDocument)filteredip);
		updateModule(module);
		fireObjectCreatedEvent(filteredip);
		return filteredip;
	}

	@Override
	/**
	 * Creates multiple new FilteredIP objects.
	 * Returns the created versions.
	 */
	public List<FilteredIP> createFilteredIPs(List<FilteredIP> list){
		ModuleASSiteConfig module = _getModuleASSiteConfig();
		List<FilteredIP> ret = new ArrayList<>();
		for (FilteredIP filteredip : list){
			FilteredIP created = module.createFilteredIP((FilteredIPDocument)filteredip);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (FilteredIP filteredip : ret)
				fireObjectCreatedEvent(filteredip);
		}
		return ret;
	}

	@Override
	public FilteredIP updateFilteredIP(FilteredIP filteredip){
		FilteredIP oldVersion = null;
		ModuleASSiteConfig module = _getModuleASSiteConfig();
		if (hasServiceListeners())
			oldVersion = module.getFilteredIP(filteredip.getId());
		module.updateFilteredIP((FilteredIPDocument)filteredip);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, filteredip);
		}
		return filteredip;
	}

	@Override
	public List<FilteredIP> updateFilteredIPs(List<FilteredIP> list){
		List<FilteredIP> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASSiteConfig module = _getModuleASSiteConfig();
		for (FilteredIP filteredip : list){
			if (oldList!=null)
				oldList.add(module.getFilteredIP(filteredip.getId()));
			module.updateFilteredIP((FilteredIPDocument)filteredip);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<FilteredIP> getFilteredIPsByProperty(String propertyName, Object value){
		List<FilteredIP> allFilteredIPs = getFilteredIPs();
		List<FilteredIP> ret = new ArrayList<>();
		for (int i=0; i<allFilteredIPs.size(); i++){
			FilteredIP filteredip = allFilteredIPs.get(i);
			try{
				Property property = ((FilteredIPDocument)filteredip).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(filteredip);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(filteredip);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(filteredip);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<FilteredIP> getFilteredIPsByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getFilteredIPsByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on FilteredIPs
	 */
	public QueryResult executeQueryOnFilteredIPs(DocumentQuery query){
		List<FilteredIP> allFilteredIPs = getFilteredIPs();
		QueryResult result = new QueryResult();
		for (int i=0; i<allFilteredIPs.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allFilteredIPs.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all FilteredIP objects, where property matches.
	 */
	public List<FilteredIP> getFilteredIPsByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<FilteredIP> ret = new ArrayList<>();
		List<FilteredIP> src = getFilteredIPs();
		for ( FilteredIP filteredip : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(filteredip.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(filteredip);
		}
		return ret;
	}

	/**
	 * Returns all FilteredIP objects, where property matches, sorted
	 */
	public List<FilteredIP> getFilteredIPsByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getFilteredIPsByProperty(property), sortType);
	}

	/**
	 * Returns FilteredIP objects count.
	 */
	public int getFilteredIPsCount() {
		return _getModuleASSiteConfig().getFilteredIPs().size();
	}

	/**
	 * Returns FilteredIP objects segment.
	 */
	public List<FilteredIP> getFilteredIPs(Segment aSegment) {
		return Slicer.slice(aSegment, getFilteredIPs()).getSliceData();
	}

	/**
	 * Returns FilteredIP objects segment, where property matched.
	 */
	public List<FilteredIP> getFilteredIPsByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<FilteredIP> ret = new ArrayList<>();
		List<FilteredIP> src = getFilteredIPs();
		for (FilteredIP filteredip : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(filteredip.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(filteredip);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns FilteredIP objects segment, where property matched, sorted.
	 */
	public List<FilteredIP> getFilteredIPsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getFilteredIPsByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchFilteredIP(final String id, Set<String> addedDocuments, JSONArray data) throws ASSiteConfigServiceException {
		if (id.isEmpty() || addedDocuments.contains("FilteredIP" + id))
			return;

		try {
			final FilteredIPDocument filteredip = _getModuleASSiteConfig().getFilteredIP(id);
			addedDocuments.add("FilteredIP" + id);



			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(filteredip);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASSiteConfig");
			dataObject.put("document", "ASSiteConfig_FilteredIP");

			data.put(dataObject);

		}catch(IOException e){
			throw new ASSiteConfigServiceException ("Problem with fetching data for this FilteredIP instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASSiteConfigServiceException ("Problem with fetching data for this FilteredIP instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredFilteredIP(final JSONObject data) throws ASSiteConfigServiceException {
		try {
			String objectData = data.getString("object");
			FilteredIP filteredip = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), FilteredIPDocument.class);

			try {
				updateFilteredIP(filteredip);
			}catch(Exception e){
				importFilteredIP(filteredip);
			}
		}catch(JSONException e){
			throw new ASSiteConfigServiceException("Problem with getting data from json FilteredIP instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASSiteConfigServiceException("Problem with parsing data for this FilteredIP instance :" + e.getMessage());
		}
	}

	public void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws ASSiteConfigServiceException {
		switch(documentName) {
			case DOCUMENT_ASSITECONFIG_FILTEREDIP:
				saveTransferredFilteredIP(data);
				break;
			default:
				log.info("There is no correct document: " + documentName + "in this service");
				throw new ASSiteConfigServiceException("No such document");
		}
	}

	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service
	 */
	public QueryResult executeQueryOnAllObjects(DocumentQuery query){
		QueryResult ret = new QueryResult();
		ret.add(executeQueryOnFilteredIPs(query).getEntries());
		return ret;
	} //executeQueryOnAllObjects


	public XMLNode exportFilteredIPsToXML(){
		XMLNode ret = new XMLNode("FilteredIPs");
		List<FilteredIP> list = getFilteredIPs();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (FilteredIP object : list)
			ret.addChildNode(FilteredIPXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportFilteredIPsToXML(List<FilteredIP> list){
		XMLNode ret = new XMLNode("FilteredIPs");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (FilteredIP object : list)
			ret.addChildNode(FilteredIPXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportToXML(){
		XMLNode ret = new XMLNode("ASSiteConfig");

		ret.addChildNode(exportFilteredIPsToXML());

		return ret;
	}
}
