/**
 ********************************************************************************
 *** MultiOpDialogFilteredIPsAction.java                                      ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assiteconfig.action;

import net.anotheria.util.NumberUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.assiteconfig.data.FilteredIPFactory;
import net.anotheria.anosite.gen.assiteconfig.data.FilteredIP;
import net.anotheria.anosite.gen.assiteconfig.bean.EditFilteredIPFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;

public class MultiOpDialogFilteredIPsAction extends BaseFilteredIPAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("assiteconfigFilteredIPDelete"))
			return assiteconfigFilteredIPDelete(mapping, req, res);
		if (path.equals("assiteconfigFilteredIPDuplicate"))
			return assiteconfigFilteredIPDuplicate(mapping, req, res);
		if (path.equals("assiteconfigFilteredIPUpdate"))
			return assiteconfigFilteredIPUpdate(mapping, req, res);
		if (path.equals("assiteconfigFilteredIPClose"))
			return assiteconfigFilteredIPClose(mapping, req, res);
		if (path.equals("assiteconfigFilteredIPLock"))
			return assiteconfigFilteredIPLock(mapping, req, res);
		if (path.equals("assiteconfigFilteredIPUnLock"))
			return assiteconfigFilteredIPUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand assiteconfigFilteredIPDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			FilteredIP filteredipCurr = getASSiteConfigService().getFilteredIP(id);
			if (filteredipCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)filteredipCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASSiteConfigService().deleteFilteredIP(id);
		}
		res.sendRedirect("assiteconfigFilteredIPShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand assiteconfigFilteredIPDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		FilteredIP filteredipSrc = getASSiteConfigService().getFilteredIP(id);
		FilteredIP filteredipDest = FilteredIPFactory.createFilteredIP(filteredipSrc);


		FilteredIP filteredipCreated = getASSiteConfigService().createFilteredIP(filteredipDest);
		res.sendRedirect("assiteconfigFilteredIPEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+filteredipCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand assiteconfigFilteredIPUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditFilteredIPFB form = new EditFilteredIPFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		FilteredIP filteredip = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		filteredip = (FilteredIP)getASSiteConfigService().getFilteredIP(form.getId()).clone();
	}else{
		filteredip = FilteredIPFactory.createFilteredIP();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	filteredip.setIpAddress(form.getIpAddress());
	filteredip.setMask(form.getMask());
	filteredip.setAllowance(form.getAllowance());

	FilteredIP updatedCopy = null;
	if (create){
		updatedCopy = getASSiteConfigService().createFilteredIP(filteredip);
	}else{
		canUpdateFilteredIPs(filteredip, req);
		checkFilteredIPs(filteredip, req);
		updatedCopy = getASSiteConfigService().updateFilteredIP(filteredip);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("assiteconfigFilteredIPEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(filteredip, req);
		res.sendRedirect("assiteconfigFilteredIPShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(FilteredIP filteredip, HttpServletRequest req) throws Exception{
	if(((LockableObject)filteredip).isLocked())
		unLockFilteredIPs(filteredip, req, false);
}

public ActionCommand assiteconfigFilteredIPLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	FilteredIP filteredipCurr = id != null && !id.equals("") ? getASSiteConfigService().getFilteredIP(id) : null;
	if(filteredipCurr != null && filteredipCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)filteredipCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockFilteredIPs(filteredipCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, filteredipCurr));
	return null;
}

public ActionCommand assiteconfigFilteredIPUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	FilteredIP filteredipCurr = id != null && !id.equals("") ? getASSiteConfigService().getFilteredIP(id) : null;
	if(filteredipCurr != null && filteredipCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)filteredipCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockFilteredIPs(filteredipCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, filteredipCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, FilteredIP item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "assiteconfigFilteredIPShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "assiteconfigFilteredIPEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "assiteconfigFilteredIPShow?ts="+System.currentTimeMillis();
}

public ActionCommand assiteconfigFilteredIPClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	FilteredIP filteredipCurr = id != null && !id.equals("") ? getASSiteConfigService().getFilteredIP(id) : null;
	if(filteredipCurr != null && filteredipCurr instanceof LockableObject && ((LockableObject)filteredipCurr).isLocked()) 
		unLockFilteredIPs(filteredipCurr, req, false);
	res.sendRedirect("assiteconfigFilteredIPShow?ts="+System.currentTimeMillis());
	return null;
}

}
