/**
 ********************************************************************************
 *** ASResourceDataServiceFixtureImpl.java                                    ***
 *** The implementation of the IASResourceDataService for unit testing.       ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.service.fixture;

import java.util.List;
import java.util.Set;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.sorter.StaticQuickSorter;
import net.anotheria.util.slicer.Segment;
import net.anotheria.util.slicer.Slicer;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryResultEntry;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.xml.XMLAttribute;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.anosite.gen.asresourcedata.service.IASResourceDataService;
import net.anotheria.anosite.gen.asresourcedata.service.ASResourceDataServiceException;
import net.anotheria.asg.service.BaseFixtureService;
import net.anotheria.asg.service.IFixtureService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.ArrayList;
import net.anotheria.anosite.gen.asresourcedata.data.TextResource;
import net.anotheria.anosite.gen.asresourcedata.data.TextResourceXMLHelper;
import net.anotheria.anosite.gen.asresourcedata.data.TextResourceDocument;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundle;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundleXMLHelper;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundleDocument;
import net.anotheria.anosite.gen.asresourcedata.data.MailTemplate;
import net.anotheria.anosite.gen.asresourcedata.data.MailTemplateXMLHelper;
import net.anotheria.anosite.gen.asresourcedata.data.MailTemplateDocument;
import net.anotheria.anosite.gen.asresourcedata.data.PdfTemplate;
import net.anotheria.anosite.gen.asresourcedata.data.PdfTemplateXMLHelper;
import net.anotheria.anosite.gen.asresourcedata.data.PdfTemplateDocument;
import net.anotheria.anosite.gen.asresourcedata.data.PushNotificationTemplate;
import net.anotheria.anosite.gen.asresourcedata.data.PushNotificationTemplateXMLHelper;
import net.anotheria.anosite.gen.asresourcedata.data.PushNotificationTemplateDocument;
import net.anotheria.anosite.gen.asresourcedata.data.Image;
import net.anotheria.anosite.gen.asresourcedata.data.ImageXMLHelper;
import net.anotheria.anosite.gen.asresourcedata.data.ImageDocument;
import net.anotheria.anosite.gen.asresourcedata.data.FileLink;
import net.anotheria.anosite.gen.asresourcedata.data.FileLinkXMLHelper;
import net.anotheria.anosite.gen.asresourcedata.data.FileLinkDocument;

public class ASResourceDataServiceFixtureImpl extends BaseFixtureService implements IASResourceDataService, IFixtureService{

	private static ASResourceDataServiceFixtureImpl instance;

	private Map<String, TextResource> textresourceMap;
	private AtomicInteger textresourceIdHolder;

	private Map<String, LocalizationBundle> localizationbundleMap;
	private AtomicInteger localizationbundleIdHolder;

	private Map<String, MailTemplate> mailtemplateMap;
	private AtomicInteger mailtemplateIdHolder;

	private Map<String, PdfTemplate> pdftemplateMap;
	private AtomicInteger pdftemplateIdHolder;

	private Map<String, PushNotificationTemplate> pushnotificationtemplateMap;
	private AtomicInteger pushnotificationtemplateIdHolder;

	private Map<String, Image> imageMap;
	private AtomicInteger imageIdHolder;

	private Map<String, FileLink> filelinkMap;
	private AtomicInteger filelinkIdHolder;

	private ASResourceDataServiceFixtureImpl(){
		reset();
		addServiceListener(new net.anotheria.anosite.cms.listener.CRUDLogListener());
		addServiceListener(new net.anotheria.anosite.cms.listener.AsResourceListener());
	}

	static final ASResourceDataServiceFixtureImpl getInstance(){
		if (instance==null){
			instance = new ASResourceDataServiceFixtureImpl();
		}
		return instance;
	}

	@Override public void reset(){
		textresourceMap = new ConcurrentHashMap<String, TextResource>();
		textresourceIdHolder = new AtomicInteger(0);

		localizationbundleMap = new ConcurrentHashMap<String, LocalizationBundle>();
		localizationbundleIdHolder = new AtomicInteger(0);

		mailtemplateMap = new ConcurrentHashMap<String, MailTemplate>();
		mailtemplateIdHolder = new AtomicInteger(0);

		pdftemplateMap = new ConcurrentHashMap<String, PdfTemplate>();
		pdftemplateIdHolder = new AtomicInteger(0);

		pushnotificationtemplateMap = new ConcurrentHashMap<String, PushNotificationTemplate>();
		pushnotificationtemplateIdHolder = new AtomicInteger(0);

		imageMap = new ConcurrentHashMap<String, Image>();
		imageIdHolder = new AtomicInteger(0);

		filelinkMap = new ConcurrentHashMap<String, FileLink>();
		filelinkIdHolder = new AtomicInteger(0);

	}

	@Override public List<TextResource> getTextResources() throws ASResourceDataServiceException {
		List<TextResource> ret = new ArrayList<TextResource>();
		ret.addAll(textresourceMap.values());
		return ret;
	}

	@Override public List<TextResource> getTextResources(SortType sortType) throws ASResourceDataServiceException {
		return StaticQuickSorter.sort(getTextResources(), sortType);
	}

	@Override public void deleteTextResource(TextResource textresource) throws ASResourceDataServiceException {
		deleteTextResource(textresource.getId());
	}

	@Override public void deleteTextResource(String id) throws ASResourceDataServiceException {
		TextResource old = textresourceMap.remove(id);
		if (old!=null){
			fireObjectDeletedEvent(old);
		}
	}

	/**
	 * Deletes multiple TextResource objects.
	 */
	@Override public void deleteTextResources(List<TextResource> list) throws ASResourceDataServiceException {
		for (TextResource textresource : list){
			deleteTextResource(textresource);
		}
	}

	@Override public TextResource getTextResource(String id) throws ASResourceDataServiceException {
		TextResource textresource = textresourceMap.get(id);
		if (textresource==null)
			throw new ASResourceDataServiceException("No TextResource with id "+id+" found");
		return textresource;
	}

	@Override public TextResource importTextResource(TextResource textresource) throws ASResourceDataServiceException {
		textresourceMap.put(textresource.getId(), textresource);
		return textresource;
	}

	@Override public List<TextResource> importTextResources(List<TextResource> list) throws ASResourceDataServiceException {
		List<TextResource> ret = new ArrayList<TextResource>();
		for (TextResource textresource : list)
			ret.add(importTextResource(textresource));
		return ret;
	}

	@Override public TextResource createTextResource(TextResource textresource) throws ASResourceDataServiceException {
		String nextId = ""+textresourceIdHolder.incrementAndGet();
		// //CMS Specific code
		TextResourceDocument newTextresource = (TextResourceDocument)textresource;
		newTextresource.renameTo(nextId);
		textresourceMap.put(newTextresource.getId(), newTextresource);
		fireObjectCreatedEvent(newTextresource);
		return newTextresource;
	}

	/**
	 * Creates multiple new TextResource objects.
	 * Returns the created versions.
	 */
	@Override public List<TextResource> createTextResources(List<TextResource> list) throws ASResourceDataServiceException {
		List<TextResource> ret = new ArrayList<TextResource>();
		for (TextResource textresource : list)
			ret.add(createTextResource(textresource));
		return ret;
	}

	/**
	 * Updates multiple new TextResource objects.
	 * Returns the updated versions.
	 */
	@Override public List<TextResource> updateTextResources(List<TextResource> list) throws ASResourceDataServiceException {
		List<TextResource> ret = new ArrayList<TextResource>();
		for (TextResource textresource : list)
			ret.add(updateTextResource(textresource));
		return ret;
	}

	@Override public TextResource updateTextResource(TextResource textresource) throws ASResourceDataServiceException {
		TextResource oldVersion = textresourceMap.put(textresource.getId(), textresource);
		if (oldVersion!=null){
				fireObjectUpdatedEvent(oldVersion, textresource);
		}
		return textresource;
	}

	@Override public List<TextResource> getTextResourcesByProperty(String propertyName, Object value) throws ASResourceDataServiceException {
		List<TextResource> list = getTextResources();
		List<TextResource> ret = new ArrayList<TextResource>();
		for (TextResource textresource : list){
			Object propertyValue = textresource.getPropertyValue(propertyName);
			if (propertyValue!=null && propertyValue.equals(value))
				ret.add(textresource);
		}
		return ret;
	}

	@Override public List<TextResource> getTextResourcesByProperty(String propertyName, Object value, SortType sortType) throws ASResourceDataServiceException {
		return StaticQuickSorter.sort(getTextResourcesByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on TextResources
	 */
	@Override public QueryResult executeQueryOnTextResources(DocumentQuery query) throws ASResourceDataServiceException {
		List<TextResource> allTextResources = getTextResources();
		QueryResult result = new QueryResult();
		for (int i=0; i<allTextResources.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allTextResources.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all TextResource objects, where property matches.
	 */
	@Override public List<TextResource> getTextResourcesByProperty(QueryProperty... properties) throws ASResourceDataServiceException {
		List<TextResource> list = getTextResources();
		if (properties==null || properties.length==0)
			return list;
		List<TextResource> ret = new ArrayList<TextResource>();
		for (TextResource textresource : list){
			boolean mayPass = true;
			for (QueryProperty p : properties){
				Object propertyValue = textresource.getPropertyValue(p.getName());
				if (mayPass && (propertyValue==null || (!(p.doesMatch(propertyValue)))))
					mayPass = false;
			}
			if (mayPass)
				ret.add(textresource);
		}
		return ret;
	}

	/**
	 * Returns all TextResource objects, where property matches, sorted
	 */
	@Override public List<TextResource> getTextResourcesByProperty(SortType sortType, QueryProperty... property) throws ASResourceDataServiceException {
		return StaticQuickSorter.sort(getTextResourcesByProperty(property), sortType);
	}

	/**
	 * Returns TextResource objects count.
	 */
	@Override public int getTextResourcesCount() throws ASResourceDataServiceException {
		return textresourceMap.values().size();
	}

	/**
	 * Returns TextResource objects segment.
	 */
	public List<TextResource> getTextResources(Segment aSegment) throws ASResourceDataServiceException {
		return Slicer.slice(aSegment, getTextResources()).getSliceData();
	}

	/**
	 * Returns TextResource objects segment, where property matched.
	 */
	public List<TextResource> getTextResourcesByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<TextResource> ret = new ArrayList<>();
		List<TextResource> src = new ArrayList<>();
		src.addAll(textresourceMap.values());
		for (TextResource textresource : src) {;
			boolean mayPass = true;
			for (QueryProperty qp : property) {;
				mayPass = mayPass && qp.doesMatch(textresource.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(textresource);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns TextResource objects segment, where property matched, sorted.
	 */
	public List<TextResource> getTextResourcesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getTextResourcesByProperty(aSegment, aProperty), aSortType);
	}

	@Override public List<LocalizationBundle> getLocalizationBundles() throws ASResourceDataServiceException {
		List<LocalizationBundle> ret = new ArrayList<LocalizationBundle>();
		ret.addAll(localizationbundleMap.values());
		return ret;
	}

	@Override public List<LocalizationBundle> getLocalizationBundles(SortType sortType) throws ASResourceDataServiceException {
		return StaticQuickSorter.sort(getLocalizationBundles(), sortType);
	}

	@Override public void deleteLocalizationBundle(LocalizationBundle localizationbundle) throws ASResourceDataServiceException {
		deleteLocalizationBundle(localizationbundle.getId());
	}

	@Override public void deleteLocalizationBundle(String id) throws ASResourceDataServiceException {
		LocalizationBundle old = localizationbundleMap.remove(id);
		if (old!=null){
			fireObjectDeletedEvent(old);
		}
	}

	/**
	 * Deletes multiple LocalizationBundle objects.
	 */
	@Override public void deleteLocalizationBundles(List<LocalizationBundle> list) throws ASResourceDataServiceException {
		for (LocalizationBundle localizationbundle : list){
			deleteLocalizationBundle(localizationbundle);
		}
	}

	@Override public LocalizationBundle getLocalizationBundle(String id) throws ASResourceDataServiceException {
		LocalizationBundle localizationbundle = localizationbundleMap.get(id);
		if (localizationbundle==null)
			throw new ASResourceDataServiceException("No LocalizationBundle with id "+id+" found");
		return localizationbundle;
	}

	@Override public LocalizationBundle importLocalizationBundle(LocalizationBundle localizationbundle) throws ASResourceDataServiceException {
		localizationbundleMap.put(localizationbundle.getId(), localizationbundle);
		return localizationbundle;
	}

	@Override public List<LocalizationBundle> importLocalizationBundles(List<LocalizationBundle> list) throws ASResourceDataServiceException {
		List<LocalizationBundle> ret = new ArrayList<LocalizationBundle>();
		for (LocalizationBundle localizationbundle : list)
			ret.add(importLocalizationBundle(localizationbundle));
		return ret;
	}

	@Override public LocalizationBundle createLocalizationBundle(LocalizationBundle localizationbundle) throws ASResourceDataServiceException {
		String nextId = ""+localizationbundleIdHolder.incrementAndGet();
		// //CMS Specific code
		LocalizationBundleDocument newLocalizationbundle = (LocalizationBundleDocument)localizationbundle;
		newLocalizationbundle.renameTo(nextId);
		localizationbundleMap.put(newLocalizationbundle.getId(), newLocalizationbundle);
		fireObjectCreatedEvent(newLocalizationbundle);
		return newLocalizationbundle;
	}

	/**
	 * Creates multiple new LocalizationBundle objects.
	 * Returns the created versions.
	 */
	@Override public List<LocalizationBundle> createLocalizationBundles(List<LocalizationBundle> list) throws ASResourceDataServiceException {
		List<LocalizationBundle> ret = new ArrayList<LocalizationBundle>();
		for (LocalizationBundle localizationbundle : list)
			ret.add(createLocalizationBundle(localizationbundle));
		return ret;
	}

	/**
	 * Updates multiple new LocalizationBundle objects.
	 * Returns the updated versions.
	 */
	@Override public List<LocalizationBundle> updateLocalizationBundles(List<LocalizationBundle> list) throws ASResourceDataServiceException {
		List<LocalizationBundle> ret = new ArrayList<LocalizationBundle>();
		for (LocalizationBundle localizationbundle : list)
			ret.add(updateLocalizationBundle(localizationbundle));
		return ret;
	}

	@Override public LocalizationBundle updateLocalizationBundle(LocalizationBundle localizationbundle) throws ASResourceDataServiceException {
		LocalizationBundle oldVersion = localizationbundleMap.put(localizationbundle.getId(), localizationbundle);
		if (oldVersion!=null){
				fireObjectUpdatedEvent(oldVersion, localizationbundle);
		}
		return localizationbundle;
	}

	@Override public List<LocalizationBundle> getLocalizationBundlesByProperty(String propertyName, Object value) throws ASResourceDataServiceException {
		List<LocalizationBundle> list = getLocalizationBundles();
		List<LocalizationBundle> ret = new ArrayList<LocalizationBundle>();
		for (LocalizationBundle localizationbundle : list){
			Object propertyValue = localizationbundle.getPropertyValue(propertyName);
			if (propertyValue!=null && propertyValue.equals(value))
				ret.add(localizationbundle);
		}
		return ret;
	}

	@Override public List<LocalizationBundle> getLocalizationBundlesByProperty(String propertyName, Object value, SortType sortType) throws ASResourceDataServiceException {
		return StaticQuickSorter.sort(getLocalizationBundlesByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on LocalizationBundles
	 */
	@Override public QueryResult executeQueryOnLocalizationBundles(DocumentQuery query) throws ASResourceDataServiceException {
		List<LocalizationBundle> allLocalizationBundles = getLocalizationBundles();
		QueryResult result = new QueryResult();
		for (int i=0; i<allLocalizationBundles.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allLocalizationBundles.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all LocalizationBundle objects, where property matches.
	 */
	@Override public List<LocalizationBundle> getLocalizationBundlesByProperty(QueryProperty... properties) throws ASResourceDataServiceException {
		List<LocalizationBundle> list = getLocalizationBundles();
		if (properties==null || properties.length==0)
			return list;
		List<LocalizationBundle> ret = new ArrayList<LocalizationBundle>();
		for (LocalizationBundle localizationbundle : list){
			boolean mayPass = true;
			for (QueryProperty p : properties){
				Object propertyValue = localizationbundle.getPropertyValue(p.getName());
				if (mayPass && (propertyValue==null || (!(p.doesMatch(propertyValue)))))
					mayPass = false;
			}
			if (mayPass)
				ret.add(localizationbundle);
		}
		return ret;
	}

	/**
	 * Returns all LocalizationBundle objects, where property matches, sorted
	 */
	@Override public List<LocalizationBundle> getLocalizationBundlesByProperty(SortType sortType, QueryProperty... property) throws ASResourceDataServiceException {
		return StaticQuickSorter.sort(getLocalizationBundlesByProperty(property), sortType);
	}

	/**
	 * Returns LocalizationBundle objects count.
	 */
	@Override public int getLocalizationBundlesCount() throws ASResourceDataServiceException {
		return localizationbundleMap.values().size();
	}

	/**
	 * Returns LocalizationBundle objects segment.
	 */
	public List<LocalizationBundle> getLocalizationBundles(Segment aSegment) throws ASResourceDataServiceException {
		return Slicer.slice(aSegment, getLocalizationBundles()).getSliceData();
	}

	/**
	 * Returns LocalizationBundle objects segment, where property matched.
	 */
	public List<LocalizationBundle> getLocalizationBundlesByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<LocalizationBundle> ret = new ArrayList<>();
		List<LocalizationBundle> src = new ArrayList<>();
		src.addAll(localizationbundleMap.values());
		for (LocalizationBundle localizationbundle : src) {;
			boolean mayPass = true;
			for (QueryProperty qp : property) {;
				mayPass = mayPass && qp.doesMatch(localizationbundle.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(localizationbundle);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns LocalizationBundle objects segment, where property matched, sorted.
	 */
	public List<LocalizationBundle> getLocalizationBundlesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getLocalizationBundlesByProperty(aSegment, aProperty), aSortType);
	}

	@Override public List<MailTemplate> getMailTemplates() throws ASResourceDataServiceException {
		List<MailTemplate> ret = new ArrayList<MailTemplate>();
		ret.addAll(mailtemplateMap.values());
		return ret;
	}

	@Override public List<MailTemplate> getMailTemplates(SortType sortType) throws ASResourceDataServiceException {
		return StaticQuickSorter.sort(getMailTemplates(), sortType);
	}

	@Override public void deleteMailTemplate(MailTemplate mailtemplate) throws ASResourceDataServiceException {
		deleteMailTemplate(mailtemplate.getId());
	}

	@Override public void deleteMailTemplate(String id) throws ASResourceDataServiceException {
		MailTemplate old = mailtemplateMap.remove(id);
		if (old!=null){
			fireObjectDeletedEvent(old);
		}
	}

	/**
	 * Deletes multiple MailTemplate objects.
	 */
	@Override public void deleteMailTemplates(List<MailTemplate> list) throws ASResourceDataServiceException {
		for (MailTemplate mailtemplate : list){
			deleteMailTemplate(mailtemplate);
		}
	}

	@Override public MailTemplate getMailTemplate(String id) throws ASResourceDataServiceException {
		MailTemplate mailtemplate = mailtemplateMap.get(id);
		if (mailtemplate==null)
			throw new ASResourceDataServiceException("No MailTemplate with id "+id+" found");
		return mailtemplate;
	}

	@Override public MailTemplate importMailTemplate(MailTemplate mailtemplate) throws ASResourceDataServiceException {
		mailtemplateMap.put(mailtemplate.getId(), mailtemplate);
		return mailtemplate;
	}

	@Override public List<MailTemplate> importMailTemplates(List<MailTemplate> list) throws ASResourceDataServiceException {
		List<MailTemplate> ret = new ArrayList<MailTemplate>();
		for (MailTemplate mailtemplate : list)
			ret.add(importMailTemplate(mailtemplate));
		return ret;
	}

	@Override public MailTemplate createMailTemplate(MailTemplate mailtemplate) throws ASResourceDataServiceException {
		String nextId = ""+mailtemplateIdHolder.incrementAndGet();
		// //CMS Specific code
		MailTemplateDocument newMailtemplate = (MailTemplateDocument)mailtemplate;
		newMailtemplate.renameTo(nextId);
		mailtemplateMap.put(newMailtemplate.getId(), newMailtemplate);
		fireObjectCreatedEvent(newMailtemplate);
		return newMailtemplate;
	}

	/**
	 * Creates multiple new MailTemplate objects.
	 * Returns the created versions.
	 */
	@Override public List<MailTemplate> createMailTemplates(List<MailTemplate> list) throws ASResourceDataServiceException {
		List<MailTemplate> ret = new ArrayList<MailTemplate>();
		for (MailTemplate mailtemplate : list)
			ret.add(createMailTemplate(mailtemplate));
		return ret;
	}

	/**
	 * Updates multiple new MailTemplate objects.
	 * Returns the updated versions.
	 */
	@Override public List<MailTemplate> updateMailTemplates(List<MailTemplate> list) throws ASResourceDataServiceException {
		List<MailTemplate> ret = new ArrayList<MailTemplate>();
		for (MailTemplate mailtemplate : list)
			ret.add(updateMailTemplate(mailtemplate));
		return ret;
	}

	@Override public MailTemplate updateMailTemplate(MailTemplate mailtemplate) throws ASResourceDataServiceException {
		MailTemplate oldVersion = mailtemplateMap.put(mailtemplate.getId(), mailtemplate);
		if (oldVersion!=null){
				fireObjectUpdatedEvent(oldVersion, mailtemplate);
		}
		return mailtemplate;
	}

	@Override public List<MailTemplate> getMailTemplatesByProperty(String propertyName, Object value) throws ASResourceDataServiceException {
		List<MailTemplate> list = getMailTemplates();
		List<MailTemplate> ret = new ArrayList<MailTemplate>();
		for (MailTemplate mailtemplate : list){
			Object propertyValue = mailtemplate.getPropertyValue(propertyName);
			if (propertyValue!=null && propertyValue.equals(value))
				ret.add(mailtemplate);
		}
		return ret;
	}

	@Override public List<MailTemplate> getMailTemplatesByProperty(String propertyName, Object value, SortType sortType) throws ASResourceDataServiceException {
		return StaticQuickSorter.sort(getMailTemplatesByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on MailTemplates
	 */
	@Override public QueryResult executeQueryOnMailTemplates(DocumentQuery query) throws ASResourceDataServiceException {
		List<MailTemplate> allMailTemplates = getMailTemplates();
		QueryResult result = new QueryResult();
		for (int i=0; i<allMailTemplates.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allMailTemplates.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all MailTemplate objects, where property matches.
	 */
	@Override public List<MailTemplate> getMailTemplatesByProperty(QueryProperty... properties) throws ASResourceDataServiceException {
		List<MailTemplate> list = getMailTemplates();
		if (properties==null || properties.length==0)
			return list;
		List<MailTemplate> ret = new ArrayList<MailTemplate>();
		for (MailTemplate mailtemplate : list){
			boolean mayPass = true;
			for (QueryProperty p : properties){
				Object propertyValue = mailtemplate.getPropertyValue(p.getName());
				if (mayPass && (propertyValue==null || (!(p.doesMatch(propertyValue)))))
					mayPass = false;
			}
			if (mayPass)
				ret.add(mailtemplate);
		}
		return ret;
	}

	/**
	 * Returns all MailTemplate objects, where property matches, sorted
	 */
	@Override public List<MailTemplate> getMailTemplatesByProperty(SortType sortType, QueryProperty... property) throws ASResourceDataServiceException {
		return StaticQuickSorter.sort(getMailTemplatesByProperty(property), sortType);
	}

	/**
	 * Returns MailTemplate objects count.
	 */
	@Override public int getMailTemplatesCount() throws ASResourceDataServiceException {
		return mailtemplateMap.values().size();
	}

	/**
	 * Returns MailTemplate objects segment.
	 */
	public List<MailTemplate> getMailTemplates(Segment aSegment) throws ASResourceDataServiceException {
		return Slicer.slice(aSegment, getMailTemplates()).getSliceData();
	}

	/**
	 * Returns MailTemplate objects segment, where property matched.
	 */
	public List<MailTemplate> getMailTemplatesByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<MailTemplate> ret = new ArrayList<>();
		List<MailTemplate> src = new ArrayList<>();
		src.addAll(mailtemplateMap.values());
		for (MailTemplate mailtemplate : src) {;
			boolean mayPass = true;
			for (QueryProperty qp : property) {;
				mayPass = mayPass && qp.doesMatch(mailtemplate.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(mailtemplate);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns MailTemplate objects segment, where property matched, sorted.
	 */
	public List<MailTemplate> getMailTemplatesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getMailTemplatesByProperty(aSegment, aProperty), aSortType);
	}

	@Override public List<PdfTemplate> getPdfTemplates() throws ASResourceDataServiceException {
		List<PdfTemplate> ret = new ArrayList<PdfTemplate>();
		ret.addAll(pdftemplateMap.values());
		return ret;
	}

	@Override public List<PdfTemplate> getPdfTemplates(SortType sortType) throws ASResourceDataServiceException {
		return StaticQuickSorter.sort(getPdfTemplates(), sortType);
	}

	@Override public void deletePdfTemplate(PdfTemplate pdftemplate) throws ASResourceDataServiceException {
		deletePdfTemplate(pdftemplate.getId());
	}

	@Override public void deletePdfTemplate(String id) throws ASResourceDataServiceException {
		PdfTemplate old = pdftemplateMap.remove(id);
		if (old!=null){
			fireObjectDeletedEvent(old);
		}
	}

	/**
	 * Deletes multiple PdfTemplate objects.
	 */
	@Override public void deletePdfTemplates(List<PdfTemplate> list) throws ASResourceDataServiceException {
		for (PdfTemplate pdftemplate : list){
			deletePdfTemplate(pdftemplate);
		}
	}

	@Override public PdfTemplate getPdfTemplate(String id) throws ASResourceDataServiceException {
		PdfTemplate pdftemplate = pdftemplateMap.get(id);
		if (pdftemplate==null)
			throw new ASResourceDataServiceException("No PdfTemplate with id "+id+" found");
		return pdftemplate;
	}

	@Override public PdfTemplate importPdfTemplate(PdfTemplate pdftemplate) throws ASResourceDataServiceException {
		pdftemplateMap.put(pdftemplate.getId(), pdftemplate);
		return pdftemplate;
	}

	@Override public List<PdfTemplate> importPdfTemplates(List<PdfTemplate> list) throws ASResourceDataServiceException {
		List<PdfTemplate> ret = new ArrayList<PdfTemplate>();
		for (PdfTemplate pdftemplate : list)
			ret.add(importPdfTemplate(pdftemplate));
		return ret;
	}

	@Override public PdfTemplate createPdfTemplate(PdfTemplate pdftemplate) throws ASResourceDataServiceException {
		String nextId = ""+pdftemplateIdHolder.incrementAndGet();
		// //CMS Specific code
		PdfTemplateDocument newPdftemplate = (PdfTemplateDocument)pdftemplate;
		newPdftemplate.renameTo(nextId);
		pdftemplateMap.put(newPdftemplate.getId(), newPdftemplate);
		fireObjectCreatedEvent(newPdftemplate);
		return newPdftemplate;
	}

	/**
	 * Creates multiple new PdfTemplate objects.
	 * Returns the created versions.
	 */
	@Override public List<PdfTemplate> createPdfTemplates(List<PdfTemplate> list) throws ASResourceDataServiceException {
		List<PdfTemplate> ret = new ArrayList<PdfTemplate>();
		for (PdfTemplate pdftemplate : list)
			ret.add(createPdfTemplate(pdftemplate));
		return ret;
	}

	/**
	 * Updates multiple new PdfTemplate objects.
	 * Returns the updated versions.
	 */
	@Override public List<PdfTemplate> updatePdfTemplates(List<PdfTemplate> list) throws ASResourceDataServiceException {
		List<PdfTemplate> ret = new ArrayList<PdfTemplate>();
		for (PdfTemplate pdftemplate : list)
			ret.add(updatePdfTemplate(pdftemplate));
		return ret;
	}

	@Override public PdfTemplate updatePdfTemplate(PdfTemplate pdftemplate) throws ASResourceDataServiceException {
		PdfTemplate oldVersion = pdftemplateMap.put(pdftemplate.getId(), pdftemplate);
		if (oldVersion!=null){
				fireObjectUpdatedEvent(oldVersion, pdftemplate);
		}
		return pdftemplate;
	}

	@Override public List<PdfTemplate> getPdfTemplatesByProperty(String propertyName, Object value) throws ASResourceDataServiceException {
		List<PdfTemplate> list = getPdfTemplates();
		List<PdfTemplate> ret = new ArrayList<PdfTemplate>();
		for (PdfTemplate pdftemplate : list){
			Object propertyValue = pdftemplate.getPropertyValue(propertyName);
			if (propertyValue!=null && propertyValue.equals(value))
				ret.add(pdftemplate);
		}
		return ret;
	}

	@Override public List<PdfTemplate> getPdfTemplatesByProperty(String propertyName, Object value, SortType sortType) throws ASResourceDataServiceException {
		return StaticQuickSorter.sort(getPdfTemplatesByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on PdfTemplates
	 */
	@Override public QueryResult executeQueryOnPdfTemplates(DocumentQuery query) throws ASResourceDataServiceException {
		List<PdfTemplate> allPdfTemplates = getPdfTemplates();
		QueryResult result = new QueryResult();
		for (int i=0; i<allPdfTemplates.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allPdfTemplates.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all PdfTemplate objects, where property matches.
	 */
	@Override public List<PdfTemplate> getPdfTemplatesByProperty(QueryProperty... properties) throws ASResourceDataServiceException {
		List<PdfTemplate> list = getPdfTemplates();
		if (properties==null || properties.length==0)
			return list;
		List<PdfTemplate> ret = new ArrayList<PdfTemplate>();
		for (PdfTemplate pdftemplate : list){
			boolean mayPass = true;
			for (QueryProperty p : properties){
				Object propertyValue = pdftemplate.getPropertyValue(p.getName());
				if (mayPass && (propertyValue==null || (!(p.doesMatch(propertyValue)))))
					mayPass = false;
			}
			if (mayPass)
				ret.add(pdftemplate);
		}
		return ret;
	}

	/**
	 * Returns all PdfTemplate objects, where property matches, sorted
	 */
	@Override public List<PdfTemplate> getPdfTemplatesByProperty(SortType sortType, QueryProperty... property) throws ASResourceDataServiceException {
		return StaticQuickSorter.sort(getPdfTemplatesByProperty(property), sortType);
	}

	/**
	 * Returns PdfTemplate objects count.
	 */
	@Override public int getPdfTemplatesCount() throws ASResourceDataServiceException {
		return pdftemplateMap.values().size();
	}

	/**
	 * Returns PdfTemplate objects segment.
	 */
	public List<PdfTemplate> getPdfTemplates(Segment aSegment) throws ASResourceDataServiceException {
		return Slicer.slice(aSegment, getPdfTemplates()).getSliceData();
	}

	/**
	 * Returns PdfTemplate objects segment, where property matched.
	 */
	public List<PdfTemplate> getPdfTemplatesByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<PdfTemplate> ret = new ArrayList<>();
		List<PdfTemplate> src = new ArrayList<>();
		src.addAll(pdftemplateMap.values());
		for (PdfTemplate pdftemplate : src) {;
			boolean mayPass = true;
			for (QueryProperty qp : property) {;
				mayPass = mayPass && qp.doesMatch(pdftemplate.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(pdftemplate);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns PdfTemplate objects segment, where property matched, sorted.
	 */
	public List<PdfTemplate> getPdfTemplatesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getPdfTemplatesByProperty(aSegment, aProperty), aSortType);
	}

	@Override public List<PushNotificationTemplate> getPushNotificationTemplates() throws ASResourceDataServiceException {
		List<PushNotificationTemplate> ret = new ArrayList<PushNotificationTemplate>();
		ret.addAll(pushnotificationtemplateMap.values());
		return ret;
	}

	@Override public List<PushNotificationTemplate> getPushNotificationTemplates(SortType sortType) throws ASResourceDataServiceException {
		return StaticQuickSorter.sort(getPushNotificationTemplates(), sortType);
	}

	@Override public void deletePushNotificationTemplate(PushNotificationTemplate pushnotificationtemplate) throws ASResourceDataServiceException {
		deletePushNotificationTemplate(pushnotificationtemplate.getId());
	}

	@Override public void deletePushNotificationTemplate(String id) throws ASResourceDataServiceException {
		PushNotificationTemplate old = pushnotificationtemplateMap.remove(id);
		if (old!=null){
			fireObjectDeletedEvent(old);
		}
	}

	/**
	 * Deletes multiple PushNotificationTemplate objects.
	 */
	@Override public void deletePushNotificationTemplates(List<PushNotificationTemplate> list) throws ASResourceDataServiceException {
		for (PushNotificationTemplate pushnotificationtemplate : list){
			deletePushNotificationTemplate(pushnotificationtemplate);
		}
	}

	@Override public PushNotificationTemplate getPushNotificationTemplate(String id) throws ASResourceDataServiceException {
		PushNotificationTemplate pushnotificationtemplate = pushnotificationtemplateMap.get(id);
		if (pushnotificationtemplate==null)
			throw new ASResourceDataServiceException("No PushNotificationTemplate with id "+id+" found");
		return pushnotificationtemplate;
	}

	@Override public PushNotificationTemplate importPushNotificationTemplate(PushNotificationTemplate pushnotificationtemplate) throws ASResourceDataServiceException {
		pushnotificationtemplateMap.put(pushnotificationtemplate.getId(), pushnotificationtemplate);
		return pushnotificationtemplate;
	}

	@Override public List<PushNotificationTemplate> importPushNotificationTemplates(List<PushNotificationTemplate> list) throws ASResourceDataServiceException {
		List<PushNotificationTemplate> ret = new ArrayList<PushNotificationTemplate>();
		for (PushNotificationTemplate pushnotificationtemplate : list)
			ret.add(importPushNotificationTemplate(pushnotificationtemplate));
		return ret;
	}

	@Override public PushNotificationTemplate createPushNotificationTemplate(PushNotificationTemplate pushnotificationtemplate) throws ASResourceDataServiceException {
		String nextId = ""+pushnotificationtemplateIdHolder.incrementAndGet();
		// //CMS Specific code
		PushNotificationTemplateDocument newPushnotificationtemplate = (PushNotificationTemplateDocument)pushnotificationtemplate;
		newPushnotificationtemplate.renameTo(nextId);
		pushnotificationtemplateMap.put(newPushnotificationtemplate.getId(), newPushnotificationtemplate);
		fireObjectCreatedEvent(newPushnotificationtemplate);
		return newPushnotificationtemplate;
	}

	/**
	 * Creates multiple new PushNotificationTemplate objects.
	 * Returns the created versions.
	 */
	@Override public List<PushNotificationTemplate> createPushNotificationTemplates(List<PushNotificationTemplate> list) throws ASResourceDataServiceException {
		List<PushNotificationTemplate> ret = new ArrayList<PushNotificationTemplate>();
		for (PushNotificationTemplate pushnotificationtemplate : list)
			ret.add(createPushNotificationTemplate(pushnotificationtemplate));
		return ret;
	}

	/**
	 * Updates multiple new PushNotificationTemplate objects.
	 * Returns the updated versions.
	 */
	@Override public List<PushNotificationTemplate> updatePushNotificationTemplates(List<PushNotificationTemplate> list) throws ASResourceDataServiceException {
		List<PushNotificationTemplate> ret = new ArrayList<PushNotificationTemplate>();
		for (PushNotificationTemplate pushnotificationtemplate : list)
			ret.add(updatePushNotificationTemplate(pushnotificationtemplate));
		return ret;
	}

	@Override public PushNotificationTemplate updatePushNotificationTemplate(PushNotificationTemplate pushnotificationtemplate) throws ASResourceDataServiceException {
		PushNotificationTemplate oldVersion = pushnotificationtemplateMap.put(pushnotificationtemplate.getId(), pushnotificationtemplate);
		if (oldVersion!=null){
				fireObjectUpdatedEvent(oldVersion, pushnotificationtemplate);
		}
		return pushnotificationtemplate;
	}

	@Override public List<PushNotificationTemplate> getPushNotificationTemplatesByProperty(String propertyName, Object value) throws ASResourceDataServiceException {
		List<PushNotificationTemplate> list = getPushNotificationTemplates();
		List<PushNotificationTemplate> ret = new ArrayList<PushNotificationTemplate>();
		for (PushNotificationTemplate pushnotificationtemplate : list){
			Object propertyValue = pushnotificationtemplate.getPropertyValue(propertyName);
			if (propertyValue!=null && propertyValue.equals(value))
				ret.add(pushnotificationtemplate);
		}
		return ret;
	}

	@Override public List<PushNotificationTemplate> getPushNotificationTemplatesByProperty(String propertyName, Object value, SortType sortType) throws ASResourceDataServiceException {
		return StaticQuickSorter.sort(getPushNotificationTemplatesByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on PushNotificationTemplates
	 */
	@Override public QueryResult executeQueryOnPushNotificationTemplates(DocumentQuery query) throws ASResourceDataServiceException {
		List<PushNotificationTemplate> allPushNotificationTemplates = getPushNotificationTemplates();
		QueryResult result = new QueryResult();
		for (int i=0; i<allPushNotificationTemplates.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allPushNotificationTemplates.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all PushNotificationTemplate objects, where property matches.
	 */
	@Override public List<PushNotificationTemplate> getPushNotificationTemplatesByProperty(QueryProperty... properties) throws ASResourceDataServiceException {
		List<PushNotificationTemplate> list = getPushNotificationTemplates();
		if (properties==null || properties.length==0)
			return list;
		List<PushNotificationTemplate> ret = new ArrayList<PushNotificationTemplate>();
		for (PushNotificationTemplate pushnotificationtemplate : list){
			boolean mayPass = true;
			for (QueryProperty p : properties){
				Object propertyValue = pushnotificationtemplate.getPropertyValue(p.getName());
				if (mayPass && (propertyValue==null || (!(p.doesMatch(propertyValue)))))
					mayPass = false;
			}
			if (mayPass)
				ret.add(pushnotificationtemplate);
		}
		return ret;
	}

	/**
	 * Returns all PushNotificationTemplate objects, where property matches, sorted
	 */
	@Override public List<PushNotificationTemplate> getPushNotificationTemplatesByProperty(SortType sortType, QueryProperty... property) throws ASResourceDataServiceException {
		return StaticQuickSorter.sort(getPushNotificationTemplatesByProperty(property), sortType);
	}

	/**
	 * Returns PushNotificationTemplate objects count.
	 */
	@Override public int getPushNotificationTemplatesCount() throws ASResourceDataServiceException {
		return pushnotificationtemplateMap.values().size();
	}

	/**
	 * Returns PushNotificationTemplate objects segment.
	 */
	public List<PushNotificationTemplate> getPushNotificationTemplates(Segment aSegment) throws ASResourceDataServiceException {
		return Slicer.slice(aSegment, getPushNotificationTemplates()).getSliceData();
	}

	/**
	 * Returns PushNotificationTemplate objects segment, where property matched.
	 */
	public List<PushNotificationTemplate> getPushNotificationTemplatesByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<PushNotificationTemplate> ret = new ArrayList<>();
		List<PushNotificationTemplate> src = new ArrayList<>();
		src.addAll(pushnotificationtemplateMap.values());
		for (PushNotificationTemplate pushnotificationtemplate : src) {;
			boolean mayPass = true;
			for (QueryProperty qp : property) {;
				mayPass = mayPass && qp.doesMatch(pushnotificationtemplate.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(pushnotificationtemplate);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns PushNotificationTemplate objects segment, where property matched, sorted.
	 */
	public List<PushNotificationTemplate> getPushNotificationTemplatesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getPushNotificationTemplatesByProperty(aSegment, aProperty), aSortType);
	}

	@Override public List<Image> getImages() throws ASResourceDataServiceException {
		List<Image> ret = new ArrayList<Image>();
		ret.addAll(imageMap.values());
		return ret;
	}

	@Override public List<Image> getImages(SortType sortType) throws ASResourceDataServiceException {
		return StaticQuickSorter.sort(getImages(), sortType);
	}

	@Override public void deleteImage(Image image) throws ASResourceDataServiceException {
		deleteImage(image.getId());
	}

	@Override public void deleteImage(String id) throws ASResourceDataServiceException {
		Image old = imageMap.remove(id);
		if (old!=null){
			fireObjectDeletedEvent(old);
		}
	}

	/**
	 * Deletes multiple Image objects.
	 */
	@Override public void deleteImages(List<Image> list) throws ASResourceDataServiceException {
		for (Image image : list){
			deleteImage(image);
		}
	}

	@Override public Image getImage(String id) throws ASResourceDataServiceException {
		Image image = imageMap.get(id);
		if (image==null)
			throw new ASResourceDataServiceException("No Image with id "+id+" found");
		return image;
	}

	@Override public Image importImage(Image image) throws ASResourceDataServiceException {
		imageMap.put(image.getId(), image);
		return image;
	}

	@Override public List<Image> importImages(List<Image> list) throws ASResourceDataServiceException {
		List<Image> ret = new ArrayList<Image>();
		for (Image image : list)
			ret.add(importImage(image));
		return ret;
	}

	@Override public Image createImage(Image image) throws ASResourceDataServiceException {
		String nextId = ""+imageIdHolder.incrementAndGet();
		// //CMS Specific code
		ImageDocument newImage = (ImageDocument)image;
		newImage.renameTo(nextId);
		imageMap.put(newImage.getId(), newImage);
		fireObjectCreatedEvent(newImage);
		return newImage;
	}

	/**
	 * Creates multiple new Image objects.
	 * Returns the created versions.
	 */
	@Override public List<Image> createImages(List<Image> list) throws ASResourceDataServiceException {
		List<Image> ret = new ArrayList<Image>();
		for (Image image : list)
			ret.add(createImage(image));
		return ret;
	}

	/**
	 * Updates multiple new Image objects.
	 * Returns the updated versions.
	 */
	@Override public List<Image> updateImages(List<Image> list) throws ASResourceDataServiceException {
		List<Image> ret = new ArrayList<Image>();
		for (Image image : list)
			ret.add(updateImage(image));
		return ret;
	}

	@Override public Image updateImage(Image image) throws ASResourceDataServiceException {
		Image oldVersion = imageMap.put(image.getId(), image);
		if (oldVersion!=null){
				fireObjectUpdatedEvent(oldVersion, image);
		}
		return image;
	}

	@Override public List<Image> getImagesByProperty(String propertyName, Object value) throws ASResourceDataServiceException {
		List<Image> list = getImages();
		List<Image> ret = new ArrayList<Image>();
		for (Image image : list){
			Object propertyValue = image.getPropertyValue(propertyName);
			if (propertyValue!=null && propertyValue.equals(value))
				ret.add(image);
		}
		return ret;
	}

	@Override public List<Image> getImagesByProperty(String propertyName, Object value, SortType sortType) throws ASResourceDataServiceException {
		return StaticQuickSorter.sort(getImagesByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on Images
	 */
	@Override public QueryResult executeQueryOnImages(DocumentQuery query) throws ASResourceDataServiceException {
		List<Image> allImages = getImages();
		QueryResult result = new QueryResult();
		for (int i=0; i<allImages.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allImages.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all Image objects, where property matches.
	 */
	@Override public List<Image> getImagesByProperty(QueryProperty... properties) throws ASResourceDataServiceException {
		List<Image> list = getImages();
		if (properties==null || properties.length==0)
			return list;
		List<Image> ret = new ArrayList<Image>();
		for (Image image : list){
			boolean mayPass = true;
			for (QueryProperty p : properties){
				Object propertyValue = image.getPropertyValue(p.getName());
				if (mayPass && (propertyValue==null || (!(p.doesMatch(propertyValue)))))
					mayPass = false;
			}
			if (mayPass)
				ret.add(image);
		}
		return ret;
	}

	/**
	 * Returns all Image objects, where property matches, sorted
	 */
	@Override public List<Image> getImagesByProperty(SortType sortType, QueryProperty... property) throws ASResourceDataServiceException {
		return StaticQuickSorter.sort(getImagesByProperty(property), sortType);
	}

	/**
	 * Returns Image objects count.
	 */
	@Override public int getImagesCount() throws ASResourceDataServiceException {
		return imageMap.values().size();
	}

	/**
	 * Returns Image objects segment.
	 */
	public List<Image> getImages(Segment aSegment) throws ASResourceDataServiceException {
		return Slicer.slice(aSegment, getImages()).getSliceData();
	}

	/**
	 * Returns Image objects segment, where property matched.
	 */
	public List<Image> getImagesByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<Image> ret = new ArrayList<>();
		List<Image> src = new ArrayList<>();
		src.addAll(imageMap.values());
		for (Image image : src) {;
			boolean mayPass = true;
			for (QueryProperty qp : property) {;
				mayPass = mayPass && qp.doesMatch(image.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(image);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns Image objects segment, where property matched, sorted.
	 */
	public List<Image> getImagesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getImagesByProperty(aSegment, aProperty), aSortType);
	}

	@Override public List<FileLink> getFileLinks() throws ASResourceDataServiceException {
		List<FileLink> ret = new ArrayList<FileLink>();
		ret.addAll(filelinkMap.values());
		return ret;
	}

	@Override public List<FileLink> getFileLinks(SortType sortType) throws ASResourceDataServiceException {
		return StaticQuickSorter.sort(getFileLinks(), sortType);
	}

	@Override public void deleteFileLink(FileLink filelink) throws ASResourceDataServiceException {
		deleteFileLink(filelink.getId());
	}

	@Override public void deleteFileLink(String id) throws ASResourceDataServiceException {
		FileLink old = filelinkMap.remove(id);
		if (old!=null){
			fireObjectDeletedEvent(old);
		}
	}

	/**
	 * Deletes multiple FileLink objects.
	 */
	@Override public void deleteFileLinks(List<FileLink> list) throws ASResourceDataServiceException {
		for (FileLink filelink : list){
			deleteFileLink(filelink);
		}
	}

	@Override public FileLink getFileLink(String id) throws ASResourceDataServiceException {
		FileLink filelink = filelinkMap.get(id);
		if (filelink==null)
			throw new ASResourceDataServiceException("No FileLink with id "+id+" found");
		return filelink;
	}

	@Override public FileLink importFileLink(FileLink filelink) throws ASResourceDataServiceException {
		filelinkMap.put(filelink.getId(), filelink);
		return filelink;
	}

	@Override public List<FileLink> importFileLinks(List<FileLink> list) throws ASResourceDataServiceException {
		List<FileLink> ret = new ArrayList<FileLink>();
		for (FileLink filelink : list)
			ret.add(importFileLink(filelink));
		return ret;
	}

	@Override public FileLink createFileLink(FileLink filelink) throws ASResourceDataServiceException {
		String nextId = ""+filelinkIdHolder.incrementAndGet();
		// //CMS Specific code
		FileLinkDocument newFilelink = (FileLinkDocument)filelink;
		newFilelink.renameTo(nextId);
		filelinkMap.put(newFilelink.getId(), newFilelink);
		fireObjectCreatedEvent(newFilelink);
		return newFilelink;
	}

	/**
	 * Creates multiple new FileLink objects.
	 * Returns the created versions.
	 */
	@Override public List<FileLink> createFileLinks(List<FileLink> list) throws ASResourceDataServiceException {
		List<FileLink> ret = new ArrayList<FileLink>();
		for (FileLink filelink : list)
			ret.add(createFileLink(filelink));
		return ret;
	}

	/**
	 * Updates multiple new FileLink objects.
	 * Returns the updated versions.
	 */
	@Override public List<FileLink> updateFileLinks(List<FileLink> list) throws ASResourceDataServiceException {
		List<FileLink> ret = new ArrayList<FileLink>();
		for (FileLink filelink : list)
			ret.add(updateFileLink(filelink));
		return ret;
	}

	@Override public FileLink updateFileLink(FileLink filelink) throws ASResourceDataServiceException {
		FileLink oldVersion = filelinkMap.put(filelink.getId(), filelink);
		if (oldVersion!=null){
				fireObjectUpdatedEvent(oldVersion, filelink);
		}
		return filelink;
	}

	@Override public List<FileLink> getFileLinksByProperty(String propertyName, Object value) throws ASResourceDataServiceException {
		List<FileLink> list = getFileLinks();
		List<FileLink> ret = new ArrayList<FileLink>();
		for (FileLink filelink : list){
			Object propertyValue = filelink.getPropertyValue(propertyName);
			if (propertyValue!=null && propertyValue.equals(value))
				ret.add(filelink);
		}
		return ret;
	}

	@Override public List<FileLink> getFileLinksByProperty(String propertyName, Object value, SortType sortType) throws ASResourceDataServiceException {
		return StaticQuickSorter.sort(getFileLinksByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on FileLinks
	 */
	@Override public QueryResult executeQueryOnFileLinks(DocumentQuery query) throws ASResourceDataServiceException {
		List<FileLink> allFileLinks = getFileLinks();
		QueryResult result = new QueryResult();
		for (int i=0; i<allFileLinks.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allFileLinks.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all FileLink objects, where property matches.
	 */
	@Override public List<FileLink> getFileLinksByProperty(QueryProperty... properties) throws ASResourceDataServiceException {
		List<FileLink> list = getFileLinks();
		if (properties==null || properties.length==0)
			return list;
		List<FileLink> ret = new ArrayList<FileLink>();
		for (FileLink filelink : list){
			boolean mayPass = true;
			for (QueryProperty p : properties){
				Object propertyValue = filelink.getPropertyValue(p.getName());
				if (mayPass && (propertyValue==null || (!(p.doesMatch(propertyValue)))))
					mayPass = false;
			}
			if (mayPass)
				ret.add(filelink);
		}
		return ret;
	}

	/**
	 * Returns all FileLink objects, where property matches, sorted
	 */
	@Override public List<FileLink> getFileLinksByProperty(SortType sortType, QueryProperty... property) throws ASResourceDataServiceException {
		return StaticQuickSorter.sort(getFileLinksByProperty(property), sortType);
	}

	/**
	 * Returns FileLink objects count.
	 */
	@Override public int getFileLinksCount() throws ASResourceDataServiceException {
		return filelinkMap.values().size();
	}

	/**
	 * Returns FileLink objects segment.
	 */
	public List<FileLink> getFileLinks(Segment aSegment) throws ASResourceDataServiceException {
		return Slicer.slice(aSegment, getFileLinks()).getSliceData();
	}

	/**
	 * Returns FileLink objects segment, where property matched.
	 */
	public List<FileLink> getFileLinksByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<FileLink> ret = new ArrayList<>();
		List<FileLink> src = new ArrayList<>();
		src.addAll(filelinkMap.values());
		for (FileLink filelink : src) {;
			boolean mayPass = true;
			for (QueryProperty qp : property) {;
				mayPass = mayPass && qp.doesMatch(filelink.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(filelink);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns FileLink objects segment, where property matched, sorted.
	 */
	public List<FileLink> getFileLinksByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getFileLinksByProperty(aSegment, aProperty), aSortType);
	}


	public XMLNode exportTextResourcesToXML(){
		XMLNode ret = new XMLNode("TextResources");
		try{
			List<TextResource> list = getTextResources();
			ret.addAttribute(new XMLAttribute("count", list.size()));
			for (TextResource object : list)
				ret.addChildNode(TextResourceXMLHelper.toXML(object));
			return ret;
		}
		catch(ASResourceDataServiceException e){
			throw new RuntimeException("exportTextResourcesToXML() failure: " , e);
		}
	}

	public XMLNode exportTextResourcesToXML(List<TextResource> list){
		XMLNode ret = new XMLNode("TextResources");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (TextResource object : list)
			ret.addChildNode(TextResourceXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportTextResourcesToXML(String languages[]){
		XMLNode ret = new XMLNode("TextResources");
		try{
			List<TextResource> list = getTextResources();
			ret.addAttribute(new XMLAttribute("count", list.size()));
			for (TextResource object : list)
				ret.addChildNode(TextResourceXMLHelper.toXML(object, languages));
			return ret;
		}
		catch(ASResourceDataServiceException e){
			throw new RuntimeException("exportTextResourcesToXML() failure: " , e);
		}
	}

	public XMLNode exportTextResourcesToXML(String languages[], List<TextResource> list){
		XMLNode ret = new XMLNode("TextResources");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (TextResource object : list)
			ret.addChildNode(TextResourceXMLHelper.toXML(object, languages));
		return ret;
	}

	public void fetchTextResource (final String id, Set<String> addedDocuments, JSONArray data) throws ASResourceDataServiceException {
		throw new UnsupportedOperationException(" not implemented and should not BE!");
	}

	// This method is not very fast, since it makes an update (eff. save) after each doc.
	public void copyMultilingualAttributesInAllTextResources(String sourceLanguage, String targetLanguage){
		throw new AssertionError("Not implemented");
	}

	public XMLNode exportLocalizationBundlesToXML(){
		XMLNode ret = new XMLNode("LocalizationBundles");
		try{
			List<LocalizationBundle> list = getLocalizationBundles();
			ret.addAttribute(new XMLAttribute("count", list.size()));
			for (LocalizationBundle object : list)
				ret.addChildNode(LocalizationBundleXMLHelper.toXML(object));
			return ret;
		}
		catch(ASResourceDataServiceException e){
			throw new RuntimeException("exportLocalizationBundlesToXML() failure: " , e);
		}
	}

	public XMLNode exportLocalizationBundlesToXML(List<LocalizationBundle> list){
		XMLNode ret = new XMLNode("LocalizationBundles");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (LocalizationBundle object : list)
			ret.addChildNode(LocalizationBundleXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportLocalizationBundlesToXML(String languages[]){
		XMLNode ret = new XMLNode("LocalizationBundles");
		try{
			List<LocalizationBundle> list = getLocalizationBundles();
			ret.addAttribute(new XMLAttribute("count", list.size()));
			for (LocalizationBundle object : list)
				ret.addChildNode(LocalizationBundleXMLHelper.toXML(object, languages));
			return ret;
		}
		catch(ASResourceDataServiceException e){
			throw new RuntimeException("exportLocalizationBundlesToXML() failure: " , e);
		}
	}

	public XMLNode exportLocalizationBundlesToXML(String languages[], List<LocalizationBundle> list){
		XMLNode ret = new XMLNode("LocalizationBundles");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (LocalizationBundle object : list)
			ret.addChildNode(LocalizationBundleXMLHelper.toXML(object, languages));
		return ret;
	}

	public void fetchLocalizationBundle (final String id, Set<String> addedDocuments, JSONArray data) throws ASResourceDataServiceException {
		throw new UnsupportedOperationException(" not implemented and should not BE!");
	}

	// This method is not very fast, since it makes an update (eff. save) after each doc.
	public void copyMultilingualAttributesInAllLocalizationBundles(String sourceLanguage, String targetLanguage){
		throw new AssertionError("Not implemented");
	}

	public XMLNode exportMailTemplatesToXML(){
		XMLNode ret = new XMLNode("MailTemplates");
		try{
			List<MailTemplate> list = getMailTemplates();
			ret.addAttribute(new XMLAttribute("count", list.size()));
			for (MailTemplate object : list)
				ret.addChildNode(MailTemplateXMLHelper.toXML(object));
			return ret;
		}
		catch(ASResourceDataServiceException e){
			throw new RuntimeException("exportMailTemplatesToXML() failure: " , e);
		}
	}

	public XMLNode exportMailTemplatesToXML(List<MailTemplate> list){
		XMLNode ret = new XMLNode("MailTemplates");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (MailTemplate object : list)
			ret.addChildNode(MailTemplateXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportMailTemplatesToXML(String languages[]){
		XMLNode ret = new XMLNode("MailTemplates");
		try{
			List<MailTemplate> list = getMailTemplates();
			ret.addAttribute(new XMLAttribute("count", list.size()));
			for (MailTemplate object : list)
				ret.addChildNode(MailTemplateXMLHelper.toXML(object, languages));
			return ret;
		}
		catch(ASResourceDataServiceException e){
			throw new RuntimeException("exportMailTemplatesToXML() failure: " , e);
		}
	}

	public XMLNode exportMailTemplatesToXML(String languages[], List<MailTemplate> list){
		XMLNode ret = new XMLNode("MailTemplates");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (MailTemplate object : list)
			ret.addChildNode(MailTemplateXMLHelper.toXML(object, languages));
		return ret;
	}

	public void fetchMailTemplate (final String id, Set<String> addedDocuments, JSONArray data) throws ASResourceDataServiceException {
		throw new UnsupportedOperationException(" not implemented and should not BE!");
	}

	// This method is not very fast, since it makes an update (eff. save) after each doc.
	public void copyMultilingualAttributesInAllMailTemplates(String sourceLanguage, String targetLanguage){
		throw new AssertionError("Not implemented");
	}

	public XMLNode exportPdfTemplatesToXML(){
		XMLNode ret = new XMLNode("PdfTemplates");
		try{
			List<PdfTemplate> list = getPdfTemplates();
			ret.addAttribute(new XMLAttribute("count", list.size()));
			for (PdfTemplate object : list)
				ret.addChildNode(PdfTemplateXMLHelper.toXML(object));
			return ret;
		}
		catch(ASResourceDataServiceException e){
			throw new RuntimeException("exportPdfTemplatesToXML() failure: " , e);
		}
	}

	public XMLNode exportPdfTemplatesToXML(List<PdfTemplate> list){
		XMLNode ret = new XMLNode("PdfTemplates");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (PdfTemplate object : list)
			ret.addChildNode(PdfTemplateXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportPdfTemplatesToXML(String languages[]){
		XMLNode ret = new XMLNode("PdfTemplates");
		try{
			List<PdfTemplate> list = getPdfTemplates();
			ret.addAttribute(new XMLAttribute("count", list.size()));
			for (PdfTemplate object : list)
				ret.addChildNode(PdfTemplateXMLHelper.toXML(object, languages));
			return ret;
		}
		catch(ASResourceDataServiceException e){
			throw new RuntimeException("exportPdfTemplatesToXML() failure: " , e);
		}
	}

	public XMLNode exportPdfTemplatesToXML(String languages[], List<PdfTemplate> list){
		XMLNode ret = new XMLNode("PdfTemplates");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (PdfTemplate object : list)
			ret.addChildNode(PdfTemplateXMLHelper.toXML(object, languages));
		return ret;
	}

	public void fetchPdfTemplate (final String id, Set<String> addedDocuments, JSONArray data) throws ASResourceDataServiceException {
		throw new UnsupportedOperationException(" not implemented and should not BE!");
	}

	// This method is not very fast, since it makes an update (eff. save) after each doc.
	public void copyMultilingualAttributesInAllPdfTemplates(String sourceLanguage, String targetLanguage){
		throw new AssertionError("Not implemented");
	}

	public XMLNode exportPushNotificationTemplatesToXML(){
		XMLNode ret = new XMLNode("PushNotificationTemplates");
		try{
			List<PushNotificationTemplate> list = getPushNotificationTemplates();
			ret.addAttribute(new XMLAttribute("count", list.size()));
			for (PushNotificationTemplate object : list)
				ret.addChildNode(PushNotificationTemplateXMLHelper.toXML(object));
			return ret;
		}
		catch(ASResourceDataServiceException e){
			throw new RuntimeException("exportPushNotificationTemplatesToXML() failure: " , e);
		}
	}

	public XMLNode exportPushNotificationTemplatesToXML(List<PushNotificationTemplate> list){
		XMLNode ret = new XMLNode("PushNotificationTemplates");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (PushNotificationTemplate object : list)
			ret.addChildNode(PushNotificationTemplateXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportPushNotificationTemplatesToXML(String languages[]){
		XMLNode ret = new XMLNode("PushNotificationTemplates");
		try{
			List<PushNotificationTemplate> list = getPushNotificationTemplates();
			ret.addAttribute(new XMLAttribute("count", list.size()));
			for (PushNotificationTemplate object : list)
				ret.addChildNode(PushNotificationTemplateXMLHelper.toXML(object, languages));
			return ret;
		}
		catch(ASResourceDataServiceException e){
			throw new RuntimeException("exportPushNotificationTemplatesToXML() failure: " , e);
		}
	}

	public XMLNode exportPushNotificationTemplatesToXML(String languages[], List<PushNotificationTemplate> list){
		XMLNode ret = new XMLNode("PushNotificationTemplates");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (PushNotificationTemplate object : list)
			ret.addChildNode(PushNotificationTemplateXMLHelper.toXML(object, languages));
		return ret;
	}

	public void fetchPushNotificationTemplate (final String id, Set<String> addedDocuments, JSONArray data) throws ASResourceDataServiceException {
		throw new UnsupportedOperationException(" not implemented and should not BE!");
	}

	// This method is not very fast, since it makes an update (eff. save) after each doc.
	public void copyMultilingualAttributesInAllPushNotificationTemplates(String sourceLanguage, String targetLanguage){
		throw new AssertionError("Not implemented");
	}

	public XMLNode exportImagesToXML(){
		XMLNode ret = new XMLNode("Images");
		try{
			List<Image> list = getImages();
			ret.addAttribute(new XMLAttribute("count", list.size()));
			for (Image object : list)
				ret.addChildNode(ImageXMLHelper.toXML(object));
			return ret;
		}
		catch(ASResourceDataServiceException e){
			throw new RuntimeException("exportImagesToXML() failure: " , e);
		}
	}

	public XMLNode exportImagesToXML(List<Image> list){
		XMLNode ret = new XMLNode("Images");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Image object : list)
			ret.addChildNode(ImageXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportImagesToXML(String languages[]){
		XMLNode ret = new XMLNode("Images");
		try{
			List<Image> list = getImages();
			ret.addAttribute(new XMLAttribute("count", list.size()));
			for (Image object : list)
				ret.addChildNode(ImageXMLHelper.toXML(object, languages));
			return ret;
		}
		catch(ASResourceDataServiceException e){
			throw new RuntimeException("exportImagesToXML() failure: " , e);
		}
	}

	public XMLNode exportImagesToXML(String languages[], List<Image> list){
		XMLNode ret = new XMLNode("Images");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Image object : list)
			ret.addChildNode(ImageXMLHelper.toXML(object, languages));
		return ret;
	}

	public void fetchImage (final String id, Set<String> addedDocuments, JSONArray data) throws ASResourceDataServiceException {
		throw new UnsupportedOperationException(" not implemented and should not BE!");
	}

	// This method is not very fast, since it makes an update (eff. save) after each doc.
	public void copyMultilingualAttributesInAllImages(String sourceLanguage, String targetLanguage){
		throw new AssertionError("Not implemented");
	}

	public XMLNode exportFileLinksToXML(){
		XMLNode ret = new XMLNode("FileLinks");
		try{
			List<FileLink> list = getFileLinks();
			ret.addAttribute(new XMLAttribute("count", list.size()));
			for (FileLink object : list)
				ret.addChildNode(FileLinkXMLHelper.toXML(object));
			return ret;
		}
		catch(ASResourceDataServiceException e){
			throw new RuntimeException("exportFileLinksToXML() failure: " , e);
		}
	}

	public XMLNode exportFileLinksToXML(List<FileLink> list){
		XMLNode ret = new XMLNode("FileLinks");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (FileLink object : list)
			ret.addChildNode(FileLinkXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportFileLinksToXML(String languages[]){
		XMLNode ret = new XMLNode("FileLinks");
		try{
			List<FileLink> list = getFileLinks();
			ret.addAttribute(new XMLAttribute("count", list.size()));
			for (FileLink object : list)
				ret.addChildNode(FileLinkXMLHelper.toXML(object, languages));
			return ret;
		}
		catch(ASResourceDataServiceException e){
			throw new RuntimeException("exportFileLinksToXML() failure: " , e);
		}
	}

	public XMLNode exportFileLinksToXML(String languages[], List<FileLink> list){
		XMLNode ret = new XMLNode("FileLinks");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (FileLink object : list)
			ret.addChildNode(FileLinkXMLHelper.toXML(object, languages));
		return ret;
	}

	public void fetchFileLink (final String id, Set<String> addedDocuments, JSONArray data) throws ASResourceDataServiceException {
		throw new UnsupportedOperationException(" not implemented and should not BE!");
	}

	public void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws ASResourceDataServiceException {
		throw new UnsupportedOperationException(" not implemented and should not BE!");
	}

	/**
	 * Copies all multilingual fields from sourceLanguage to targetLanguage in all data objects (documents, vo) which are part of this module and managed by this service
	 */
	public void copyMultilingualAttributesInAllObjects(String sourceLanguage, String targetLanguage){
		copyMultilingualAttributesInAllTextResources(sourceLanguage, targetLanguage);
		copyMultilingualAttributesInAllLocalizationBundles(sourceLanguage, targetLanguage);
		copyMultilingualAttributesInAllMailTemplates(sourceLanguage, targetLanguage);
		copyMultilingualAttributesInAllPdfTemplates(sourceLanguage, targetLanguage);
		copyMultilingualAttributesInAllPushNotificationTemplates(sourceLanguage, targetLanguage);
		copyMultilingualAttributesInAllImages(sourceLanguage, targetLanguage);
	}

	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service
	 */
	public QueryResult executeQueryOnAllObjects(DocumentQuery query) throws ASResourceDataServiceException {
		QueryResult ret = new QueryResult();
		ret.add(executeQueryOnTextResources(query).getEntries());
		ret.add(executeQueryOnLocalizationBundles(query).getEntries());
		ret.add(executeQueryOnMailTemplates(query).getEntries());
		ret.add(executeQueryOnPdfTemplates(query).getEntries());
		ret.add(executeQueryOnPushNotificationTemplates(query).getEntries());
		ret.add(executeQueryOnImages(query).getEntries());
		ret.add(executeQueryOnFileLinks(query).getEntries());
		return ret;
	} //executeQueryOnAllObjects

	@Override public XMLNode exportToXML(){
		XMLNode ret = new XMLNode("ASResourceData");

		ret.addChildNode(exportTextResourcesToXML());
		ret.addChildNode(exportLocalizationBundlesToXML());
		ret.addChildNode(exportMailTemplatesToXML());
		ret.addChildNode(exportPdfTemplatesToXML());
		ret.addChildNode(exportPushNotificationTemplatesToXML());
		ret.addChildNode(exportImagesToXML());
		ret.addChildNode(exportFileLinksToXML());

		return ret;
	}

	@Override public XMLNode exportToXML(String[] languages){
		XMLNode ret = new XMLNode("ASResourceData");

		ret.addChildNode(exportTextResourcesToXML(languages));
		ret.addChildNode(exportLocalizationBundlesToXML(languages));
		ret.addChildNode(exportMailTemplatesToXML(languages));
		ret.addChildNode(exportPdfTemplatesToXML(languages));
		ret.addChildNode(exportPushNotificationTemplatesToXML(languages));
		ret.addChildNode(exportImagesToXML(languages));
		ret.addChildNode(exportFileLinksToXML(languages));

		return ret;
	}
}
