/**
 ********************************************************************************
 *** ImageDocument.java                                                       ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.data;

import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.anodoc.util.context.ContextManager;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.anodoc.data.BooleanProperty;
import net.anotheria.util.crypt.MD5Util;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.BasicComparable;
import net.anotheria.asg.data.MultilingualObject;

public class ImageDocument extends AbstractASGDocument implements Image, IComparable, MultilingualObject{

	public ImageDocument() {
		super("");
	}

	public ImageDocument(String id){
		super(id);
	}

	public ImageDocument(ImageDocument toClone){
		super(toClone);
	}

	ImageDocument(ImageBuilder builder){
		super("");
		setName(builder.name);
		setTitle(builder.title);
		setAlias(builder.alias);
		setAlt(builder.alt);
		setImage(builder.image);
		setSize(builder.size);
		setPixels(builder.pixels);
	}

	public String getName(){
		return getString(PROP_NAME);
	}

	public void setName(String value){
		setString(PROP_NAME, value);
	}

	public String getTitle(){
		return getString(PROP_TITLE);
	}

	public void setTitle(String value){
		setString(PROP_TITLE, value);
	}

	public String getAliasEN(){
		return getString(PROP_ALIAS_EN);
	}

	public String getAlias(){
		return getString("alias_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage()));
	}


	public void setAliasEN(String value){
		setString(PROP_ALIAS_EN, value);
	}

	public void setAlias(String value){
		setString(("alias_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage())), value);
	}


	public String getAltEN(){
		return getString(PROP_ALT_EN);
	}

	public String getAlt(){
		return getString("alt_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage()));
	}


	public void setAltEN(String value){
		setString(PROP_ALT_EN, value);
	}

	public void setAlt(String value){
		setString(("alt_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage())), value);
	}


	public String getImage(){
		return getString(PROP_IMAGE);
	}

	public void setImage(String value){
		setString(PROP_IMAGE, value);
	}

	public String getSize(){
		return getString(PROP_SIZE);
	}

	public void setSize(String value){
		setString(PROP_SIZE, value);
	}

	public String getPixels(){
		return getString(PROP_PIXELS);
	}

	public void setPixels(String value){
		setString(PROP_PIXELS, value);
	}


	public String toString(){
		String ret = "Image ";
		ret += "["+getId()+"] ";
		ret += "name: "+getName();
		ret += ", ";
		ret += "title: "+getTitle();
		ret += ", ";
		ret += "alias: "+getAlias();
		ret += ", ";
		ret += "alt: "+getAlt();
		ret += ", ";
		ret += "image: "+getImage();
		ret += ", ";
		ret += "size: "+getSize();
		ret += ", ";
		ret += "pixels: "+getPixels();
		return ret;
	}


	public int compareTo(Image comparable){
		return compareTo(comparable, ImageSortType.SORT_BY_DEFAULT);
	}

	public int compareTo(IComparable anotherComparable, int method){
		ImageDocument anotherDoc = (ImageDocument) anotherComparable;
		switch(method){
			case ImageSortType.SORT_BY_ID:
				return BasicComparable.compareString(getId(), anotherDoc.getId());
			case ImageSortType.SORT_BY_NAME:
				return BasicComparable.compareString(getName(), anotherDoc.getName());
			case ImageSortType.SORT_BY_TITLE:
				return BasicComparable.compareString(getTitle(), anotherDoc.getTitle());
			case ImageSortType.SORT_BY_ALIAS:
				return BasicComparable.compareString(getAlias(), anotherDoc.getAlias());
			case ImageSortType.SORT_BY_ALT:
				return BasicComparable.compareString(getAlt(), anotherDoc.getAlt());
			case ImageSortType.SORT_BY_IMAGE:
				return BasicComparable.compareString(getImage(), anotherDoc.getImage());
			case ImageSortType.SORT_BY_SIZE:
				return BasicComparable.compareString(getSize(), anotherDoc.getSize());
			case ImageSortType.SORT_BY_PIXELS:
				return BasicComparable.compareString(getPixels(), anotherDoc.getPixels());
			default:
				throw new RuntimeException("Sort method "+method+" is not supported.");
		}
	}

	public String getDefinedName(){
		return "Image";
	}

	public String getDefinedParentName(){
		return "ASResourceData";
	}

	public String getFootprint(){
		StringBuilder footprint = new StringBuilder();
		footprint.append(getName());
		footprint.append(getTitle());
		footprint.append(getAliasEN());
		footprint.append(getAltEN());
		footprint.append(getImage());
		footprint.append(getSize());
		footprint.append(getPixels());
		return MD5Util.getMD5Hash(footprint);
	}
	public void copyLANG2LANG(String sourceLanguage, String destLanguage){
	}


	public boolean isMultilingualDisabledInstance(){
		try{
			return ((BooleanProperty)getInternalProperty(INT_PROPERTY_MULTILINGUAL_DISABLED)).getboolean();
		}catch(NoSuchPropertyException e){
			return false;
		}
	}

	public void setMultilingualDisabledInstance(boolean value){
		setInternalProperty(new BooleanProperty(INT_PROPERTY_MULTILINGUAL_DISABLED, value));
	}

	public boolean equals(Object o){
		return o == this || ((o instanceof ImageDocument) && ((ImageDocument)o).getId().equals(getId()));
	}
}
