/**
 ********************************************************************************
 *** BasePushNotificationTemplateAction.java                                  ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.action;

import net.anotheria.anosite.gen.shared.action.BaseResourcesAction;
import jakarta.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.asresourcedata.data.PushNotificationTemplate;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BasePushNotificationTemplateAction extends BaseResourcesAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Push Notification Templates";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASResourceData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "PushNotificationTemplate";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, PushNotificationTemplate pushnotificationtemplate) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASResourceData.PushNotificationTemplate").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.PushNotificationTemplate", pushnotificationtemplate, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.PushNotificationTemplate", pushnotificationtemplate, "message");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.message", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.PushNotificationTemplate", pushnotificationtemplate, "localizations");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.localizations", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockPushNotificationTemplates(PushNotificationTemplate pushnotificationtemplate, HttpServletRequest req) throws Exception{
		if(pushnotificationtemplate instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)pushnotificationtemplate;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASResourceDataService().updatePushNotificationTemplate( pushnotificationtemplate);
			logger.info("Lock-OPERATION, document with id : ["+pushnotificationtemplate.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockPushNotificationTemplates(PushNotificationTemplate pushnotificationtemplate, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(pushnotificationtemplate instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)pushnotificationtemplate;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASResourceDataService().updatePushNotificationTemplate( pushnotificationtemplate);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+pushnotificationtemplate.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+pushnotificationtemplate.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkPushNotificationTemplates(PushNotificationTemplate pushnotificationtemplate, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = pushnotificationtemplate instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)pushnotificationtemplate).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)pushnotificationtemplate).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockPushNotificationTemplates(pushnotificationtemplate, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdatePushNotificationTemplates(PushNotificationTemplate pushnotificationtemplate, HttpServletRequest req) throws Exception{
		if(pushnotificationtemplate instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)pushnotificationtemplate, false, getUserId(req));
		}
		if (isTimeoutReached(pushnotificationtemplate)) {
			checkPushNotificationTemplates(pushnotificationtemplate, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(pushnotificationtemplate, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(PushNotificationTemplate pushnotificationtemplate){
		if (pushnotificationtemplate instanceof LockableObject) {
			LockableObject lock = (LockableObject)pushnotificationtemplate;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(PushNotificationTemplate pushnotificationtemplate, HttpServletRequest req){
		if (pushnotificationtemplate instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)pushnotificationtemplate;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
