/**
 ********************************************************************************
 *** MultiOpDialogPageLayoutsAction.java                                      ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aslayoutdata.action;

import net.anotheria.util.NumberUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.aslayoutdata.data.PageLayoutFactory;
import net.anotheria.anosite.gen.aslayoutdata.data.PageLayout;
import net.anotheria.anosite.gen.aslayoutdata.bean.EditPageLayoutFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;

public class MultiOpDialogPageLayoutsAction extends BasePageLayoutAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("aslayoutdataPageLayoutDelete"))
			return aslayoutdataPageLayoutDelete(mapping, req, res);
		if (path.equals("aslayoutdataPageLayoutDuplicate"))
			return aslayoutdataPageLayoutDuplicate(mapping, req, res);
		if (path.equals("aslayoutdataPageLayoutUpdate"))
			return aslayoutdataPageLayoutUpdate(mapping, req, res);
		if (path.equals("aslayoutdataPageLayoutClose"))
			return aslayoutdataPageLayoutClose(mapping, req, res);
		if (path.equals("aslayoutdataPageLayoutLock"))
			return aslayoutdataPageLayoutLock(mapping, req, res);
		if (path.equals("aslayoutdataPageLayoutUnLock"))
			return aslayoutdataPageLayoutUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand aslayoutdataPageLayoutDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			PageLayout pagelayoutCurr = getASLayoutDataService().getPageLayout(id);
			if (pagelayoutCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)pagelayoutCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASLayoutDataService().deletePageLayout(id);
		}
		res.sendRedirect("aslayoutdataPageLayoutShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand aslayoutdataPageLayoutDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		PageLayout pagelayoutSrc = getASLayoutDataService().getPageLayout(id);
		PageLayout pagelayoutDest = PageLayoutFactory.createPageLayout(pagelayoutSrc);


		PageLayout pagelayoutCreated = getASLayoutDataService().createPageLayout(pagelayoutDest);
		res.sendRedirect("aslayoutdataPageLayoutEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+pagelayoutCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand aslayoutdataPageLayoutUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditPageLayoutFB form = new EditPageLayoutFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		PageLayout pagelayout = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		pagelayout = (PageLayout)getASLayoutDataService().getPageLayout(form.getId()).clone();
	}else{
		pagelayout = PageLayoutFactory.createPageLayout();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	pagelayout.setName(form.getName());
	pagelayout.setLayoutpage(form.getLayoutpage());
	pagelayout.setStyle(form.getStyle());
	pagelayout.setDescription(form.getDescription());

	PageLayout updatedCopy = null;
	if (create){
		updatedCopy = getASLayoutDataService().createPageLayout(pagelayout);
	}else{
		canUpdatePageLayouts(pagelayout, req);
		checkPageLayouts(pagelayout, req);
		updatedCopy = getASLayoutDataService().updatePageLayout(pagelayout);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("aslayoutdataPageLayoutEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(pagelayout, req);
		res.sendRedirect("aslayoutdataPageLayoutShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(PageLayout pagelayout, HttpServletRequest req) throws Exception{
	if(((LockableObject)pagelayout).isLocked())
		unLockPageLayouts(pagelayout, req, false);
}

public ActionCommand aslayoutdataPageLayoutLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	PageLayout pagelayoutCurr = id != null && !id.equals("") ? getASLayoutDataService().getPageLayout(id) : null;
	if(pagelayoutCurr != null && pagelayoutCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)pagelayoutCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockPageLayouts(pagelayoutCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, pagelayoutCurr));
	return null;
}

public ActionCommand aslayoutdataPageLayoutUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	PageLayout pagelayoutCurr = id != null && !id.equals("") ? getASLayoutDataService().getPageLayout(id) : null;
	if(pagelayoutCurr != null && pagelayoutCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)pagelayoutCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockPageLayouts(pagelayoutCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, pagelayoutCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, PageLayout item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "aslayoutdataPageLayoutShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "aslayoutdataPageLayoutEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "aslayoutdataPageLayoutShow?ts="+System.currentTimeMillis();
}

public ActionCommand aslayoutdataPageLayoutClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	PageLayout pagelayoutCurr = id != null && !id.equals("") ? getASLayoutDataService().getPageLayout(id) : null;
	if(pagelayoutCurr != null && pagelayoutCurr instanceof LockableObject && ((LockableObject)pagelayoutCurr).isLocked()) 
		unLockPageLayouts(pagelayoutCurr, req, false);
	res.sendRedirect("aslayoutdataPageLayoutShow?ts="+System.currentTimeMillis());
	return null;
}

}
