/**
 ********************************************************************************
 *** MultiOpDialogBrandFeaturesAction.java                                    ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asfeature.action;

import net.anotheria.util.NumberUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.asfeature.data.BrandFeatureFactory;
import net.anotheria.anosite.gen.asfeature.data.BrandFeature;
import net.anotheria.anosite.gen.asfeature.bean.EditBrandFeatureFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;

public class MultiOpDialogBrandFeaturesAction extends BaseBrandFeatureAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("asfeatureBrandFeatureDelete"))
			return asfeatureBrandFeatureDelete(mapping, req, res);
		if (path.equals("asfeatureBrandFeatureDuplicate"))
			return asfeatureBrandFeatureDuplicate(mapping, req, res);
		if (path.equals("asfeatureBrandFeatureUpdate"))
			return asfeatureBrandFeatureUpdate(mapping, req, res);
		if (path.equals("asfeatureBrandFeatureClose"))
			return asfeatureBrandFeatureClose(mapping, req, res);
		if (path.equals("asfeatureBrandFeatureLock"))
			return asfeatureBrandFeatureLock(mapping, req, res);
		if (path.equals("asfeatureBrandFeatureUnLock"))
			return asfeatureBrandFeatureUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand asfeatureBrandFeatureDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			BrandFeature brandfeatureCurr = getASFeatureService().getBrandFeature(id);
			if (brandfeatureCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)brandfeatureCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASFeatureService().deleteBrandFeature(id);
		}
		res.sendRedirect("asfeatureBrandFeatureShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand asfeatureBrandFeatureDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		BrandFeature brandfeatureSrc = getASFeatureService().getBrandFeature(id);
		BrandFeature brandfeatureDest = BrandFeatureFactory.createBrandFeature(brandfeatureSrc);




		BrandFeature brandfeatureCreated = getASFeatureService().createBrandFeature(brandfeatureDest);
		res.sendRedirect("asfeatureBrandFeatureEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+brandfeatureCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand asfeatureBrandFeatureUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditBrandFeatureFB form = new EditBrandFeatureFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		BrandFeature brandfeature = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		brandfeature = (BrandFeature)getASFeatureService().getBrandFeature(form.getId()).clone();
	}else{
		brandfeature = BrandFeatureFactory.createBrandFeature();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	brandfeature.setName(form.getName());
	brandfeature.setEnabled(form.isEnabled());
	brandfeature.setActiveInProduction(form.isActiveInProduction());
	brandfeature.setObsolete(form.isObsolete());
	// skipped container brands
	// skipped container guards
	brandfeature.setAccessOperation(form.getAccessOperation());
	brandfeature.setDescription(form.getDescription());

	BrandFeature updatedCopy = null;
	if (create){
		updatedCopy = getASFeatureService().createBrandFeature(brandfeature);
	}else{
		canUpdateBrandFeatures(brandfeature, req);
		checkBrandFeatures(brandfeature, req);
		updatedCopy = getASFeatureService().updateBrandFeature(brandfeature);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("asfeatureBrandFeatureEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(brandfeature, req);
		res.sendRedirect("asfeatureBrandFeatureShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(BrandFeature brandfeature, HttpServletRequest req) throws Exception{
	if(((LockableObject)brandfeature).isLocked())
		unLockBrandFeatures(brandfeature, req, false);
}

public ActionCommand asfeatureBrandFeatureLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	BrandFeature brandfeatureCurr = id != null && !id.equals("") ? getASFeatureService().getBrandFeature(id) : null;
	if(brandfeatureCurr != null && brandfeatureCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)brandfeatureCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockBrandFeatures(brandfeatureCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, brandfeatureCurr));
	return null;
}

public ActionCommand asfeatureBrandFeatureUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	BrandFeature brandfeatureCurr = id != null && !id.equals("") ? getASFeatureService().getBrandFeature(id) : null;
	if(brandfeatureCurr != null && brandfeatureCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)brandfeatureCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockBrandFeatures(brandfeatureCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, brandfeatureCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, BrandFeature item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "asfeatureBrandFeatureShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "asfeatureBrandFeatureEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "asfeatureBrandFeatureShow?ts="+System.currentTimeMillis();
}

public ActionCommand asfeatureBrandFeatureClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	BrandFeature brandfeatureCurr = id != null && !id.equals("") ? getASFeatureService().getBrandFeature(id) : null;
	if(brandfeatureCurr != null && brandfeatureCurr instanceof LockableObject && ((LockableObject)brandfeatureCurr).isLocked()) 
		unLockBrandFeatures(brandfeatureCurr, req, false);
	res.sendRedirect("asfeatureBrandFeatureShow?ts="+System.currentTimeMillis());
	return null;
}

}
