/**
 ********************************************************************************
 *** ModuleASExperiment.java                                                  ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asexperiment.data;

import net.anotheria.anodoc.data.Module;
import net.anotheria.anodoc.data.DocumentList;
import net.anotheria.anodoc.data.IDHolder;
import net.anotheria.anodoc.data.NoSuchDocumentListException;
import java.util.List;

public class ModuleASExperiment extends Module{


	public static final String MODULE_ID = "asexperiment";

	public static final String LIST_EXPERIMENT = "list_experiment";
	public static final String ID_HOLDER_EXPERIMENT = IDHolder.DOC_ID_HOLDER_PRE+"experiment";

	public ModuleASExperiment(){
		super(MODULE_ID);
	}

	@SuppressWarnings("unchecked")
	private DocumentList<ExperimentDocument> _getExperiments(){
		try{
			return getList(LIST_EXPERIMENT);
		}catch(NoSuchDocumentListException e){
			return new DocumentList<ExperimentDocument>(LIST_EXPERIMENT);
		}
	}

	private void _updateExperiments(DocumentList<ExperimentDocument> list){
		putList(list);
	}

	public List<ExperimentDocument> getExperiments(){
		return _getExperiments().getList();
	}

	public ExperimentDocument getExperiment(String id){
		return _getExperiments().getDocumentById(id);
	}

	public void updateExperiment(ExperimentDocument experiment){
		DocumentList<ExperimentDocument> experiments = _getExperiments();
		experiments.removeDocumentById(experiment.getId());
		experiment.setLastUpdateNow();
		experiment.setCallContextAuthor();
		experiments.addDocument(experiment);
		_updateExperiments(experiments);
	}

	public void deleteExperiment(String id){
		DocumentList<ExperimentDocument> entries = _getExperiments();
		entries.removeDocumentById(id);
		_updateExperiments(entries);
	}

	public ExperimentDocument createExperiment(ExperimentDocument experiment ){
		IDHolder idh = _getIdHolder(ID_HOLDER_EXPERIMENT);
		int id = idh.getNextIdInt();
		experiment.renameTo(""+id);
		putDocument(idh);

		DocumentList<ExperimentDocument> entries = _getExperiments();
		experiment.setLastUpdateNow();
		experiment.setCallContextAuthor();
		entries.addDocument(experiment);
		_updateExperiments(entries);
		return experiment;
	}

	public ExperimentDocument importExperiment(ExperimentDocument experiment ){
		IDHolder idh = _getIdHolder(ID_HOLDER_EXPERIMENT);
		idh.adjustTill(experiment.getId());
		putDocument(idh);

		DocumentList<ExperimentDocument> entries = _getExperiments();
		experiment.setLastUpdateNow();
		experiment.setCallContextAuthor();
		entries.addDocument(experiment);
		_updateExperiments(entries);
		return experiment;
	}


}
