/**
 ********************************************************************************
 *** ShowCustomGuardDefsAction.java                                           ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.ascustomdata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.ascustomdata.data.CustomGuardDef;
import net.anotheria.anosite.gen.ascustomdata.bean.CustomGuardDefListItemBean;
import net.anotheria.asg.data.LockableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.ascustomdata.bean.CustomGuardDefListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;

public class ShowCustomGuardDefsAction extends BaseCustomGuardDefAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"CustomGuardDef";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"CustomGuardDef";
	private static Logger log = LoggerFactory.getLogger(ShowCustomGuardDefsAction.class);
	private Sorter<CustomGuardDefListItemBean> sorter;

	private IAttributeDecorator idDecorator;
	private IAttributeDecorator nameDecorator;

	private DocumentFilter nameFilterAZ;

	public ShowCustomGuardDefsAction(){
		sorter = new QuickSorter<CustomGuardDefListItemBean>();
		try{ 
			idDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.IDItoADecorator").newInstance();
			nameDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate decorator:", e);
		}
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		int sortMethod = CustomGuardDefListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = CustomGuardDefListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		CustomGuardDefListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new CustomGuardDefListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (CustomGuardDefListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new CustomGuardDefListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<CustomGuardDef> _unfiltered_customguarddefs = getASCustomDataService().getCustomGuardDefs();
		List<CustomGuardDef> customguarddefs = new ArrayList<CustomGuardDef>();
		for (int i=0; i<_unfiltered_customguarddefs.size(); i++){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass(_unfiltered_customguarddefs.get(i), "name", filterParameter0));
			if (mayPass)
				customguarddefs.add(_unfiltered_customguarddefs.get(i));
		}
		List<CustomGuardDefListItemBean> beans = new ArrayList<CustomGuardDefListItemBean>(customguarddefs.size());
		for (CustomGuardDef customguarddef : customguarddefs){
			checkCustomGuardDefs(customguarddef, req);
			CustomGuardDefListItemBean bean = makeCustomGuardDefListItemBean(customguarddef);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "customguarddefs", beans);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer("name"));
		return mapping.success();
	}

	protected CustomGuardDefListItemBean makeCustomGuardDefListItemBean(CustomGuardDef customguarddef) {
		CustomGuardDefListItemBean bean = new CustomGuardDefListItemBean();
		bean.setPlainId(customguarddef.getId());
		bean.setIdForSorting(customguarddef.getId());
		bean.setId(idDecorator.decorate(customguarddef, "id", "3"));
		bean.setNameForSorting(customguarddef.getName());
		bean.setName(nameDecorator.decorate(customguarddef, "name", "null"));
		bean.setClazz(customguarddef.getClazz());
		bean.setLocked(((LockableObject)customguarddef).isLocked());
		bean.setLockerId(((LockableObject)customguarddef).getLockerId());
		bean.setLockingTime(NumberUtils.makeISO8601TimestampString(((LockableObject)customguarddef).getLockingTime()) + " till: " + NumberUtils.makeISO8601TimestampString(((LockableObject)customguarddef).getLockingTime() + getLockingTimeout()));
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(customguarddef.getLastUpdateTimestamp()));
		return bean;
	}
}
