/**
 ********************************************************************************
 *** BrandDocument.java                                                       ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asbrand.data;

import net.anotheria.asg.data.AbstractASGDocument;
import java.util.List;
import net.anotheria.anodoc.data.StringProperty;
import net.anotheria.util.crypt.MD5Util;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.BasicComparable;

public class BrandDocument extends AbstractASGDocument implements Brand, IComparable{

	public BrandDocument() {
		super("");
	}

	public BrandDocument(String id){
		super(id);
	}

	public BrandDocument(BrandDocument toClone){
		super(toClone);
	}

	BrandDocument(BrandBuilder builder){
		super("");
		setName(builder.name);
		setDefaultBrand(builder.defaultBrand);
		setUrlsToMap(builder.urlsToMap);
		setLocalizations(builder.localizations);
		setMediaLinks(builder.mediaLinks);
		setAttributes(builder.attributes);
	}

	public String getName(){
		return getString(PROP_NAME);
	}

	public void setName(String value){
		setString(PROP_NAME, value);
	}

	public boolean getDefaultBrand(){
		return getBoolean(PROP_DEFAULT_BRAND);
	}

	public void setDefaultBrand(boolean value){
		setBoolean(PROP_DEFAULT_BRAND, value);
	}

	public List<String> getUrlsToMap(){
		return copyToStringList(getList(PROP_URLS_TO_MAP));
	}

	public void setUrlsToMap(List<String> value){
		setList(PROP_URLS_TO_MAP, copyFromStringList(value));
	}

	public List<String> getLocalizations(){
		return copyToStringList(getList(PROP_LOCALIZATIONS));
	}

	public void setLocalizations(List<String> value){
		setList(PROP_LOCALIZATIONS, copyFromStringList(value));
	}

	public List<String> getMediaLinks(){
		return copyToStringList(getList(PROP_MEDIA_LINKS));
	}

	public void setMediaLinks(List<String> value){
		setList(PROP_MEDIA_LINKS, copyFromStringList(value));
	}

	public List<String> getAttributes(){
		return copyToStringList(getList(PROP_ATTRIBUTES));
	}

	public void setAttributes(List<String> value){
		setList(PROP_ATTRIBUTES, copyFromStringList(value));
	}


	public String toString(){
		String ret = "Brand ";
		ret += "["+getId()+"] ";
		ret += "name: "+getName();
		ret += ", ";
		ret += "defaultBrand: "+getDefaultBrand();
		ret += ", ";
		ret += "urlsToMap: "+getUrlsToMap();
		ret += ", ";
		ret += "localizations: "+getLocalizations();
		ret += ", ";
		ret += "mediaLinks: "+getMediaLinks();
		ret += ", ";
		ret += "attributes: "+getAttributes();
		return ret;
	}

	public int getUrlsToMapSize(){
		return getList(PROP_URLS_TO_MAP).size();
	}

	public void addUrlsToMapElement(String urlToMap){
		getListPropertyAnyCase(PROP_URLS_TO_MAP).add(new StringProperty("" + urlToMap, urlToMap));
	} //method

	public void removeUrlsToMapElement(int index){
		getListProperty(PROP_URLS_TO_MAP).remove(index);
	} //method

	public void swapUrlsToMapElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_URLS_TO_MAP).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_URLS_TO_MAP).get(index2)).getString();
		((StringProperty)getList(PROP_URLS_TO_MAP).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_URLS_TO_MAP).get(index2)).setString(tmp1);
	} //method

	public String getUrlsToMapElement(int index){
		StringProperty p = (StringProperty)getList(PROP_URLS_TO_MAP).get(index);
		return p.getString();
	} //method

	public int getLocalizationsSize(){
		return getList(PROP_LOCALIZATIONS).size();
	}

	public void addLocalizationsElement(String localization){
		getListPropertyAnyCase(PROP_LOCALIZATIONS).add(new StringProperty("" + localization, localization));
	} //method

	public void removeLocalizationsElement(int index){
		getListProperty(PROP_LOCALIZATIONS).remove(index);
	} //method

	public void swapLocalizationsElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_LOCALIZATIONS).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_LOCALIZATIONS).get(index2)).getString();
		((StringProperty)getList(PROP_LOCALIZATIONS).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_LOCALIZATIONS).get(index2)).setString(tmp1);
	} //method

	public String getLocalizationsElement(int index){
		StringProperty p = (StringProperty)getList(PROP_LOCALIZATIONS).get(index);
		return p.getString();
	} //method

	public int getMediaLinksSize(){
		return getList(PROP_MEDIA_LINKS).size();
	}

	public void addMediaLinksElement(String mediaLink){
		getListPropertyAnyCase(PROP_MEDIA_LINKS).add(new StringProperty("" + mediaLink, mediaLink));
	} //method

	public void removeMediaLinksElement(int index){
		getListProperty(PROP_MEDIA_LINKS).remove(index);
	} //method

	public void swapMediaLinksElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_MEDIA_LINKS).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_MEDIA_LINKS).get(index2)).getString();
		((StringProperty)getList(PROP_MEDIA_LINKS).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_MEDIA_LINKS).get(index2)).setString(tmp1);
	} //method

	public String getMediaLinksElement(int index){
		StringProperty p = (StringProperty)getList(PROP_MEDIA_LINKS).get(index);
		return p.getString();
	} //method

	public int getAttributesSize(){
		return getList(PROP_ATTRIBUTES).size();
	}

	public void addAttributesElement(String attribute){
		getListPropertyAnyCase(PROP_ATTRIBUTES).add(new StringProperty("" + attribute, attribute));
	} //method

	public void removeAttributesElement(int index){
		getListProperty(PROP_ATTRIBUTES).remove(index);
	} //method

	public void swapAttributesElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_ATTRIBUTES).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_ATTRIBUTES).get(index2)).getString();
		((StringProperty)getList(PROP_ATTRIBUTES).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_ATTRIBUTES).get(index2)).setString(tmp1);
	} //method

	public String getAttributesElement(int index){
		StringProperty p = (StringProperty)getList(PROP_ATTRIBUTES).get(index);
		return p.getString();
	} //method


	public int compareTo(Brand comparable){
		return compareTo(comparable, BrandSortType.SORT_BY_DEFAULT);
	}

	public int compareTo(IComparable anotherComparable, int method){
		BrandDocument anotherDoc = (BrandDocument) anotherComparable;
		switch(method){
			case BrandSortType.SORT_BY_ID:
				return BasicComparable.compareString(getId(), anotherDoc.getId());
			case BrandSortType.SORT_BY_NAME:
				return BasicComparable.compareString(getName(), anotherDoc.getName());
			case BrandSortType.SORT_BY_DEFAULTBRAND:
				return BasicComparable.compareBoolean(getDefaultBrand(), anotherDoc.getDefaultBrand());
			default:
				throw new RuntimeException("Sort method "+method+" is not supported.");
		}
	}

	public String getDefinedName(){
		return "Brand";
	}

	public String getDefinedParentName(){
		return "ASBrand";
	}

	public String getFootprint(){
		StringBuilder footprint = new StringBuilder();
		footprint.append(getName());
		footprint.append(getDefaultBrand());
		footprint.append(getUrlsToMap());
		footprint.append(getLocalizations());
		footprint.append(getMediaLinks());
		footprint.append(getAttributes());
		return MD5Util.getMD5Hash(footprint);
	}

	public boolean equals(Object o){
		return o == this || ((o instanceof BrandDocument) && ((BrandDocument)o).getId().equals(getId()));
	}
}
