/**
 ********************************************************************************
 *** MultiOpBrandsMediaLinksAction.java                                       ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asbrand.action;

import java.util.List;
import java.util.ArrayList;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.asbrand.data.BrandFactory;
import net.anotheria.anosite.gen.asbrand.data.Brand;
import net.anotheria.anosite.gen.asbrand.bean.MediaLinksElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.asbrand.bean.MediaLinksQuickAddFB;
import net.anotheria.anosite.gen.assitedata.data.MediaLink;
import net.anotheria.anosite.gen.assitedata.data.MediaLinkSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpBrandsMediaLinksAction extends BaseBrandAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("asbrandBrandMediaLinksShow"))
			return asbrandBrandMediaLinksShow(mapping, req, res);
		if (path.equals("asbrandBrandMediaLinksAdd"))
			return asbrandBrandMediaLinksAdd(mapping, req, res);
		if (path.equals("asbrandBrandMediaLinksDelete"))
			return asbrandBrandMediaLinksDelete(mapping, req, res);
		if (path.equals("asbrandBrandMediaLinksMove"))
			return asbrandBrandMediaLinksMove(mapping, req, res);
		if (path.equals("asbrandBrandMediaLinksQuickAdd"))
			return asbrandBrandMediaLinksQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand asbrandBrandMediaLinksShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Brand brand = getASBrandService().getBrand(id);
		addBeanToRequest(req, "ownerId", id);
		checkBrands(brand, req);

		MediaLinksElementFB form = new MediaLinksElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(brand.getId());
		addBeanToRequest(req, "asbrandBrandMediaLinksElementForm", form);

		MediaLinksQuickAddFB quickAddForm = new MediaLinksQuickAddFB() ;
		quickAddForm.setOwnerId(brand.getId());
		addBeanToRequest(req, "asbrandBrandMediaLinksQuickAddForm", quickAddForm);


		//link mediaLink to ASSiteData.MediaLink
		List<MediaLink> medialinks = getASSiteDataService().getMediaLinks(new MediaLinkSortType(MediaLinkSortType.SORT_BY_NAME));
		List<LabelValueBean> medialinksValues = new ArrayList<LabelValueBean>(medialinks.size());
		for (int i=0; i<medialinks.size(); i++){
			net.anotheria.anosite.gen.assitedata.data.MediaLink tmp_medialink = (net.anotheria.anosite.gen.assitedata.data.MediaLink) medialinks.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_medialink.getId(), tmp_medialink.getName()+" ["+tmp_medialink.getId()+"]" );
			medialinksValues.add(bean);
		}
		addBeanToRequest(req, "medialinkValuesCollection", medialinksValues);
		// generate list ...
		int size = brand.getMediaLinksSize();
		List<MediaLinksElementFB> beans = new ArrayList<MediaLinksElementFB>(size);
		for (int i=0; i<size; i++){
			String value = brand.getMediaLinksElement(i);
			MediaLinksElementFB bean = new MediaLinksElementFB();
			bean.setOwnerId(brand.getId());
			bean.setPosition(i);
			bean.setMediaLink(value);
			try{
				MediaLink tmp_medialink = getASSiteDataService().getMediaLink(value);
				bean.setDescription(tmp_medialink.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand asbrandBrandMediaLinksDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Brand brandCurr = getASBrandService().getBrand(id);
		canUpdateBrands(brandCurr, req);
		checkBrands(brandCurr, req);
		int position = getIntParameter(req, "pPosition");
		Brand brand = getASBrandService().getBrand(id);
		brand.removeMediaLinksElement(position);
		getASBrandService().updateBrand(brand);
		return asbrandBrandMediaLinksShow(mapping, req, res);
	}

	public ActionCommand asbrandBrandMediaLinksMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		Brand brand = getASBrandService().getBrand(id);
		canUpdateBrands(brand, req);
		checkBrands(brand, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(brand, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(brand, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(brand, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(brand, position);
		return asbrandBrandMediaLinksShow(mapping, req, res);
	}

	private void moveUp(Brand brand, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		brand.swapMediaLinksElement(position, position-1);
		getASBrandService().updateBrand(brand);
	}

	private void moveTop(Brand brand, int position) throws ASGRuntimeException {
		List<String> targetList = brand.getMediaLinks();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		brand.setMediaLinks(targetList);
		getASBrandService().updateBrand(brand);
	}

	private void moveDown(Brand brand, int position) throws ASGRuntimeException {
		if (position<brand.getMediaLinksSize()-1){
			brand.swapMediaLinksElement(position, position+1);
			getASBrandService().updateBrand(brand);
		}
	}

	private void moveBottom(Brand brand, int position) throws ASGRuntimeException {
		List<String> targetList = brand.getMediaLinks();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		brand.setMediaLinks(targetList);
		getASBrandService().updateBrand(brand);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand asbrandBrandMediaLinksAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		MediaLinksElementFB form = new MediaLinksElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Brand brand;
		brand = getASBrandService().getBrand(id);
		canUpdateBrands(brand, req);
		checkBrands(brand, req);
		brand.addMediaLinksElement(form.getMediaLink());
		getASBrandService().updateBrand(brand);
		return asbrandBrandMediaLinksShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand asbrandBrandMediaLinksQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		MediaLinksQuickAddFB form = new MediaLinksQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Brand brand;
		brand = getASBrandService().getBrand(id);
		canUpdateBrands(brand, req);
		checkBrands(brand, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				brand.addMediaLinksElement(""+i);
			}
		}
		getASBrandService().updateBrand(brand);
		return asbrandBrandMediaLinksShow(mapping, req, res);
	}

}
